/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.data.projection.Accessor;
import org.springframework.util.ReflectionUtils;

class MapAccessingMethodInterceptor
implements MethodInterceptor {
    @NonNull
    private final Map<String, Object> map;

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (ReflectionUtils.isObjectMethod((Method)method)) {
            return invocation.proceed();
        }
        Accessor accessor = new Accessor(method);
        if (accessor.isGetter()) {
            return this.map.get(accessor.getPropertyName());
        }
        if (accessor.isSetter()) {
            this.map.put(accessor.getPropertyName(), invocation.getArguments()[0]);
            return null;
        }
        throw new IllegalStateException("Should never get here!");
    }

    @Generated
    public MapAccessingMethodInterceptor(@NonNull Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is marked non-null but is null");
        }
        this.map = map;
    }
}

