/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.List;
import org.springframework.data.elasticsearch.core.IndexedObjectInformation;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.GetQuery;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.query.UpdateResponse;
import org.springframework.lang.Nullable;

public interface DocumentOperations {
    public <T> T save(T var1);

    public <T> T save(T var1, IndexCoordinates var2);

    public <T> Iterable<T> save(Iterable<T> var1);

    public <T> Iterable<T> save(Iterable<T> var1, IndexCoordinates var2);

    public <T> Iterable<T> save(T ... var1);

    public String index(IndexQuery var1, IndexCoordinates var2);

    @Nullable
    public <T> T get(String var1, Class<T> var2);

    @Nullable
    public <T> T get(String var1, Class<T> var2, IndexCoordinates var3);

    public <T> List<T> multiGet(Query var1, Class<T> var2);

    public <T> List<T> multiGet(Query var1, Class<T> var2, IndexCoordinates var3);

    public boolean exists(String var1, Class<?> var2);

    public boolean exists(String var1, IndexCoordinates var2);

    default public List<IndexedObjectInformation> bulkIndex(List<IndexQuery> queries, Class<?> clazz) {
        return this.bulkIndex(queries, BulkOptions.defaultOptions(), clazz);
    }

    default public List<IndexedObjectInformation> bulkIndex(List<IndexQuery> queries, IndexCoordinates index) {
        return this.bulkIndex(queries, BulkOptions.defaultOptions(), index);
    }

    public List<IndexedObjectInformation> bulkIndex(List<IndexQuery> var1, BulkOptions var2, Class<?> var3);

    public List<IndexedObjectInformation> bulkIndex(List<IndexQuery> var1, BulkOptions var2, IndexCoordinates var3);

    default public void bulkUpdate(List<UpdateQuery> queries, IndexCoordinates index) {
        this.bulkUpdate(queries, BulkOptions.defaultOptions(), index);
    }

    public void bulkUpdate(List<UpdateQuery> var1, Class<?> var2);

    public void bulkUpdate(List<UpdateQuery> var1, BulkOptions var2, IndexCoordinates var3);

    default public String delete(String id, IndexCoordinates index) {
        return this.delete(id, null, index);
    }

    public String delete(String var1, @Nullable String var2, IndexCoordinates var3);

    public String delete(String var1, Class<?> var2);

    public String delete(Object var1);

    public String delete(Object var1, IndexCoordinates var2);

    public void delete(Query var1, Class<?> var2);

    public void delete(Query var1, Class<?> var2, IndexCoordinates var3);

    public UpdateResponse update(UpdateQuery var1, IndexCoordinates var2);

    @Deprecated
    public void delete(DeleteQuery var1, IndexCoordinates var2);

    @Deprecated
    @Nullable
    public <T> T get(GetQuery var1, Class<T> var2, IndexCoordinates var3);

    @Deprecated
    @Nullable
    public <T> T queryForObject(GetQuery var1, Class<T> var2);
}

