/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.elasticsearch.core.geo.GeoJson;
import org.springframework.data.elasticsearch.core.geo.GeoJsonLineString;
import org.springframework.data.geo.Point;
import org.springframework.util.Assert;

public class GeoJsonMultiLineString
implements GeoJson<Iterable<GeoJsonLineString>> {
    public static final String TYPE = "MultiLineString";
    private final List<GeoJsonLineString> coordinates = new ArrayList<GeoJsonLineString>();

    private GeoJsonMultiLineString(List<GeoJsonLineString> lines) {
        this.coordinates.addAll(lines);
    }

    public static GeoJsonMultiLineString of(List<GeoJsonLineString> lines) {
        Assert.notNull(lines, (String)"Lines for MultiLineString must not be null!");
        return new GeoJsonMultiLineString(lines);
    }

    public static GeoJsonMultiLineString of(List<Point> ... lines) {
        Assert.notEmpty((Object[])lines, (String)"Points for MultiLineString must not be null!");
        List<GeoJsonLineString> geoJsonLineStrings = Arrays.stream(lines).map(GeoJsonLineString::of).collect(Collectors.toList());
        return new GeoJsonMultiLineString(geoJsonLineStrings);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public List<GeoJsonLineString> getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoJsonMultiLineString that = (GeoJsonMultiLineString)o;
        return this.coordinates.equals(that.coordinates);
    }

    public int hashCode() {
        return this.coordinates.hashCode();
    }

    public String toString() {
        return "GeoJsonMultiLineString{coordinates=" + this.coordinates + '}';
    }
}

