/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.support.Version;
import org.springframework.lang.Nullable;

public final class VersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(VersionInfo.class);
    private static final String VERSION_PROPERTIES = "versions.properties";
    public static final String VERSION_SPRING_DATA_ELASTICSEARCH = "version.spring-data-elasticsearch";
    public static final String VERSION_ELASTICSEARCH_CLIENT = "version.elasticsearch-client";
    private static Properties versionProperties;

    public static Properties versionProperties() {
        return versionProperties;
    }

    public static void logVersions(String vendor, String runtimeLibraryVersion, @Nullable String clusterVersion) {
        try {
            String versionSpringDataElasticsearch = versionProperties.getProperty(VERSION_SPRING_DATA_ELASTICSEARCH);
            Version versionBuiltLibraryES = Version.fromString(versionProperties.getProperty(VERSION_ELASTICSEARCH_CLIENT));
            Version versionRuntimeLibrary = Version.fromString(runtimeLibraryVersion);
            Version versionCluster = clusterVersion != null ? Version.fromString(clusterVersion) : null;
            LOG.info("Version Spring Data Elasticsearch: {}", (Object)versionSpringDataElasticsearch.toString());
            LOG.info("Version Elasticsearch client in build: {}", (Object)versionBuiltLibraryES.toString());
            LOG.info("Version runtime client used: {} - {}", (Object)vendor, (Object)versionRuntimeLibrary.toString());
            if (VersionInfo.differInMajorOrMinor(versionBuiltLibraryES, versionRuntimeLibrary)) {
                LOG.warn("Version mismatch in between Elasticsearch Clients build/use: {} - {}", (Object)versionBuiltLibraryES, (Object)versionRuntimeLibrary);
            }
            if (versionCluster != null) {
                LOG.info("Version cluster: {} - {}", (Object)vendor, (Object)versionCluster.toString());
                if (VersionInfo.differInMajorOrMinor(versionRuntimeLibrary, versionCluster)) {
                    LOG.warn("Version mismatch in between  Client and Cluster: {} - {} - {}", new Object[]{vendor, versionRuntimeLibrary, versionCluster});
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Could not log version info: {} - {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    private static Properties loadVersionProperties() throws IOException {
        InputStream resource = VersionInfo.class.getClassLoader().getResourceAsStream(VERSION_PROPERTIES);
        if (resource != null) {
            Properties properties = new Properties();
            properties.load(resource);
            return properties;
        }
        throw new IllegalStateException("Resource not found");
    }

    private static boolean differInMajorOrMinor(Version version1, Version version2) {
        return version1.getMajor() != version2.getMajor() || version1.getMinor() != version2.getMinor();
    }

    private VersionInfo() {
    }

    static {
        try {
            versionProperties = VersionInfo.loadVersionProperties();
        }
        catch (IOException e) {
            LOG.error("Could not load {}", (Object)VERSION_PROPERTIES, (Object)e);
            versionProperties = new Properties();
            versionProperties.put(VERSION_SPRING_DATA_ELASTICSEARCH, "0.0.0");
            versionProperties.put(VERSION_ELASTICSEARCH_CLIENT, "0.0.0");
        }
    }
}

