/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.ClearScrollRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.MgetRequest;
import co.elastic.clients.elasticsearch.core.MgetResponse;
import co.elastic.clients.elasticsearch.core.MsearchRequest;
import co.elastic.clients.elasticsearch.core.MsearchResponse;
import co.elastic.clients.elasticsearch.core.ScrollRequest;
import co.elastic.clients.elasticsearch.core.ScrollResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.UpdateByQueryRequest;
import co.elastic.clients.elasticsearch.core.UpdateByQueryResponse;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.get.GetResult;
import co.elastic.clients.elasticsearch.core.msearch.MultiSearchResponseItem;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.elasticsearch.BulkFailureException;
import org.springframework.data.elasticsearch.client.UnsupportedBackendOperation;
import org.springframework.data.elasticsearch.client.elc.ClusterTemplate;
import org.springframework.data.elasticsearch.client.elc.DocumentAdapters;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchExceptionTranslator;
import org.springframework.data.elasticsearch.client.elc.EntityAsMap;
import org.springframework.data.elasticsearch.client.elc.IndicesTemplate;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.client.elc.NativeQueryBuilder;
import org.springframework.data.elasticsearch.client.elc.RequestConverter;
import org.springframework.data.elasticsearch.client.elc.ResponseConverter;
import org.springframework.data.elasticsearch.client.elc.SearchDocumentResponseBuilder;
import org.springframework.data.elasticsearch.client.elc.TypeUtils;
import org.springframework.data.elasticsearch.core.AbstractElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.IndexedObjectInformation;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.cluster.ClusterOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.query.UpdateResponse;
import org.springframework.data.elasticsearch.core.reindex.ReindexRequest;
import org.springframework.data.elasticsearch.core.reindex.ReindexResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ElasticsearchTemplate
extends AbstractElasticsearchTemplate {
    private static final Log LOGGER = LogFactory.getLog(ElasticsearchTemplate.class);
    private final ElasticsearchClient client;
    private final RequestConverter requestConverter;
    private final ResponseConverter responseConverter;
    private final JsonpMapper jsonpMapper;
    private final ElasticsearchExceptionTranslator exceptionTranslator;

    public ElasticsearchTemplate(ElasticsearchClient client, ElasticsearchConverter elasticsearchConverter) {
        super(elasticsearchConverter);
        Assert.notNull((Object)client, (String)"client must not be null");
        this.client = client;
        this.jsonpMapper = ((ElasticsearchTransport)client._transport()).jsonpMapper();
        this.requestConverter = new RequestConverter(elasticsearchConverter, this.jsonpMapper);
        this.responseConverter = new ResponseConverter(this.jsonpMapper);
        this.exceptionTranslator = new ElasticsearchExceptionTranslator(this.jsonpMapper);
    }

    @Override
    protected AbstractElasticsearchTemplate doCopy() {
        return new ElasticsearchTemplate(this.client, this.elasticsearchConverter);
    }

    @Override
    public IndexOperations indexOps(Class<?> clazz) {
        return new IndicesTemplate(this.client.indices(), this.elasticsearchConverter, clazz);
    }

    @Override
    public IndexOperations indexOps(IndexCoordinates index) {
        return new IndicesTemplate(this.client.indices(), this.elasticsearchConverter, index);
    }

    @Override
    public ClusterOperations cluster() {
        return new ClusterTemplate(this.client.cluster(), this.elasticsearchConverter);
    }

    @Override
    @Nullable
    public <T> T get(String id, Class<T> clazz, IndexCoordinates index) {
        GetRequest getRequest = this.requestConverter.documentGetRequest(this.elasticsearchConverter.convertId(id), this.routingResolver.getRouting(), index, false);
        GetResponse getResponse = this.execute(client -> client.get(getRequest, EntityAsMap.class));
        AbstractElasticsearchTemplate.ReadDocumentCallback<T> callback = new AbstractElasticsearchTemplate.ReadDocumentCallback<T>(this.elasticsearchConverter, clazz, index);
        return callback.doWith(DocumentAdapters.from((GetResult<EntityAsMap>)getResponse));
    }

    @Override
    public <T> List<MultiGetItem<T>> multiGet(Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull(clazz, (String)"clazz must not be null");
        MgetRequest request = this.requestConverter.documentMgetRequest(query, clazz, index);
        MgetResponse result = this.execute(client -> client.mget(request, EntityAsMap.class));
        AbstractElasticsearchTemplate.ReadDocumentCallback callback = new AbstractElasticsearchTemplate.ReadDocumentCallback(this.elasticsearchConverter, clazz, index);
        return DocumentAdapters.from((MgetResponse<EntityAsMap>)result).stream().map(multiGetItem -> MultiGetItem.of(multiGetItem.isFailed() ? null : (Object)callback.doWith((Document)multiGetItem.getItem()), multiGetItem.getFailure())).collect(Collectors.toList());
    }

    @Override
    public void bulkUpdate(List<UpdateQuery> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull((Object)bulkOptions, (String)"bulkOptions must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        this.doBulkOperation(queries, bulkOptions, index);
    }

    @Override
    public ByQueryResponse delete(Query query, Class<?> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        DeleteByQueryRequest request = this.requestConverter.documentDeleteByQueryRequest(query, clazz, index, this.getRefreshPolicy());
        DeleteByQueryResponse response = this.execute(client -> client.deleteByQuery(request));
        return this.responseConverter.byQueryResponse(response);
    }

    @Override
    public UpdateResponse update(UpdateQuery updateQuery, IndexCoordinates index) {
        UpdateRequest<Document, ?> request = this.requestConverter.documentUpdateRequest(updateQuery, index, this.getRefreshPolicy(), this.routingResolver.getRouting());
        co.elastic.clients.elasticsearch.core.UpdateResponse response = this.execute(client -> client.update(request, Document.class));
        return UpdateResponse.of(TypeUtils.result(response.result()));
    }

    @Override
    public ByQueryResponse updateByQuery(UpdateQuery updateQuery, IndexCoordinates index) {
        Assert.notNull((Object)updateQuery, (String)"updateQuery must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        UpdateByQueryRequest request = this.requestConverter.documentUpdateByQueryRequest(updateQuery, index, this.getRefreshPolicy());
        UpdateByQueryResponse byQueryResponse = this.execute(client -> client.updateByQuery(request));
        return this.responseConverter.byQueryResponse(byQueryResponse);
    }

    @Override
    public String doIndex(IndexQuery query, IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        IndexRequest<?> indexRequest = this.requestConverter.documentIndexRequest(query, indexCoordinates, this.refreshPolicy);
        IndexResponse indexResponse = this.execute(client -> client.index(indexRequest));
        Object queryObject = query.getObject();
        if (queryObject != null) {
            query.setObject(this.updateIndexedObject(queryObject, IndexedObjectInformation.of(indexResponse.id(), indexResponse.seqNo(), indexResponse.primaryTerm(), indexResponse.version())));
        }
        return indexResponse.id();
    }

    @Override
    protected boolean doExists(String id, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        GetRequest request = this.requestConverter.documentGetRequest(id, this.routingResolver.getRouting(), index, true);
        return this.execute(client -> client.get(request, EntityAsMap.class)).found();
    }

    @Override
    protected String doDelete(String id, @Nullable String routing, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        DeleteRequest request = this.requestConverter.documentDeleteRequest(this.elasticsearchConverter.convertId(id), routing, index, this.getRefreshPolicy());
        return this.execute(client -> client.delete(request)).id();
    }

    @Override
    public ReindexResponse reindex(ReindexRequest reindexRequest) {
        Assert.notNull((Object)reindexRequest, (String)"reindexRequest must not be null");
        co.elastic.clients.elasticsearch.core.ReindexRequest reindexRequestES = this.requestConverter.reindex(reindexRequest, true);
        co.elastic.clients.elasticsearch.core.ReindexResponse reindexResponse = this.execute(client -> client.reindex(reindexRequestES));
        return this.responseConverter.reindexResponse(reindexResponse);
    }

    @Override
    public String submitReindex(ReindexRequest reindexRequest) {
        co.elastic.clients.elasticsearch.core.ReindexRequest reindexRequestES = this.requestConverter.reindex(reindexRequest, false);
        co.elastic.clients.elasticsearch.core.ReindexResponse reindexResponse = this.execute(client -> client.reindex(reindexRequestES));
        if (reindexResponse.task() == null) {
            throw new UnsupportedBackendOperation("ElasticsearchClient did not return a task id on submit request");
        }
        return reindexResponse.task();
    }

    @Override
    public List<IndexedObjectInformation> doBulkOperation(List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        BulkRequest bulkRequest = this.requestConverter.documentBulkRequest(queries, bulkOptions, index, this.refreshPolicy);
        BulkResponse bulkResponse = this.execute(client -> client.bulk(bulkRequest));
        List<IndexedObjectInformation> indexedObjectInformationList = this.checkForBulkOperationFailure(bulkResponse);
        this.updateIndexedObjectsWithQueries(queries, indexedObjectInformationList);
        return indexedObjectInformationList;
    }

    @Override
    protected String getClusterVersion() {
        return this.execute(client -> client.info().version().number());
    }

    @Override
    protected String getVendor() {
        return "Elasticsearch";
    }

    @Override
    protected String getRuntimeLibraryVersion() {
        return Version.VERSION.toString();
    }

    @Override
    public long count(Query query, @Nullable Class<?> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        SearchRequest searchRequest = this.requestConverter.searchRequest(query, clazz, index, true, false);
        SearchResponse searchResponse = this.execute(client -> client.search(searchRequest, EntityAsMap.class));
        return searchResponse.hits().total().value();
    }

    @Override
    public <T> SearchHits<T> search(Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        SearchRequest searchRequest = this.requestConverter.searchRequest(query, clazz, index, false, false);
        SearchResponse searchResponse = this.execute(client -> client.search(searchRequest, EntityAsMap.class));
        AbstractElasticsearchTemplate.ReadDocumentCallback<T> readDocumentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback<T>(this.elasticsearchConverter, clazz, index);
        SearchDocumentResponse.EntityCreator<T> entityCreator = this.getEntityCreator(readDocumentCallback);
        AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback<T> callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback<T>(clazz, index);
        return (SearchHits)callback.doWith(SearchDocumentResponseBuilder.from((ResponseBody<EntityAsMap>)searchResponse, entityCreator, this.jsonpMapper));
    }

    @Override
    protected <T> SearchHits<T> doSearch(MoreLikeThisQuery query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull(clazz, (String)"clazz must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return this.search(((NativeQueryBuilder)NativeQuery.builder().withQuery(q -> q.moreLikeThis(this.requestConverter.moreLikeThisQuery(query, index))).withPageable(query.getPageable())).build(), clazz, index);
    }

    @Override
    protected <T> SearchScrollHits<T> searchScrollStart(long scrollTimeInMillis, Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)query.getPageable(), (String)"pageable of query must not be null.");
        SearchRequest request = this.requestConverter.searchRequest(query, clazz, index, false, scrollTimeInMillis);
        SearchResponse response = this.execute(client -> client.search(request, EntityAsMap.class));
        return this.getSearchScrollHits(clazz, index, (ResponseBody<EntityAsMap>)response);
    }

    @Override
    protected <T> SearchScrollHits<T> searchScrollContinue(String scrollId, long scrollTimeInMillis, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)scrollId, (String)"scrollId must not be null");
        ScrollRequest request = ScrollRequest.of(sr -> sr.scrollId(scrollId).scroll(Time.of(t -> t.time(scrollTimeInMillis + "ms"))));
        ScrollResponse response = this.execute(client -> client.scroll(request, EntityAsMap.class));
        return this.getSearchScrollHits(clazz, index, (ResponseBody<EntityAsMap>)response);
    }

    private <T> SearchScrollHits<T> getSearchScrollHits(Class<T> clazz, IndexCoordinates index, ResponseBody<EntityAsMap> response) {
        AbstractElasticsearchTemplate.ReadDocumentCallback<T> documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback<T>(this.elasticsearchConverter, clazz, index);
        AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T> callback = new AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T>(clazz, index);
        return (SearchScrollHits)callback.doWith(SearchDocumentResponseBuilder.from(response, this.getEntityCreator(documentCallback), this.jsonpMapper));
    }

    @Override
    protected void searchScrollClear(List<String> scrollIds) {
        Assert.notNull(scrollIds, (String)"scrollIds must not be null");
        if (!scrollIds.isEmpty()) {
            ClearScrollRequest request = ClearScrollRequest.of(csr -> csr.scrollId(scrollIds));
            this.execute(client -> client.clearScroll(request));
        }
    }

    @Override
    public <T> List<SearchHits<T>> multiSearch(List<? extends Query> queries, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull(clazz, (String)"clazz must not be null");
        ArrayList<MultiSearchQueryParameter> multiSearchQueryParameters = new ArrayList<MultiSearchQueryParameter>(queries.size());
        for (Query query : queries) {
            multiSearchQueryParameters.add(new MultiSearchQueryParameter(query, clazz, this.getIndexCoordinatesFor(clazz)));
        }
        return this.doMultiSearch(multiSearchQueryParameters).stream().map(searchHits -> searchHits).collect(Collectors.toList());
    }

    @Override
    public List<SearchHits<?>> multiSearch(List<? extends Query> queries, List<Class<?>> classes) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull(classes, (String)"classes must not be null");
        Assert.isTrue((queries.size() == classes.size() ? 1 : 0) != 0, (String)"queries and classes must have the same size");
        ArrayList<MultiSearchQueryParameter> multiSearchQueryParameters = new ArrayList<MultiSearchQueryParameter>(queries.size());
        Iterator<Class<?>> it = classes.iterator();
        for (Query query : queries) {
            Class<?> clazz = it.next();
            multiSearchQueryParameters.add(new MultiSearchQueryParameter(query, clazz, this.getIndexCoordinatesFor(clazz)));
        }
        return this.doMultiSearch(multiSearchQueryParameters);
    }

    @Override
    public List<SearchHits<?>> multiSearch(List<? extends Query> queries, List<Class<?>> classes, IndexCoordinates index) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull(classes, (String)"classes must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.isTrue((queries.size() == classes.size() ? 1 : 0) != 0, (String)"queries and classes must have the same size");
        ArrayList<MultiSearchQueryParameter> multiSearchQueryParameters = new ArrayList<MultiSearchQueryParameter>(queries.size());
        Iterator<Class<?>> it = classes.iterator();
        for (Query query : queries) {
            Class<?> clazz = it.next();
            multiSearchQueryParameters.add(new MultiSearchQueryParameter(query, clazz, index));
        }
        return this.doMultiSearch(multiSearchQueryParameters);
    }

    private List<SearchHits<?>> doMultiSearch(List<MultiSearchQueryParameter> multiSearchQueryParameters) {
        MsearchRequest request = this.requestConverter.searchMsearchRequest(multiSearchQueryParameters);
        MsearchResponse msearchResponse = this.execute(client -> client.msearch(request, EntityAsMap.class));
        List responseItems = msearchResponse.responses();
        Assert.isTrue((multiSearchQueryParameters.size() == responseItems.size() ? 1 : 0) != 0, (String)"number of response items does not match number of requests");
        ArrayList searchHitsList = new ArrayList(multiSearchQueryParameters.size());
        Iterator<MultiSearchQueryParameter> queryIterator = multiSearchQueryParameters.iterator();
        Iterator responseIterator = responseItems.iterator();
        while (queryIterator.hasNext()) {
            MultiSearchQueryParameter queryParameter = queryIterator.next();
            MultiSearchResponseItem responseItem = (MultiSearchResponseItem)responseIterator.next();
            if (responseItem.isResult()) {
                Class<?> clazz = queryParameter.clazz;
                AbstractElasticsearchTemplate.ReadDocumentCallback documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((EntityReader<?, Document>)this.elasticsearchConverter, clazz, queryParameter.index);
                AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback(clazz, queryParameter.index);
                SearchHits searchHits = (SearchHits)callback.doWith(SearchDocumentResponseBuilder.from((ResponseBody<EntityAsMap>)responseItem.result(), this.getEntityCreator(documentCallback), this.jsonpMapper));
                searchHitsList.add(searchHits);
                continue;
            }
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn((Object)String.format("multisearch responsecontains failure: {}", responseItem.failure().error().reason()));
        }
        return searchHitsList;
    }

    public <T> T execute(ClientCallback<T> callback) {
        Assert.notNull(callback, (String)"callback must not be null");
        try {
            return callback.doWithClient(this.client);
        }
        catch (IOException | RuntimeException e) {
            throw this.exceptionTranslator.translateException(e);
        }
    }

    @Override
    public Query matchAllQuery() {
        return NativeQuery.builder().withQuery(qb -> qb.matchAll(mab -> mab)).build();
    }

    @Override
    public Query idsQuery(List<String> ids) {
        return NativeQuery.builder().withQuery(qb -> qb.ids(iq -> iq.values(ids))).build();
    }

    protected List<IndexedObjectInformation> checkForBulkOperationFailure(BulkResponse bulkResponse) {
        if (bulkResponse.errors()) {
            HashMap<String, String> failedDocuments = new HashMap<String, String>();
            for (BulkResponseItem item2 : bulkResponse.items()) {
                if (item2.error() == null) continue;
                failedDocuments.put(item2.id(), item2.error().reason());
            }
            throw new BulkFailureException("Bulk operation has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + ']', failedDocuments);
        }
        return bulkResponse.items().stream().map(item -> IndexedObjectInformation.of(item.id(), item.seqNo(), item.primaryTerm(), item.version())).collect(Collectors.toList());
    }

    @FunctionalInterface
    public static interface ClientCallback<T> {
        public T doWithClient(ElasticsearchClient var1) throws IOException;
    }

    static class MultiSearchQueryParameter {
        final Query query;
        final Class<?> clazz;
        final IndexCoordinates index;

        public MultiSearchQueryParameter(Query query, Class<?> clazz, IndexCoordinates index) {
            this.query = query;
            this.clazz = clazz;
            this.index = index;
        }
    }
}

