/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.elasticsearch.core.geo.GeoJson;
import org.springframework.data.elasticsearch.core.geo.GeoJsonGeometryCollection;
import org.springframework.data.elasticsearch.core.geo.GeoJsonLineString;
import org.springframework.data.elasticsearch.core.geo.GeoJsonMultiLineString;
import org.springframework.data.elasticsearch.core.geo.GeoJsonMultiPoint;
import org.springframework.data.elasticsearch.core.geo.GeoJsonMultiPolygon;
import org.springframework.data.elasticsearch.core.geo.GeoJsonPoint;
import org.springframework.data.elasticsearch.core.geo.GeoJsonPolygon;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.geo.Point;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;

public class GeoConverters {
    static Collection<Converter<?, ?>> getConvertersToRegister() {
        return Arrays.asList(new Converter[]{PointToMapConverter.INSTANCE, MapToPointConverter.INSTANCE, GeoPointToMapConverter.INSTANCE, MapToGeoPointConverter.INSTANCE, GeoJsonToMapConverter.INSTANCE, MapToGeoJsonConverter.INSTANCE, GeoJsonPointToMapConverter.INSTANCE, MapToGeoJsonPointConverter.INSTANCE, GeoJsonMultiPointToMapConverter.INSTANCE, MapToGeoJsonMultiPointConverter.INSTANCE, GeoJsonLineStringToMapConverter.INSTANCE, MapToGeoJsonLineStringConverter.INSTANCE, GeoJsonMultiLineStringToMapConverter.INSTANCE, MapToGeoJsonMultiLineStringConverter.INSTANCE, GeoJsonPolygonToMapConverter.INSTANCE, MapToGeoJsonPolygonConverter.INSTANCE, GeoJsonMultiPolygonToMapConverter.INSTANCE, MapToGeoJsonMultiPolygonConverter.INSTANCE, GeoJsonGeometryCollectionToMapConverter.INSTANCE, MapToGeoJsonGeometryCollectionConverter.INSTANCE});
    }

    private static String getGeoJsonType(Map<String, Object> source) {
        Object type = source.get("type");
        Assert.notNull((Object)type, (String)"Document to convert does not contain a type");
        Assert.isTrue((boolean)(type instanceof String), (String)"type must be a String");
        return type.toString().toLowerCase();
    }

    private static List<Double> toCoordinates(Point point) {
        return Arrays.asList(point.getX(), point.getY());
    }

    private static List<List<Double>> pointsToCoordinates(List<Point> points) {
        return points.stream().map(GeoConverters::toCoordinates).collect(Collectors.toList());
    }

    private static List<Point> coordinatesToPoints(List<List<Number>> pointList) {
        Assert.isTrue((pointList.size() >= 2 ? 1 : 0) != 0, (String)"pointList must have at least 2 elements");
        return pointList.stream().map(numbers -> {
            Assert.isTrue((numbers.size() >= 2 ? 1 : 0) != 0, (String)"coordinates must have at least 2 elements");
            return new Point(((Number)numbers.get(0)).doubleValue(), ((Number)numbers.get(1)).doubleValue());
        }).collect(Collectors.toList());
    }

    private static Map<String, Object> geoJsonLinesStringsToMap(String type, List<GeoJsonLineString> lineStrings) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", type);
        List coordinates = lineStrings.stream().map(it -> GeoConverters.pointsToCoordinates((List<Point>)it.getCoordinates())).collect(Collectors.toList());
        map.put("coordinates", coordinates);
        return map;
    }

    private static List<GeoJsonLineString> geoJsonLineStringsFromMap(Map<String, Object> source) {
        Object coordinates = source.get("coordinates");
        Assert.notNull((Object)coordinates, (String)"Document to convert does not contain coordinates");
        Assert.isTrue((boolean)(coordinates instanceof List), (String)"coordinates must be a List");
        List<GeoJsonLineString> lines = ((List)coordinates).stream().map(it -> GeoJsonLineString.of(GeoConverters.coordinatesToPoints((List)it))).collect(Collectors.toList());
        return lines;
    }

    @WritingConverter
    public static enum PointToMapConverter implements Converter<Point, Map<String, Object>>
    {
        INSTANCE;


        public Map<String, Object> convert(Point source) {
            LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
            target.put("lat", source.getY());
            target.put("lon", source.getX());
            return target;
        }
    }

    @ReadingConverter
    public static enum MapToPointConverter implements Converter<Map<String, Object>, Point>
    {
        INSTANCE;


        public Point convert(Map<String, Object> source) {
            Double x = (Double)NumberUtils.convertNumberToTargetClass((Number)((Number)source.get("lon")), Double.class);
            Double y = (Double)NumberUtils.convertNumberToTargetClass((Number)((Number)source.get("lat")), Double.class);
            return new Point(x.doubleValue(), y.doubleValue());
        }
    }

    @WritingConverter
    public static enum GeoPointToMapConverter implements Converter<GeoPoint, Map<String, Object>>
    {
        INSTANCE;


        public Map<String, Object> convert(GeoPoint source) {
            LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
            target.put("lat", source.getLat());
            target.put("lon", source.getLon());
            return target;
        }
    }

    @ReadingConverter
    public static enum MapToGeoPointConverter implements Converter<Map<String, Object>, GeoPoint>
    {
        INSTANCE;


        public GeoPoint convert(Map<String, Object> source) {
            Double lat = (Double)NumberUtils.convertNumberToTargetClass((Number)((Number)source.get("lat")), Double.class);
            Double lon = (Double)NumberUtils.convertNumberToTargetClass((Number)((Number)source.get("lon")), Double.class);
            return new GeoPoint(lat, lon);
        }
    }

    @WritingConverter
    public static enum GeoJsonToMapConverter implements Converter<GeoJson<? extends Iterable<?>>, Map<String, Object>>
    {
        INSTANCE;


        public Map<String, Object> convert(GeoJson<? extends Iterable<?>> source) {
            if (source instanceof GeoJsonPoint) {
                GeoJsonPoint geoJsonPoint = (GeoJsonPoint)source;
                return GeoJsonPointToMapConverter.INSTANCE.convert(geoJsonPoint);
            }
            if (source instanceof GeoJsonMultiPoint) {
                GeoJsonMultiPoint geoJsonMultiPoint = (GeoJsonMultiPoint)source;
                return GeoJsonMultiPointToMapConverter.INSTANCE.convert(geoJsonMultiPoint);
            }
            if (source instanceof GeoJsonLineString) {
                GeoJsonLineString geoJsonLineString = (GeoJsonLineString)source;
                return GeoJsonLineStringToMapConverter.INSTANCE.convert(geoJsonLineString);
            }
            if (source instanceof GeoJsonMultiLineString) {
                GeoJsonMultiLineString geoJsonMultiLineString = (GeoJsonMultiLineString)source;
                return GeoJsonMultiLineStringToMapConverter.INSTANCE.convert(geoJsonMultiLineString);
            }
            if (source instanceof GeoJsonPolygon) {
                GeoJsonPolygon geoJsonPolygon = (GeoJsonPolygon)source;
                return GeoJsonPolygonToMapConverter.INSTANCE.convert(geoJsonPolygon);
            }
            if (source instanceof GeoJsonMultiPolygon) {
                GeoJsonMultiPolygon geoJsonMultiPolygon = (GeoJsonMultiPolygon)source;
                return GeoJsonMultiPolygonToMapConverter.INSTANCE.convert(geoJsonMultiPolygon);
            }
            if (source instanceof GeoJsonGeometryCollection) {
                GeoJsonGeometryCollection geoJsonGeometryCollection = (GeoJsonGeometryCollection)source;
                return GeoJsonGeometryCollectionToMapConverter.INSTANCE.convert(geoJsonGeometryCollection);
            }
            throw new IllegalArgumentException("unknown GeoJson class " + source.getClass().getSimpleName());
        }
    }

    @ReadingConverter
    public static enum MapToGeoJsonConverter implements Converter<Map<String, Object>, GeoJson<? extends Iterable<?>>>
    {
        INSTANCE;


        public GeoJson<? extends Iterable<?>> convert(Map<String, Object> source) {
            String type;
            return switch (type = GeoConverters.getGeoJsonType(source)) {
                case "point" -> MapToGeoJsonPointConverter.INSTANCE.convert(source);
                case "multipoint" -> MapToGeoJsonMultiPointConverter.INSTANCE.convert(source);
                case "linestring" -> MapToGeoJsonLineStringConverter.INSTANCE.convert(source);
                case "multilinestring" -> MapToGeoJsonMultiLineStringConverter.INSTANCE.convert(source);
                case "polygon" -> MapToGeoJsonPolygonConverter.INSTANCE.convert(source);
                case "multipolygon" -> MapToGeoJsonMultiPolygonConverter.INSTANCE.convert(source);
                case "geometrycollection" -> MapToGeoJsonGeometryCollectionConverter.INSTANCE.convert(source);
                default -> throw new IllegalArgumentException("unknown GeoJson type " + type);
            };
        }
    }

    @WritingConverter
    public static enum GeoJsonPointToMapConverter implements Converter<GeoJsonPoint, Map<String, Object>>
    {
        INSTANCE;


        public Map<String, Object> convert(GeoJsonPoint geoJsonPoint) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", geoJsonPoint.getType());
            map.put("coordinates", geoJsonPoint.getCoordinates());
            return map;
        }
    }

    @ReadingConverter
    public static enum MapToGeoJsonPointConverter implements Converter<Map<String, Object>, GeoJsonPoint>
    {
        INSTANCE;


        public GeoJsonPoint convert(Map<String, Object> source) {
            String type = GeoConverters.getGeoJsonType(source);
            Assert.isTrue((boolean)type.equalsIgnoreCase("Point"), (String)"does not contain a type 'Point'");
            Object coordinates = source.get("coordinates");
            Assert.notNull((Object)coordinates, (String)"Document to convert does not contain coordinates");
            Assert.isTrue((boolean)(coordinates instanceof List), (String)"coordinates must be a List of Numbers");
            List numbers = (List)coordinates;
            Assert.isTrue((numbers.size() >= 2 ? 1 : 0) != 0, (String)"coordinates must have at least 2 elements");
            return GeoJsonPoint.of(((Number)numbers.get(0)).doubleValue(), ((Number)numbers.get(1)).doubleValue());
        }
    }

    @WritingConverter
    public static enum GeoJsonMultiPointToMapConverter implements Converter<GeoJsonMultiPoint, Map<String, Object>>
    {
        INSTANCE;


        public Map<String, Object> convert(GeoJsonMultiPoint geoJsonMultiPoint) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", geoJsonMultiPoint.getType());
            map.put("coordinates", GeoConverters.pointsToCoordinates((List<Point>)geoJsonMultiPoint.getCoordinates()));
            return map;
        }
    }

    @ReadingConverter
    public static enum MapToGeoJsonMultiPointConverter implements Converter<Map<String, Object>, GeoJsonMultiPoint>
    {
        INSTANCE;


        public GeoJsonMultiPoint convert(Map<String, Object> source) {
            String type = GeoConverters.getGeoJsonType(source);
            Assert.isTrue((boolean)type.equalsIgnoreCase("MultiPoint"), (String)"does not contain a type 'MultiPoint'");
            Object coordinates = source.get("coordinates");
            Assert.notNull((Object)coordinates, (String)"Document to convert does not contain coordinates");
            Assert.isTrue((boolean)(coordinates instanceof List), (String)"coordinates must be a List");
            return GeoJsonMultiPoint.of(GeoConverters.coordinatesToPoints((List)coordinates));
        }
    }

    @WritingConverter
    public static enum GeoJsonLineStringToMapConverter implements Converter<GeoJsonLineString, Map<String, Object>>
    {
        INSTANCE;


        public Map<String, Object> convert(GeoJsonLineString geoJsonLineString) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", geoJsonLineString.getType());
            map.put("coordinates", GeoConverters.pointsToCoordinates((List<Point>)geoJsonLineString.getCoordinates()));
            return map;
        }
    }

    @ReadingConverter
    public static enum MapToGeoJsonLineStringConverter implements Converter<Map<String, Object>, GeoJsonLineString>
    {
        INSTANCE;


        public GeoJsonLineString convert(Map<String, Object> source) {
            String type = GeoConverters.getGeoJsonType(source);
            Assert.isTrue((boolean)type.equalsIgnoreCase("LineString"), (String)"does not contain a type 'LineString'");
            Object coordinates = source.get("coordinates");
            Assert.notNull((Object)coordinates, (String)"Document to convert does not contain coordinates");
            Assert.isTrue((boolean)(coordinates instanceof List), (String)"coordinates must be a List");
            return GeoJsonLineString.of(GeoConverters.coordinatesToPoints((List)coordinates));
        }
    }

    @WritingConverter
    public static enum GeoJsonMultiLineStringToMapConverter implements Converter<GeoJsonMultiLineString, Map<String, Object>>
    {
        INSTANCE;


        public Map<String, Object> convert(GeoJsonMultiLineString source) {
            return GeoConverters.geoJsonLinesStringsToMap(source.getType(), (List<GeoJsonLineString>)source.getCoordinates());
        }
    }

    @ReadingConverter
    public static enum MapToGeoJsonMultiLineStringConverter implements Converter<Map<String, Object>, GeoJsonMultiLineString>
    {
        INSTANCE;


        public GeoJsonMultiLineString convert(Map<String, Object> source) {
            String type = GeoConverters.getGeoJsonType(source);
            Assert.isTrue((boolean)type.equalsIgnoreCase("MultiLineString"), (String)"does not contain a type 'MultiLineString'");
            List<GeoJsonLineString> lines = GeoConverters.geoJsonLineStringsFromMap(source);
            return GeoJsonMultiLineString.of(lines);
        }
    }

    @WritingConverter
    public static enum GeoJsonPolygonToMapConverter implements Converter<GeoJsonPolygon, Map<String, Object>>
    {
        INSTANCE;


        public Map<String, Object> convert(GeoJsonPolygon source) {
            return GeoConverters.geoJsonLinesStringsToMap(source.getType(), (List<GeoJsonLineString>)source.getCoordinates());
        }
    }

    @ReadingConverter
    public static enum MapToGeoJsonPolygonConverter implements Converter<Map<String, Object>, GeoJsonPolygon>
    {
        INSTANCE;


        public GeoJsonPolygon convert(Map<String, Object> source) {
            String type = GeoConverters.getGeoJsonType(source);
            Assert.isTrue((boolean)type.equalsIgnoreCase("Polygon"), (String)"does not contain a type 'Polygon'");
            List<GeoJsonLineString> lines = GeoConverters.geoJsonLineStringsFromMap(source);
            Assert.isTrue((lines.size() > 0 ? 1 : 0) != 0, (String)"no linestrings defined in polygon");
            GeoJsonPolygon geoJsonPolygon = GeoJsonPolygon.of(lines.get(0));
            for (int i = 1; i < lines.size(); ++i) {
                geoJsonPolygon = geoJsonPolygon.withInnerRing(lines.get(i));
            }
            return geoJsonPolygon;
        }
    }

    @WritingConverter
    public static enum GeoJsonMultiPolygonToMapConverter implements Converter<GeoJsonMultiPolygon, Map<String, Object>>
    {
        INSTANCE;


        public Map<String, Object> convert(GeoJsonMultiPolygon source) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", source.getType());
            List coordinates = source.getCoordinates().stream().map(GeoJsonPolygonToMapConverter.INSTANCE::convert).filter(Objects::nonNull).map(it -> it.get("coordinates")).collect(Collectors.toList());
            map.put("coordinates", coordinates);
            return map;
        }
    }

    @ReadingConverter
    public static enum MapToGeoJsonMultiPolygonConverter implements Converter<Map<String, Object>, GeoJsonMultiPolygon>
    {
        INSTANCE;


        public GeoJsonMultiPolygon convert(Map<String, Object> source) {
            String type = GeoConverters.getGeoJsonType(source);
            Assert.isTrue((boolean)type.equalsIgnoreCase("MultiPolygon"), (String)"does not contain a type 'MultiPolygon'");
            Object coordinates = source.get("coordinates");
            Assert.notNull((Object)coordinates, (String)"Document to convert does not contain coordinates");
            Assert.isTrue((boolean)(coordinates instanceof List), (String)"coordinates must be a List");
            List<GeoJsonPolygon> geoJsonPolygons = ((List)coordinates).stream().map(it -> {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("type", "Polygon");
                map.put("coordinates", it);
                return map;
            }).map(MapToGeoJsonPolygonConverter.INSTANCE::convert).collect(Collectors.toList());
            return GeoJsonMultiPolygon.of(geoJsonPolygons);
        }
    }

    @WritingConverter
    public static enum GeoJsonGeometryCollectionToMapConverter implements Converter<GeoJsonGeometryCollection, Map<String, Object>>
    {
        INSTANCE;


        public Map<String, Object> convert(GeoJsonGeometryCollection source) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", source.getType());
            List geometries = source.getGeometries().stream().map(GeoJsonToMapConverter.INSTANCE::convert).collect(Collectors.toList());
            map.put("geometries", geometries);
            return map;
        }
    }

    @ReadingConverter
    public static enum MapToGeoJsonGeometryCollectionConverter implements Converter<Map<String, Object>, GeoJsonGeometryCollection>
    {
        INSTANCE;


        public GeoJsonGeometryCollection convert(Map<String, Object> source) {
            String type = GeoConverters.getGeoJsonType(source);
            Assert.isTrue((boolean)type.equalsIgnoreCase("GeometryCollection"), (String)"does not contain a type 'GeometryCollection'");
            Object geometries = source.get("geometries");
            Assert.notNull((Object)geometries, (String)"Document to convert does not contain geometries");
            Assert.isTrue((boolean)(geometries instanceof List), (String)"geometries must be a List");
            List<GeoJson<?>> geoJsonList = ((List)geometries).stream().map(MapToGeoJsonConverter.INSTANCE::convert).collect(Collectors.toList());
            return GeoJsonGeometryCollection.of(geoJsonList);
        }
    }
}

