/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.jdbc.core.SelectBuilder;
import org.springframework.data.jdbc.core.SqlGeneratorSource;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.StreamUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class SqlGenerator {
    private final RelationalPersistentEntity<?> entity;
    private final RelationalMappingContext context;
    private final List<String> columnNames = new ArrayList<String>();
    private final List<String> nonIdColumnNames = new ArrayList<String>();
    private final Lazy<String> findOneSql = Lazy.of(this::createFindOneSelectSql);
    private final Lazy<String> findAllSql = Lazy.of(this::createFindAllSql);
    private final Lazy<String> findAllInListSql = Lazy.of(this::createFindAllInListSql);
    private final Lazy<String> existsSql = Lazy.of(this::createExistsSql);
    private final Lazy<String> countSql = Lazy.of(this::createCountSql);
    private final Lazy<String> updateSql = Lazy.of(this::createUpdateSql);
    private final Lazy<String> deleteByIdSql = Lazy.of(this::createDeleteSql);
    private final Lazy<String> deleteByListSql = Lazy.of(this::createDeleteByListSql);
    private final SqlGeneratorSource sqlGeneratorSource;
    private final Pattern parameterPattern = Pattern.compile("\\W");

    SqlGenerator(RelationalMappingContext context, RelationalPersistentEntity<?> entity, SqlGeneratorSource sqlGeneratorSource) {
        this.context = context;
        this.entity = entity;
        this.sqlGeneratorSource = sqlGeneratorSource;
        this.initColumnNames();
    }

    private void initColumnNames() {
        this.entity.doWithProperties(p -> {
            if (!p.isEntity()) {
                this.columnNames.add(p.getColumnName());
                if (!this.entity.isIdProperty(p)) {
                    this.nonIdColumnNames.add(p.getColumnName());
                }
            }
        });
    }

    String getFindAllInList() {
        return (String)this.findAllInListSql.get();
    }

    String getFindAll() {
        return (String)this.findAllSql.get();
    }

    String getFindAllByProperty(String columnName, @Nullable String keyColumn, boolean ordered) {
        Assert.isTrue((keyColumn != null || !ordered ? 1 : 0) != 0, (String)"If the SQL statement should be ordered a keyColumn to order by must be provided.");
        String baseSelect = keyColumn != null ? this.createSelectBuilder().column(cb -> cb.tableAlias(this.entity.getTableName()).column(keyColumn).as(keyColumn)).build() : this.getFindAll();
        String orderBy = ordered ? " ORDER BY " + keyColumn : "";
        return String.format("%s WHERE %s = :%s%s", baseSelect, columnName, columnName, orderBy);
    }

    String getExists() {
        return (String)this.existsSql.get();
    }

    String getFindOne() {
        return (String)this.findOneSql.get();
    }

    String getInsert(Set<String> additionalColumns) {
        return this.createInsertSql(additionalColumns);
    }

    String getUpdate() {
        return (String)this.updateSql.get();
    }

    String getCount() {
        return (String)this.countSql.get();
    }

    String getDeleteById() {
        return (String)this.deleteByIdSql.get();
    }

    String getDeleteByList() {
        return (String)this.deleteByListSql.get();
    }

    private String createFindOneSelectSql() {
        return this.createSelectBuilder().where(wb -> wb.tableAlias(this.entity.getTableName()).column(this.entity.getIdColumn()).eq().variable("id")).build();
    }

    private SelectBuilder createSelectBuilder() {
        SelectBuilder builder = new SelectBuilder(this.entity.getTableName());
        this.addColumnsForSimpleProperties(builder);
        this.addColumnsAndJoinsForOneToOneReferences(builder);
        return builder;
    }

    private void addColumnsAndJoinsForOneToOneReferences(SelectBuilder builder) {
        Iterator iterator = this.entity.iterator();
        while (iterator.hasNext()) {
            RelationalPersistentProperty property = (RelationalPersistentProperty)iterator.next();
            if (!property.isEntity() || Collection.class.isAssignableFrom(property.getType()) || Map.class.isAssignableFrom(property.getType())) continue;
            RelationalPersistentEntity refEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(property.getActualType());
            String joinAlias = property.getName();
            builder.join(jb -> jb.leftOuter().table(refEntity.getTableName()).as(joinAlias).where(property.getReverseColumnName()).eq().column(this.entity.getTableName(), this.entity.getIdColumn()));
            Iterator iterator2 = refEntity.iterator();
            while (iterator2.hasNext()) {
                RelationalPersistentProperty refProperty = (RelationalPersistentProperty)iterator2.next();
                builder.column(cb -> cb.tableAlias(joinAlias).column(refProperty.getColumnName()).as(joinAlias + "_" + refProperty.getColumnName()));
            }
        }
    }

    private void addColumnsForSimpleProperties(SelectBuilder builder) {
        Iterator iterator = this.entity.iterator();
        while (iterator.hasNext()) {
            RelationalPersistentProperty property = (RelationalPersistentProperty)iterator.next();
            if (property.isEntity()) continue;
            builder.column(cb -> cb.tableAlias(this.entity.getTableName()).column(property.getColumnName()).as(property.getColumnName()));
        }
    }

    private Stream<String> getColumnNameStream(String prefix) {
        return StreamUtils.createStreamFromIterator((Iterator)this.entity.iterator()).flatMap(p -> this.getColumnNameStream((RelationalPersistentProperty)p, prefix));
    }

    private Stream<String> getColumnNameStream(RelationalPersistentProperty p, String prefix) {
        if (p.isEntity()) {
            return this.sqlGeneratorSource.getSqlGenerator(p.getType()).getColumnNameStream(prefix + p.getColumnName() + "_");
        }
        return Stream.of(prefix + p.getColumnName());
    }

    private String createFindAllSql() {
        return this.createSelectBuilder().build();
    }

    private String createFindAllInListSql() {
        return this.createSelectBuilder().where(wb -> wb.tableAlias(this.entity.getTableName()).column(this.entity.getIdColumn()).in().variable("ids")).build();
    }

    private String createExistsSql() {
        return String.format("SELECT COUNT(*) FROM %s WHERE %s = :id", this.entity.getTableName(), this.entity.getIdColumn());
    }

    private String createCountSql() {
        return String.format("select count(*) from %s", this.entity.getTableName());
    }

    private String createInsertSql(Set<String> additionalColumns) {
        String insertTemplate = "INSERT INTO %s (%s) VALUES (%s)";
        LinkedHashSet<String> columnNamesForInsert = new LinkedHashSet<String>(this.nonIdColumnNames);
        columnNamesForInsert.addAll(additionalColumns);
        String tableColumns = String.join((CharSequence)", ", columnNamesForInsert);
        String parameterNames = columnNamesForInsert.stream().map(this::columnNameToParameterName).map(n -> String.format(":%s", n)).collect(Collectors.joining(", "));
        return String.format(insertTemplate, this.entity.getTableName(), tableColumns, parameterNames);
    }

    private String createUpdateSql() {
        String updateTemplate = "UPDATE %s SET %s WHERE %s = :%s";
        String setClause = this.columnNames.stream().map(n -> String.format("%s = :%s", n, this.columnNameToParameterName((String)n))).collect(Collectors.joining(", "));
        return String.format(updateTemplate, this.entity.getTableName(), setClause, this.entity.getIdColumn(), this.columnNameToParameterName(this.entity.getIdColumn()));
    }

    private String createDeleteSql() {
        return String.format("DELETE FROM %s WHERE %s = :id", this.entity.getTableName(), this.entity.getIdColumn());
    }

    String createDeleteAllSql(@Nullable PersistentPropertyPath<RelationalPersistentProperty> path) {
        if (path == null) {
            return String.format("DELETE FROM %s", this.entity.getTableName());
        }
        RelationalPersistentEntity entityToDelete = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(((RelationalPersistentProperty)path.getRequiredLeafProperty()).getActualType());
        RelationalPersistentProperty property = (RelationalPersistentProperty)path.getBaseProperty();
        String innerMostCondition = String.format("%s IS NOT NULL", property.getReverseColumnName());
        String condition = this.cascadeConditions(innerMostCondition, this.getSubPath(path));
        return String.format("DELETE FROM %s WHERE %s", entityToDelete.getTableName(), condition);
    }

    private String createDeleteByListSql() {
        return String.format("DELETE FROM %s WHERE %s IN (:ids)", this.entity.getTableName(), this.entity.getIdColumn());
    }

    String createDeleteByPath(PersistentPropertyPath<RelationalPersistentProperty> path) {
        RelationalPersistentEntity entityToDelete = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(((RelationalPersistentProperty)path.getRequiredLeafProperty()).getActualType());
        RelationalPersistentProperty property = (RelationalPersistentProperty)path.getBaseProperty();
        String innerMostCondition = String.format("%s = :rootId", property.getReverseColumnName());
        String condition = this.cascadeConditions(innerMostCondition, this.getSubPath(path));
        return String.format("DELETE FROM %s WHERE %s", entityToDelete.getTableName(), condition);
    }

    private PersistentPropertyPath<RelationalPersistentProperty> getSubPath(PersistentPropertyPath<RelationalPersistentProperty> path) {
        int pathLength = path.getLength();
        PersistentPropertyPath ancestor = path;
        for (int i = pathLength - 1; i > 0; --i) {
            ancestor = path.getParentPath();
        }
        return path.getExtensionForBaseOf(ancestor);
    }

    private String cascadeConditions(String innerCondition, PersistentPropertyPath<RelationalPersistentProperty> path) {
        if (path.getLength() == 0) {
            return innerCondition;
        }
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(((RelationalPersistentProperty)path.getBaseProperty()).getOwner().getTypeInformation());
        RelationalPersistentProperty property = (RelationalPersistentProperty)path.getRequiredLeafProperty();
        return String.format("%s IN (SELECT %s FROM %s WHERE %s)", property.getReverseColumnName(), entity.getIdColumn(), entity.getTableName(), innerCondition);
    }

    private String columnNameToParameterName(String columnName) {
        return this.parameterPattern.matcher(columnName).replaceAll("");
    }
}

