/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping.event;

import java.util.Optional;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.mapping.event.Identifier;
import org.springframework.data.relational.core.mapping.event.RelationalEvent;
import org.springframework.lang.Nullable;

class SimpleRelationalEvent
extends ApplicationEvent
implements RelationalEvent {
    private static final long serialVersionUID = -1798807778668751659L;
    private final Object entity;
    private final AggregateChange change;

    SimpleRelationalEvent(Identifier id, Optional<Object> entity, @Nullable AggregateChange change) {
        super((Object)id);
        this.entity = entity.orElse(null);
        this.change = change;
    }

    @Override
    public Identifier getId() {
        return (Identifier)this.getSource();
    }

    @Override
    public Optional<Object> getOptionalEntity() {
        return Optional.ofNullable(this.entity);
    }

    public AggregateChange getChange() {
        return this.change;
    }
}

