/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.mapping;

import java.util.Set;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import org.springframework.data.jpa.mapping.JpaPersistentEntityImpl;
import org.springframework.data.jpa.mapping.JpaPersistentProperty;
import org.springframework.data.jpa.mapping.JpaPersistentPropertyImpl;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JpaMetamodelMappingContext
extends AbstractMappingContext<JpaPersistentEntityImpl<?>, JpaPersistentProperty> {
    private final Set<Metamodel> models;
    private final PersistenceProvider persistenceProvider;

    public JpaMetamodelMappingContext(Set<Metamodel> models) {
        Assert.notNull(models, (String)"JPA metamodel must not be null!");
        Assert.notEmpty(models, (String)"At least one JPA metamodel must be present!");
        this.models = models;
        this.persistenceProvider = PersistenceProvider.fromMetamodel(models.iterator().next());
    }

    protected <T> JpaPersistentEntityImpl<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        return new JpaPersistentEntityImpl<T>(typeInformation, this.persistenceProvider);
    }

    protected JpaPersistentProperty createPersistentProperty(Property property, JpaPersistentEntityImpl<?> owner, SimpleTypeHolder simpleTypeHolder) {
        Metamodel metamodel = this.getMetamodelFor(owner.getType());
        if (metamodel == null) {
            throw new IllegalStateException(String.format("Metamodel for %s not available!", owner.getType()));
        }
        return new JpaPersistentPropertyImpl(metamodel, property, owner, simpleTypeHolder);
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        return this.getMetamodelFor(type.getType()) != null;
    }

    @Nullable
    private Metamodel getMetamodelFor(Class<?> type) {
        for (Metamodel model : this.models) {
            try {
                model.managedType(type);
                return model;
            }
            catch (IllegalArgumentException o_O) {
                for (ManagedType managedType : model.getManagedTypes()) {
                    if (!type.equals(managedType.getJavaType())) continue;
                    return model;
                }
            }
        }
        return null;
    }
}

