/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.persistence.LockModeType;
import javax.persistence.QueryHint;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class CrudMethodMetadataPostProcessor
implements RepositoryProxyPostProcessor,
BeanClassLoaderAware {
    @Nullable
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    CrudMethodMetadataPostProcessor() {
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
        factory.addAdvice((Advice)CrudMethodMetadataPopulatingMethodInterceptor.INSTANCE);
    }

    public CrudMethodMetadata getCrudMethodMetadata() {
        ProxyFactory factory = new ProxyFactory();
        factory.addInterface(CrudMethodMetadata.class);
        factory.setTargetSource((TargetSource)new ThreadBoundTargetSource());
        return (CrudMethodMetadata)factory.getProxy(this.classLoader);
    }

    private static class ThreadBoundTargetSource
    implements TargetSource {
        private ThreadBoundTargetSource() {
        }

        public Class<?> getTargetClass() {
            return CrudMethodMetadata.class;
        }

        public boolean isStatic() {
            return false;
        }

        public Object getTarget() throws Exception {
            MethodInvocation invocation = ExposeInvocationInterceptor.currentInvocation();
            return TransactionSynchronizationManager.getResource((Object)invocation.getMethod());
        }

        public void releaseTarget(Object target) throws Exception {
        }
    }

    private static class DefaultCrudMethodMetadata
    implements CrudMethodMetadata {
        @Nullable
        private final LockModeType lockModeType;
        private final Map<String, Object> queryHints;
        private final Map<String, Object> getQueryHintsForCount;
        private final Optional<EntityGraph> entityGraph;
        private final Method method;

        DefaultCrudMethodMetadata(Method method) {
            Assert.notNull((Object)method, (String)"Method must not be null!");
            this.lockModeType = DefaultCrudMethodMetadata.findLockModeType(method);
            this.queryHints = DefaultCrudMethodMetadata.findQueryHints(method, it -> true);
            this.getQueryHintsForCount = DefaultCrudMethodMetadata.findQueryHints(method, QueryHints::forCounting);
            this.entityGraph = DefaultCrudMethodMetadata.findEntityGraph(method);
            this.method = method;
        }

        private static Optional<EntityGraph> findEntityGraph(Method method) {
            return Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, EntityGraph.class));
        }

        @Nullable
        private static LockModeType findLockModeType(Method method) {
            Lock annotation = (Lock)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Lock.class);
            return annotation == null ? null : (LockModeType)AnnotationUtils.getValue((Annotation)annotation);
        }

        private static Map<String, Object> findQueryHints(Method method, Predicate<QueryHints> annotationFilter) {
            QueryHint queryHintAnnotation;
            HashMap<String, String> queryHints = new HashMap<String, String>();
            QueryHints queryHintsAnnotation = (QueryHints)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, QueryHints.class);
            if (queryHintsAnnotation != null && annotationFilter.test(queryHintsAnnotation)) {
                for (QueryHint hint : queryHintsAnnotation.value()) {
                    queryHints.put(hint.name(), hint.value());
                }
            }
            if ((queryHintAnnotation = (QueryHint)AnnotationUtils.findAnnotation((Method)method, QueryHint.class)) != null) {
                queryHints.put(queryHintAnnotation.name(), queryHintAnnotation.value());
            }
            return Collections.unmodifiableMap(queryHints);
        }

        @Override
        @Nullable
        public LockModeType getLockModeType() {
            return this.lockModeType;
        }

        @Override
        public Map<String, Object> getQueryHints() {
            return this.queryHints;
        }

        @Override
        public Map<String, Object> getQueryHintsForCount() {
            return this.getQueryHintsForCount;
        }

        @Override
        public Optional<EntityGraph> getEntityGraph() {
            return this.entityGraph;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }
    }

    static enum CrudMethodMetadataPopulatingMethodInterceptor implements MethodInterceptor
    {
        INSTANCE;

        private final ConcurrentMap<Method, CrudMethodMetadata> metadataCache = new ConcurrentHashMap<Method, CrudMethodMetadata>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            CrudMethodMetadata tmp;
            Method method = invocation.getMethod();
            CrudMethodMetadata metadata = (CrudMethodMetadata)TransactionSynchronizationManager.getResource((Object)method);
            if (metadata != null) {
                return invocation.proceed();
            }
            CrudMethodMetadata methodMetadata = (CrudMethodMetadata)this.metadataCache.get(method);
            if (methodMetadata == null && (tmp = this.metadataCache.putIfAbsent(method, methodMetadata = new DefaultCrudMethodMetadata(method))) != null) {
                methodMetadata = tmp;
            }
            TransactionSynchronizationManager.bindResource((Object)method, (Object)methodMetadata);
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                TransactionSynchronizationManager.unbindResource((Object)method);
            }
        }
    }
}

