/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.gridfs.GridFSDBFile;
import java.io.IOException;
import org.springframework.core.io.InputStreamResource;

public class GridFsResource
extends InputStreamResource {
    private final GridFSDBFile file;

    public GridFsResource(GridFSDBFile file) {
        super(file.getInputStream());
        this.file = file;
    }

    public long contentLength() throws IOException {
        return this.file.getLength();
    }

    public String getFilename() throws IllegalStateException {
        return this.file.getFilename();
    }

    public long lastModified() throws IOException {
        return this.file.getUploadDate().getTime();
    }

    public Object getId() {
        return this.file.getId();
    }

    public String getContentType() {
        return this.file.getContentType();
    }
}

