/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import lombok.NonNull;
import org.springframework.data.domain.Persistable;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;

class PersistableMongoEntityInformation<T, ID extends Serializable>
implements MongoEntityInformation<T, ID> {
    @NonNull
    private final MongoEntityInformation<T, ID> delegate;

    @Override
    public String getCollectionName() {
        return this.delegate.getCollectionName();
    }

    @Override
    public String getIdAttribute() {
        return this.delegate.getIdAttribute();
    }

    public boolean isNew(T t) {
        if (t instanceof Persistable) {
            return ((Persistable)t).isNew();
        }
        return this.delegate.isNew(t);
    }

    public ID getId(T t) {
        if (t instanceof Persistable) {
            return (ID)((Persistable)t).getId();
        }
        return (ID)this.delegate.getId(t);
    }

    public Class<ID> getIdType() {
        return this.delegate.getIdType();
    }

    public Class<T> getJavaType() {
        return this.delegate.getJavaType();
    }

    @ConstructorProperties(value={"delegate"})
    public PersistableMongoEntityInformation(@NonNull MongoEntityInformation<T, ID> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.delegate = delegate;
    }
}

