/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.BulkWriteException;
import com.mongodb.BulkWriteOperation;
import com.mongodb.BulkWriteRequestBuilder;
import com.mongodb.BulkWriteResult;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.util.Arrays;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.DefaultWriteConcernResolver;
import org.springframework.data.mongodb.core.MongoAction;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.WriteConcernResolver;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.util.Assert;

class DefaultBulkOperations
implements BulkOperations {
    private final MongoOperations mongoOperations;
    private final BulkOperations.BulkMode bulkMode;
    private final String collectionName;
    private final Class<?> entityType;
    private PersistenceExceptionTranslator exceptionTranslator;
    private WriteConcernResolver writeConcernResolver;
    private WriteConcern defaultWriteConcern;
    private BulkWriteOperation bulk;

    DefaultBulkOperations(MongoOperations mongoOperations, BulkOperations.BulkMode bulkMode, String collectionName, Class<?> entityType) {
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null!");
        Assert.notNull((Object)((Object)bulkMode), (String)"BulkMode must not be null!");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        this.mongoOperations = mongoOperations;
        this.bulkMode = bulkMode;
        this.collectionName = collectionName;
        this.entityType = entityType;
        this.exceptionTranslator = new MongoExceptionTranslator();
        this.writeConcernResolver = DefaultWriteConcernResolver.INSTANCE;
        this.bulk = this.initBulkOperation();
    }

    public void setExceptionTranslator(PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator == null ? new MongoExceptionTranslator() : exceptionTranslator;
    }

    public void setWriteConcernResolver(WriteConcernResolver writeConcernResolver) {
        this.writeConcernResolver = writeConcernResolver == null ? DefaultWriteConcernResolver.INSTANCE : writeConcernResolver;
    }

    public void setDefaultWriteConcern(WriteConcern defaultWriteConcern) {
        this.defaultWriteConcern = defaultWriteConcern;
    }

    @Override
    public BulkOperations insert(Object document) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        this.bulk.insert((DBObject)this.mongoOperations.getConverter().convertToMongoType(document));
        return this;
    }

    @Override
    public BulkOperations insert(List<? extends Object> documents) {
        Assert.notNull(documents, (String)"Documents must not be null!");
        for (Object object : documents) {
            this.insert(object);
        }
        return this;
    }

    @Override
    public BulkOperations updateOne(Query query, Update update) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        return this.updateOne(Arrays.asList(Pair.of((Object)query, (Object)update)));
    }

    @Override
    public BulkOperations updateOne(List<Pair<Query, Update>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null!");
        for (Pair<Query, Update> update : updates) {
            this.update((Query)update.getFirst(), (Update)update.getSecond(), false, false);
        }
        return this;
    }

    @Override
    public BulkOperations updateMulti(Query query, Update update) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        return this.updateMulti(Arrays.asList(Pair.of((Object)query, (Object)update)));
    }

    @Override
    public BulkOperations updateMulti(List<Pair<Query, Update>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null!");
        for (Pair<Query, Update> update : updates) {
            this.update((Query)update.getFirst(), (Update)update.getSecond(), false, true);
        }
        return this;
    }

    @Override
    public BulkOperations upsert(Query query, Update update) {
        return this.update(query, update, true, true);
    }

    @Override
    public BulkOperations upsert(List<Pair<Query, Update>> updates) {
        for (Pair<Query, Update> update : updates) {
            this.upsert((Query)update.getFirst(), (Update)update.getSecond());
        }
        return this;
    }

    @Override
    public BulkOperations remove(Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        this.bulk.find(query.getQueryObject()).remove();
        return this;
    }

    @Override
    public BulkOperations remove(List<Query> removes) {
        Assert.notNull(removes, (String)"Removals must not be null!");
        for (Query query : removes) {
            this.remove(query);
        }
        return this;
    }

    @Override
    public BulkWriteResult execute() {
        MongoAction action = new MongoAction(this.defaultWriteConcern, MongoActionOperation.BULK, this.collectionName, this.entityType, null, null);
        WriteConcern writeConcern = this.writeConcernResolver.resolve(action);
        try {
            BulkWriteResult bulkWriteResult = writeConcern == null ? this.bulk.execute() : this.bulk.execute(writeConcern);
            return bulkWriteResult;
        }
        catch (BulkWriteException o_O) {
            DataAccessException toThrow = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw toThrow == null ? o_O : toThrow;
        }
        finally {
            this.bulk = this.initBulkOperation();
        }
    }

    private BulkOperations update(Query query, Update update, boolean upsert, boolean multi) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        BulkWriteRequestBuilder builder = this.bulk.find(query.getQueryObject());
        if (upsert) {
            if (multi) {
                builder.upsert().update(update.getUpdateObject());
            } else {
                builder.upsert().updateOne(update.getUpdateObject());
            }
        } else if (multi) {
            builder.update(update.getUpdateObject());
        } else {
            builder.updateOne(update.getUpdateObject());
        }
        return this;
    }

    private final BulkWriteOperation initBulkOperation() {
        DBCollection collection = this.mongoOperations.getCollection(this.collectionName);
        switch (this.bulkMode) {
            case ORDERED: {
                return collection.initializeOrderedBulkOperation();
            }
            case UNORDERED: {
                return collection.initializeUnorderedBulkOperation();
            }
        }
        throw new IllegalStateException("BulkMode was null!");
    }
}

