/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.bson.BsonObjectId;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.AntPath;
import org.springframework.data.mongodb.gridfs.GridFsCriteria;
import org.springframework.data.mongodb.gridfs.GridFsOperations;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GridFsTemplate
implements GridFsOperations,
ResourcePatternResolver {
    private final MongoDbFactory dbFactory;
    @Nullable
    private final String bucket;
    private final MongoConverter converter;
    private final QueryMapper queryMapper;

    public GridFsTemplate(MongoDbFactory dbFactory, MongoConverter converter) {
        this(dbFactory, converter, null);
    }

    public GridFsTemplate(MongoDbFactory dbFactory, MongoConverter converter, @Nullable String bucket) {
        Assert.notNull((Object)dbFactory, (String)"MongoDbFactory must not be null!");
        Assert.notNull((Object)converter, (String)"MongoConverter must not be null!");
        this.dbFactory = dbFactory;
        this.converter = converter;
        this.bucket = bucket;
        this.queryMapper = new QueryMapper(converter);
    }

    @Override
    public ObjectId store(InputStream content, String filename) {
        return this.store(content, filename, (Object)null);
    }

    @Override
    public ObjectId store(InputStream content, @Nullable Object metadata) {
        return this.store(content, null, metadata);
    }

    @Override
    public ObjectId store(InputStream content, @Nullable Document metadata) {
        return this.store(content, (String)null, metadata);
    }

    @Override
    public ObjectId store(InputStream content, @Nullable String filename, @Nullable String contentType) {
        return this.store(content, filename, contentType, (Object)null);
    }

    @Override
    public ObjectId store(InputStream content, @Nullable String filename, @Nullable Object metadata) {
        return this.store(content, filename, null, metadata);
    }

    @Override
    public ObjectId store(InputStream content, @Nullable String filename, @Nullable String contentType, @Nullable Object metadata) {
        Document document = null;
        if (metadata != null) {
            document = new Document();
            this.converter.write(metadata, document);
        }
        return this.store(content, filename, contentType, document);
    }

    @Override
    public ObjectId store(InputStream content, @Nullable String filename, @Nullable Document metadata) {
        return this.store(content, filename, (String)null, metadata);
    }

    @Override
    public ObjectId store(InputStream content, @Nullable String filename, @Nullable String contentType, @Nullable Document metadata) {
        Assert.notNull((Object)content, (String)"InputStream must not be null!");
        GridFSUploadOptions options = new GridFSUploadOptions();
        Document mData = new Document();
        if (StringUtils.hasText((String)contentType)) {
            mData.put("_contentType", (Object)contentType);
        }
        if (metadata != null) {
            mData.putAll((Map)metadata);
        }
        options.metadata(mData);
        return this.getGridFs().uploadFromStream(filename, content, options);
    }

    @Override
    public GridFSFindIterable find(Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Document queryObject = this.getMappedQuery(query.getQueryObject());
        Document sortObject = this.getMappedQuery(query.getSortObject());
        return this.getGridFs().find((Bson)queryObject).sort((Bson)sortObject);
    }

    @Override
    public GridFSFile findOne(Query query) {
        return (GridFSFile)this.find(query).first();
    }

    @Override
    public void delete(Query query) {
        for (GridFSFile x : this.find(query)) {
            this.getGridFs().delete(((BsonObjectId)x.getId()).getValue());
        }
    }

    public ClassLoader getClassLoader() {
        return this.dbFactory.getClass().getClassLoader();
    }

    @Override
    public GridFsResource getResource(String location) {
        return Optional.ofNullable(this.findOne(Query.query(GridFsCriteria.whereFilename().is(location)))).map(this::getResource).orElseGet(() -> GridFsResource.absent(location));
    }

    @Override
    public GridFsResource getResource(GridFSFile file) {
        Assert.notNull((Object)file, (String)"GridFSFile must not be null!");
        return new GridFsResource(file, (InputStream)this.getGridFs().openDownloadStream(file.getObjectId()));
    }

    @Override
    public GridFsResource[] getResources(String locationPattern) {
        if (!StringUtils.hasText((String)locationPattern)) {
            return new GridFsResource[0];
        }
        AntPath path = new AntPath(locationPattern);
        if (path.isPattern()) {
            GridFSFindIterable files = this.find(Query.query(GridFsCriteria.whereFilename().regex(path.toRegex())));
            ArrayList<GridFsResource> resources = new ArrayList<GridFsResource>();
            for (GridFSFile file : files) {
                resources.add(this.getResource(file));
            }
            return resources.toArray(new GridFsResource[0]);
        }
        return new GridFsResource[]{this.getResource(locationPattern)};
    }

    private Document getMappedQuery(Document query) {
        return this.queryMapper.getMappedObject((Bson)query, Optional.empty());
    }

    private GridFSBucket getGridFs() {
        MongoDatabase db = this.dbFactory.getDb();
        return this.bucket == null ? GridFSBuckets.create((MongoDatabase)db) : GridFSBuckets.create((MongoDatabase)db, (String)this.bucket);
    }
}

