/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Example;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.InvalidPersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoExampleMapper;
import org.springframework.data.mongodb.core.convert.MongoJsonSchemaMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class QueryMapper {
    private static final List<String> DEFAULT_ID_NAMES = Arrays.asList("id", "_id");
    private static final Document META_TEXT_SCORE = new Document("$meta", (Object)"textScore");
    static final ClassTypeInformation<?> NESTED_DOCUMENT = ClassTypeInformation.from(MappingMongoConverter.NestedDocument.class);
    private final ConversionService conversionService;
    private final MongoConverter converter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final MongoExampleMapper exampleMapper;
    private final MongoJsonSchemaMapper schemaMapper;

    public QueryMapper(MongoConverter converter) {
        Assert.notNull((Object)converter, (String)"MongoConverter must not be null!");
        this.conversionService = converter.getConversionService();
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.exampleMapper = new MongoExampleMapper(converter);
        this.schemaMapper = new MongoJsonSchemaMapper(converter);
    }

    public Document getMappedObject(Bson query, Optional<? extends MongoPersistentEntity<?>> entity) {
        return this.getMappedObject(query, (MongoPersistentEntity<?>)entity.orElse(null));
    }

    public Document getMappedObject(Bson query, @Nullable MongoPersistentEntity<?> entity) {
        if (this.isNestedKeyword(query)) {
            return this.getMappedKeyword(new Keyword(query), entity);
        }
        Document result = new Document();
        for (String key : BsonUtils.asMap(query).keySet()) {
            if (Query.isRestrictedTypeKey(key)) {
                Set restrictedTypes = (Set)BsonUtils.get(query, key);
                this.converter.getTypeMapper().writeTypeRestrictions(result, restrictedTypes);
                continue;
            }
            if (this.isTypeKey(key)) {
                result.put(key, BsonUtils.get(query, key));
                continue;
            }
            if (this.isKeyword(key)) {
                result.putAll((Map)this.getMappedKeyword(new Keyword(query, key), entity));
                continue;
            }
            try {
                Field field = this.createPropertyField(entity, key, this.mappingContext);
                Map.Entry<String, Object> entry = this.getMappedObjectForField(field, BsonUtils.get(query, key));
                result.put(entry.getKey(), entry.getValue());
            }
            catch (InvalidPersistentPropertyPath invalidPathException) {
                if (!(BsonUtils.get(query, key) instanceof Document)) {
                    throw invalidPathException;
                }
                result.put(key, BsonUtils.get(query, key));
            }
        }
        return result;
    }

    public Document getMappedSort(Document sortObject, @Nullable MongoPersistentEntity<?> entity) {
        Assert.notNull((Object)sortObject, (String)"SortObject must not be null!");
        if (sortObject.isEmpty()) {
            return new Document();
        }
        Document mappedSort = this.getMappedObject((Bson)sortObject, entity);
        this.mapMetaAttributes(mappedSort, entity, MetaMapping.WHEN_PRESENT);
        return mappedSort;
    }

    public Document getMappedFields(Document fieldsObject, @Nullable MongoPersistentEntity<?> entity) {
        Assert.notNull((Object)fieldsObject, (String)"FieldsObject must not be null!");
        Document mappedFields = fieldsObject.isEmpty() ? new Document() : this.getMappedObject((Bson)fieldsObject, entity);
        this.mapMetaAttributes(mappedFields, entity, MetaMapping.FORCE);
        return mappedFields;
    }

    private void mapMetaAttributes(Document source, @Nullable MongoPersistentEntity<?> entity, MetaMapping metaMapping) {
        if (entity == null) {
            return;
        }
        if (entity.hasTextScoreProperty() && !MetaMapping.IGNORE.equals((Object)metaMapping)) {
            MongoPersistentProperty textScoreProperty = entity.getTextScoreProperty();
            if (MetaMapping.FORCE.equals((Object)metaMapping) || MetaMapping.WHEN_PRESENT.equals((Object)metaMapping) && source.containsKey((Object)textScoreProperty.getFieldName())) {
                source.putAll((Map)this.getMappedTextScoreField(textScoreProperty));
            }
        }
    }

    private Document getMappedTextScoreField(MongoPersistentProperty property) {
        return new Document(property.getFieldName(), (Object)META_TEXT_SCORE);
    }

    protected Map.Entry<String, Object> getMappedObjectForField(Field field, Object rawValue) {
        Object value;
        String key = field.getMappedKey();
        if (this.isNestedKeyword(rawValue) && !field.isIdField()) {
            Keyword keyword = new Keyword((Bson)((Document)rawValue));
            value = this.getMappedKeyword(field, keyword);
        } else {
            value = this.getMappedValue(field, rawValue);
        }
        return this.createMapEntry(key, value);
    }

    protected Field createPropertyField(@Nullable MongoPersistentEntity<?> entity, String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        return entity == null ? new Field(key) : new MetadataBackedField(key, entity, mappingContext);
    }

    protected Document getMappedKeyword(Keyword keyword, @Nullable MongoPersistentEntity<?> entity) {
        if (keyword.isOrOrNor() || keyword.hasIterableValue() && !keyword.isGeometry()) {
            Iterable conditions = (Iterable)keyword.getValue();
            ArrayList<Object> newConditions = new ArrayList<Object>();
            for (Object condition : conditions) {
                newConditions.add(this.isDocument(condition) ? this.getMappedObject((Bson)((Document)condition), entity) : this.convertSimpleOrDocument(condition, entity));
            }
            return new Document(keyword.getKey(), newConditions);
        }
        if (keyword.isSample()) {
            return this.exampleMapper.getMappedExample((Example)keyword.getValue(), entity);
        }
        if (keyword.isJsonSchema()) {
            return this.schemaMapper.mapSchema(new Document(keyword.getKey(), keyword.getValue()), entity.getType());
        }
        return new Document(keyword.getKey(), this.convertSimpleOrDocument(keyword.getValue(), entity));
    }

    protected Document getMappedKeyword(Field property, Keyword keyword) {
        boolean needsAssociationConversion = property.isAssociation() && !keyword.isExists() && keyword.mayHoldDbRef();
        Object value = keyword.getValue();
        Object convertedValue = needsAssociationConversion ? this.convertAssociation(value, property) : this.getMappedValue(property.with(keyword.getKey()), value);
        return new Document(keyword.key, convertedValue);
    }

    @Nullable
    protected Object getMappedValue(Field documentField, Object value) {
        if (documentField.isIdField() && !documentField.isAssociation()) {
            if (this.isDBObject(value)) {
                DBObject valueDbo = (DBObject)value;
                Document resultDbo = new Document(valueDbo.toMap());
                if (valueDbo.containsField("$in") || valueDbo.containsField("$nin")) {
                    String inKey = valueDbo.containsField("$in") ? "$in" : "$nin";
                    ArrayList<Object> ids = new ArrayList<Object>();
                    for (Object id : (Iterable)valueDbo.get(inKey)) {
                        ids.add(this.convertId(id));
                    }
                    resultDbo.put(inKey, ids);
                } else if (valueDbo.containsField("$ne")) {
                    resultDbo.put("$ne", this.convertId(valueDbo.get("$ne")));
                } else {
                    return this.getMappedObject((Bson)resultDbo, Optional.empty());
                }
                return resultDbo;
            }
            if (this.isDocument(value)) {
                Document valueDbo = (Document)value;
                Document resultDbo = new Document((Map)valueDbo);
                if (valueDbo.containsKey((Object)"$in") || valueDbo.containsKey((Object)"$nin")) {
                    String inKey = valueDbo.containsKey((Object)"$in") ? "$in" : "$nin";
                    ArrayList<Object> ids = new ArrayList<Object>();
                    for (Object id : (Iterable)valueDbo.get((Object)inKey)) {
                        ids.add(this.convertId(id));
                    }
                    resultDbo.put(inKey, ids);
                } else if (valueDbo.containsKey((Object)"$ne")) {
                    resultDbo.put("$ne", this.convertId(valueDbo.get((Object)"$ne")));
                } else {
                    return this.getMappedObject((Bson)resultDbo, Optional.empty());
                }
                return resultDbo;
            }
            return this.convertId(value);
        }
        if (this.isNestedKeyword(value)) {
            return this.getMappedKeyword(new Keyword((Bson)value), documentField.getPropertyEntity());
        }
        if (this.isAssociationConversionNecessary(documentField, value)) {
            return this.convertAssociation(value, documentField);
        }
        return this.convertSimpleOrDocument(value, documentField.getPropertyEntity());
    }

    protected boolean isAssociationConversionNecessary(Field documentField, @Nullable Object value) {
        Assert.notNull((Object)documentField, (String)"Document field must not be null!");
        if (value == null) {
            return false;
        }
        if (!documentField.isAssociation()) {
            return false;
        }
        Class<?> type = value.getClass();
        MongoPersistentProperty property = documentField.getProperty();
        if (property.getActualType().isAssignableFrom(type)) {
            return true;
        }
        MongoPersistentEntity<?> entity = documentField.getPropertyEntity();
        return entity.hasIdProperty() && (type.equals(DBRef.class) || ((MongoPersistentProperty)entity.getRequiredIdProperty()).getActualType().isAssignableFrom(type));
    }

    @Nullable
    protected Object convertSimpleOrDocument(Object source, @Nullable MongoPersistentEntity<?> entity) {
        if (source instanceof List) {
            return this.delegateConvertToMongoType(source, entity);
        }
        if (this.isDocument(source)) {
            return this.getMappedObject((Bson)((Document)source), entity);
        }
        if (source instanceof BasicDBList) {
            return this.delegateConvertToMongoType(source, entity);
        }
        if (this.isDBObject(source)) {
            return this.getMappedObject((Bson)((BasicDBObject)source), entity);
        }
        if (source instanceof BsonValue) {
            return source;
        }
        if (source instanceof Map) {
            LinkedHashMap map = new LinkedHashMap();
            ((Map)source).entrySet().forEach(it -> {
                String key = ObjectUtils.nullSafeToString((Object)this.converter.convertToMongoType(it.getKey()));
                if (it.getValue() instanceof Document) {
                    map.put(key, this.getMappedObject((Bson)((Document)it.getValue()), entity));
                } else {
                    map.put(key, this.delegateConvertToMongoType(it.getValue(), entity));
                }
            });
            return map;
        }
        return this.delegateConvertToMongoType(source, entity);
    }

    @Nullable
    protected Object delegateConvertToMongoType(Object source, @Nullable MongoPersistentEntity<?> entity) {
        return this.converter.convertToMongoType(source, entity == null ? null : entity.getTypeInformation());
    }

    protected Object convertAssociation(Object source, Field field) {
        return this.convertAssociation(source, field.getProperty());
    }

    @Nullable
    protected Object convertAssociation(@Nullable Object source, @Nullable MongoPersistentProperty property) {
        if (property == null || source == null || source instanceof Document || source instanceof DBObject) {
            return source;
        }
        if (source instanceof DBRef) {
            DBRef ref = (DBRef)source;
            return new DBRef(ref.getCollectionName(), this.convertId(ref.getId()));
        }
        if (source instanceof Iterable) {
            BasicDBList result = new BasicDBList();
            for (Object element : (Iterable)source) {
                result.add((Object)this.createDbRefFor(element, property));
            }
            return result;
        }
        if (property.isMap()) {
            Document result = new Document();
            Document dbObject = (Document)source;
            for (String key : dbObject.keySet()) {
                result.put(key, (Object)this.createDbRefFor(dbObject.get((Object)key), property));
            }
            return result;
        }
        return this.createDbRefFor(source, property);
    }

    protected final boolean isDocument(@Nullable Object value) {
        return value instanceof Document;
    }

    protected final boolean isDBObject(@Nullable Object value) {
        return value instanceof DBObject;
    }

    protected final Map.Entry<String, Object> createMapEntry(Field field, @Nullable Object value) {
        return this.createMapEntry(field.getMappedKey(), value);
    }

    private Map.Entry<String, Object> createMapEntry(String key, @Nullable Object value) {
        Assert.hasText((String)key, (String)"Key must not be null or empty!");
        return Collections.singletonMap(key, value).entrySet().iterator().next();
    }

    private DBRef createDbRefFor(Object source, MongoPersistentProperty property) {
        if (source instanceof DBRef) {
            return (DBRef)source;
        }
        return this.converter.toDBRef(source, property);
    }

    @Nullable
    public Object convertId(@Nullable Object id) {
        if (id == null) {
            return null;
        }
        if (id instanceof String) {
            return ObjectId.isValid((String)id.toString()) ? this.conversionService.convert(id, ObjectId.class) : id;
        }
        try {
            return this.conversionService.canConvert(id.getClass(), ObjectId.class) ? this.conversionService.convert(id, ObjectId.class) : this.delegateConvertToMongoType(id, null);
        }
        catch (ConversionException o_O) {
            return this.delegateConvertToMongoType(id, null);
        }
    }

    protected boolean isNestedKeyword(Object candidate) {
        if (!(candidate instanceof Document)) {
            return false;
        }
        Set<String> keys = BsonUtils.asMap((Bson)candidate).keySet();
        if (keys.size() != 1) {
            return false;
        }
        return this.isKeyword(keys.iterator().next().toString());
    }

    protected boolean isTypeKey(String key) {
        return this.converter.getTypeMapper().isTypeKey(key);
    }

    protected boolean isKeyword(String candidate) {
        return candidate.startsWith("$");
    }

    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    protected static class AssociationConverter
    implements Converter<MongoPersistentProperty, String> {
        private final MongoPersistentProperty property;
        private boolean associationFound;

        public AssociationConverter(Association<MongoPersistentProperty> association) {
            Assert.notNull(association, (String)"Association must not be null!");
            this.property = (MongoPersistentProperty)association.getInverse();
        }

        public String convert(MongoPersistentProperty source) {
            if (this.associationFound) {
                return null;
            }
            if (this.property.equals(source)) {
                this.associationFound = true;
            }
            return source.getFieldName();
        }
    }

    protected static class MetadataBackedField
    extends Field {
        private static final String INVALID_ASSOCIATION_REFERENCE = "Invalid path reference %s! Associations can only be pointed to directly or via their id property!";
        private final MongoPersistentEntity<?> entity;
        private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
        private final MongoPersistentProperty property;
        @Nullable
        private final PersistentPropertyPath<MongoPersistentProperty> path;
        @Nullable
        private final Association<MongoPersistentProperty> association;

        public MetadataBackedField(String name, MongoPersistentEntity<?> entity, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context) {
            this(name, entity, context, null);
        }

        public MetadataBackedField(String name, MongoPersistentEntity<?> entity, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context, @Nullable MongoPersistentProperty property) {
            super(name);
            Assert.notNull(entity, (String)"MongoPersistentEntity must not be null!");
            this.entity = entity;
            this.mappingContext = context;
            this.path = this.getPath(name);
            this.property = this.path == null ? property : (MongoPersistentProperty)this.path.getLeafProperty();
            this.association = this.findAssociation();
        }

        @Override
        public MetadataBackedField with(String name) {
            return new MetadataBackedField(name, this.entity, this.mappingContext, this.property);
        }

        @Override
        public boolean isIdField() {
            if (this.property != null) {
                return this.property.isIdProperty();
            }
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getIdProperty();
            if (idProperty != null) {
                return this.name.equals(idProperty.getName()) || this.name.equals(idProperty.getFieldName());
            }
            return DEFAULT_ID_NAMES.contains(this.name);
        }

        @Override
        public MongoPersistentProperty getProperty() {
            return this.association == null ? this.property : (MongoPersistentProperty)this.association.getInverse();
        }

        @Override
        public MongoPersistentEntity<?> getPropertyEntity() {
            MongoPersistentProperty property = this.getProperty();
            return property == null ? null : (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)property);
        }

        @Override
        public boolean isAssociation() {
            return this.association != null;
        }

        @Override
        public Association<MongoPersistentProperty> getAssociation() {
            return this.association;
        }

        @Nullable
        private Association<MongoPersistentProperty> findAssociation() {
            if (this.path != null) {
                for (MongoPersistentProperty p : this.path) {
                    Association association = p.getAssociation();
                    if (association == null) continue;
                    return association;
                }
            }
            return null;
        }

        @Override
        public String getMappedKey() {
            return this.path == null ? this.name : this.path.toDotPath(this.isAssociation() ? this.getAssociationConverter() : this.getPropertyConverter());
        }

        @Nullable
        protected PersistentPropertyPath<MongoPersistentProperty> getPath() {
            return this.path;
        }

        @Nullable
        private PersistentPropertyPath<MongoPersistentProperty> getPath(String pathExpression) {
            String rawPath = pathExpression.replaceAll("\\.\\d+", "");
            PropertyPath path = this.forName(rawPath);
            if (path == null || this.isPathToJavaLangClassProperty(path)) {
                return null;
            }
            try {
                PersistentPropertyPath propertyPath = this.mappingContext.getPersistentPropertyPath(path);
                Iterator iterator = propertyPath.iterator();
                boolean associationDetected = false;
                while (iterator.hasNext()) {
                    MongoPersistentProperty property = (MongoPersistentProperty)iterator.next();
                    if (property.isAssociation()) {
                        associationDetected = true;
                        continue;
                    }
                    if (!associationDetected || property.isIdProperty()) continue;
                    throw new MappingException(String.format(INVALID_ASSOCIATION_REFERENCE, pathExpression));
                }
                return propertyPath;
            }
            catch (InvalidPersistentPropertyPath e) {
                return null;
            }
        }

        @Nullable
        private PropertyPath forName(String path) {
            try {
                return PropertyPath.from((String)path, (TypeInformation)this.entity.getTypeInformation());
            }
            catch (PropertyReferenceException | InvalidPersistentPropertyPath e) {
                if (path.endsWith("_id")) {
                    return this.forName(path.substring(0, path.length() - 3) + "id");
                }
                return null;
            }
        }

        private boolean isPathToJavaLangClassProperty(PropertyPath path) {
            return path.getType().equals(Class.class) && path.getLeafProperty().getOwningType().getType().equals(Class.class);
        }

        protected Converter<MongoPersistentProperty, String> getPropertyConverter() {
            return new PositionParameterRetainingPropertyKeyConverter(this.name);
        }

        protected Converter<MongoPersistentProperty, String> getAssociationConverter() {
            return new AssociationConverter(this.getAssociation());
        }

        @Override
        public TypeInformation<?> getTypeHint() {
            MongoPersistentProperty property = this.getProperty();
            if (property == null) {
                return super.getTypeHint();
            }
            if (property.getActualType().isInterface() || Modifier.isAbstract(property.getActualType().getModifiers())) {
                return ClassTypeInformation.OBJECT;
            }
            return NESTED_DOCUMENT;
        }

        static class KeyMapper {
            private final Iterator<String> iterator;

            public KeyMapper(String key) {
                this.iterator = Arrays.asList(key.split("\\.")).iterator();
                this.iterator.next();
            }

            protected String mapPropertyName(MongoPersistentProperty property) {
                StringBuilder mappedName = new StringBuilder(MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE.convert(property));
                boolean inspect = this.iterator.hasNext();
                while (inspect) {
                    boolean isPositional;
                    String partial = this.iterator.next();
                    boolean bl = isPositional = KeyMapper.isPositionalParameter(partial) && (property.isMap() || property.isCollectionLike());
                    if (isPositional) {
                        mappedName.append(".").append(partial);
                    }
                    inspect = isPositional && this.iterator.hasNext();
                }
                return mappedName.toString();
            }

            private static boolean isPositionalParameter(String partial) {
                if ("$".equals(partial)) {
                    return true;
                }
                try {
                    Long.valueOf(partial);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }

        static class PositionParameterRetainingPropertyKeyConverter
        implements Converter<MongoPersistentProperty, String> {
            private final KeyMapper keyMapper;

            public PositionParameterRetainingPropertyKeyConverter(String rawKey) {
                this.keyMapper = new KeyMapper(rawKey);
            }

            public String convert(MongoPersistentProperty source) {
                return this.keyMapper.mapPropertyName(source);
            }
        }
    }

    protected static class Field {
        private static final String ID_KEY = "_id";
        protected final String name;

        public Field(String name) {
            Assert.hasText((String)name, (String)"Name must not be null!");
            this.name = name;
        }

        public Field with(String name) {
            return new Field(name);
        }

        public boolean isIdField() {
            return ID_KEY.equals(this.name);
        }

        @Nullable
        public MongoPersistentProperty getProperty() {
            return null;
        }

        @Nullable
        public MongoPersistentEntity<?> getPropertyEntity() {
            return null;
        }

        public boolean isAssociation() {
            return false;
        }

        public String getMappedKey() {
            return this.isIdField() ? ID_KEY : this.name;
        }

        public boolean containsAssociation() {
            return false;
        }

        @Nullable
        public Association<MongoPersistentProperty> getAssociation() {
            return null;
        }

        public boolean isMap() {
            return this.getProperty() != null && this.getProperty().isMap();
        }

        public TypeInformation<?> getTypeHint() {
            return ClassTypeInformation.OBJECT;
        }
    }

    static class Keyword {
        private static final String N_OR_PATTERN = "\\$.*or";
        private static final Set<String> NON_DBREF_CONVERTING_KEYWORDS = new HashSet<String>(Arrays.asList("$", "$size", "$slice", "$gt", "$lt"));
        private final String key;
        private final Object value;

        public Keyword(Bson source, String key) {
            this.key = key;
            this.value = BsonUtils.get(source, key);
        }

        public Keyword(Bson bson) {
            Set<String> keys = BsonUtils.asMap(bson).keySet();
            Assert.isTrue((keys.size() == 1 ? 1 : 0) != 0, (String)"Can only use a single value Document!");
            this.key = keys.iterator().next();
            this.value = BsonUtils.get(bson, this.key);
        }

        public boolean isExists() {
            return "$exists".equalsIgnoreCase(this.key);
        }

        public boolean isOrOrNor() {
            return this.key.matches(N_OR_PATTERN);
        }

        public boolean isGeometry() {
            return "$geometry".equalsIgnoreCase(this.key);
        }

        public boolean isSample() {
            return "$example".equalsIgnoreCase(this.key);
        }

        public boolean hasIterableValue() {
            return this.value instanceof Iterable;
        }

        public String getKey() {
            return this.key;
        }

        public <T> T getValue() {
            return (T)this.value;
        }

        public boolean mayHoldDbRef() {
            return !NON_DBREF_CONVERTING_KEYWORDS.contains(this.key);
        }

        public boolean isJsonSchema() {
            return "$jsonSchema".equalsIgnoreCase(this.key);
        }
    }

    private static enum MetaMapping {
        FORCE,
        WHEN_PRESENT,
        IGNORE;

    }
}

