/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.DBRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ConvertingParameterAccessor
implements MongoParameterAccessor {
    private final MongoWriter<?> writer;
    private final MongoParameterAccessor delegate;

    public ConvertingParameterAccessor(MongoWriter<?> writer, MongoParameterAccessor delegate) {
        Assert.notNull(writer, (String)"MongoWriter must not be null!");
        Assert.notNull((Object)delegate, (String)"MongoParameterAccessor must not be null!");
        this.writer = writer;
        this.delegate = delegate;
    }

    public PotentiallyConvertingIterator iterator() {
        return new ConvertingIterator(this.delegate.iterator());
    }

    public Pageable getPageable() {
        return this.delegate.getPageable();
    }

    public Sort getSort() {
        return this.delegate.getSort();
    }

    public Optional<Class<?>> getDynamicProjection() {
        return this.delegate.getDynamicProjection();
    }

    public Class<?> findDynamicProjection() {
        return this.delegate.findDynamicProjection();
    }

    public Object getBindableValue(int index) {
        return this.getConvertedValue(this.delegate.getBindableValue(index), null);
    }

    @Override
    public Range<Distance> getDistanceRange() {
        return this.delegate.getDistanceRange();
    }

    @Override
    public Point getGeoNearLocation() {
        return this.delegate.getGeoNearLocation();
    }

    @Override
    public TextCriteria getFullText() {
        return this.delegate.getFullText();
    }

    @Override
    public Collation getCollation() {
        return this.delegate.getCollation();
    }

    @Override
    public UpdateDefinition getUpdate() {
        return this.delegate.getUpdate();
    }

    @Nullable
    private Object getConvertedValue(Object value, @Nullable TypeInformation<?> typeInformation) {
        return this.writer.convertToMongoType(value, typeInformation == null ? null : typeInformation.getActualType());
    }

    public boolean hasBindableNullValue() {
        return this.delegate.hasBindableNullValue();
    }

    private static Collection<?> asCollection(@Nullable Object source) {
        if (source instanceof Iterable) {
            if (source instanceof Collection) {
                return new ArrayList((Collection)source);
            }
            ArrayList result = new ArrayList();
            for (Object element : (Iterable)source) {
                result.add(element);
            }
            return result;
        }
        if (source == null) {
            return Collections.emptySet();
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    @Override
    public Object[] getValues() {
        return this.delegate.getValues();
    }

    public static interface PotentiallyConvertingIterator
    extends Iterator<Object> {
        public Object nextConverted(MongoPersistentProperty var1);
    }

    private class ConvertingIterator
    implements PotentiallyConvertingIterator {
        private final Iterator<Object> delegate;

        public ConvertingIterator(Iterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object next() {
            return this.delegate.next();
        }

        @Override
        public Object nextConverted(MongoPersistentProperty property) {
            Object next = this.next();
            if (next == null) {
                return null;
            }
            if (property.isAssociation()) {
                if (next.getClass().isArray() || next instanceof Iterable) {
                    Collection values = ConvertingParameterAccessor.asCollection(next);
                    ArrayList<DBRef> dbRefs = new ArrayList<DBRef>(values.size());
                    for (Object element : values) {
                        dbRefs.add(ConvertingParameterAccessor.this.writer.toDBRef(element, property));
                    }
                    return dbRefs;
                }
                return ConvertingParameterAccessor.this.writer.toDBRef(next, property);
            }
            return ConvertingParameterAccessor.this.getConvertedValue(next, property.getTypeInformation());
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

