/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.encryption;

import java.util.UUID;
import java.util.function.Supplier;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.types.Binary;
import org.springframework.data.mongodb.util.spel.ExpressionUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;

public final class EncryptionUtils {
    @Nullable
    public static Object resolveKeyId(String value, Supplier<EvaluationContext> evaluationContext) {
        Assert.notNull((Object)value, (String)"Value must not be null!");
        Object potentialKeyId = value;
        Expression expression = ExpressionUtils.detectExpression(value);
        if (expression != null && !((potentialKeyId = expression.getValue(evaluationContext.get())) instanceof String)) {
            return potentialKeyId;
        }
        try {
            return new Binary(BsonBinarySubType.UUID_STANDARD, new BsonBinary(UUID.fromString(potentialKeyId.toString())).getData());
        }
        catch (IllegalArgumentException e) {
            return new Binary(BsonBinarySubType.UUID_STANDARD, Base64Utils.decodeFromString((String)potentialKeyId.toString()));
        }
    }
}

