/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.srp;

import com.google.common.base.Charsets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.FallbackExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.AbstractRedisConnection;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.FutureResult;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.srp.SrpConverters;
import org.springframework.data.redis.connection.srp.SrpScriptReturnConverter;
import org.springframework.data.redis.connection.srp.SrpSubscription;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;
import redis.Command;
import redis.client.RedisClient;
import redis.client.RedisException;
import redis.reply.MultiBulkReply;
import redis.reply.Reply;

public class SrpConnection
extends AbstractRedisConnection {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new FallbackExceptionTranslationStrategy(SrpConverters.exceptionConverter());
    private static final Object[] EMPTY_PARAMS_ARRAY = new Object[0];
    private static final byte[] WITHSCORES = "WITHSCORES".getBytes(Charsets.UTF_8);
    private static final byte[] BY = "BY".getBytes(Charsets.UTF_8);
    private static final byte[] GET = "GET".getBytes(Charsets.UTF_8);
    private static final byte[] ALPHA = "ALPHA".getBytes(Charsets.UTF_8);
    private static final byte[] STORE = "STORE".getBytes(Charsets.UTF_8);
    private final RedisClient client;
    private final BlockingQueue<SrpConnection> queue;
    private boolean isClosed = false;
    private boolean isMulti = false;
    private boolean pipelineRequested = false;
    private RedisClient.Pipeline pipeline;
    private PipelineTracker callback;
    private PipelineTracker txTracker;
    private volatile SrpSubscription subscription;
    private boolean convertPipelineAndTxResults = true;

    SrpConnection(RedisClient client) {
        Assert.notNull((Object)client);
        this.client = client;
        this.queue = new ArrayBlockingQueue<SrpConnection>(50);
    }

    public SrpConnection(String host, int port, BlockingQueue<SrpConnection> queue) {
        try {
            this.client = new RedisClient(host, port);
            this.queue = queue;
        }
        catch (IOException e) {
            throw new RedisConnectionFailureException("Could not connect", e);
        }
        catch (RedisException e) {
            throw new RedisConnectionFailureException("Could not connect", e);
        }
    }

    public SrpConnection(String host, int port, String password, BlockingQueue<SrpConnection> queue) {
        this(host, port, queue);
        try {
            this.client.auth((Object)password);
        }
        catch (RedisException e) {
            throw new RedisConnectionFailureException("Could not connect", e);
        }
    }

    protected DataAccessException convertSrpAccessException(Exception ex) {
        return EXCEPTION_TRANSLATION.translate(ex);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        Assert.hasText((String)command, (String)"a valid command needs to be specified");
        try {
            String name = command.trim().toUpperCase();
            Command cmd = new Command((Object)name.getBytes(Charsets.UTF_8), (Object[])args);
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.client.pipeline(name, cmd)));
                return null;
            }
            return this.client.execute(name, cmd).data();
        }
        catch (RedisException ex) {
            throw this.convertSrpAccessException((Exception)((Object)ex));
        }
    }

    @Override
    public void close() throws DataAccessException {
        super.close();
        this.isClosed = true;
        this.queue.remove(this);
        if (this.subscription != null) {
            if (this.subscription.isAlive()) {
                this.subscription.doClose();
            }
            this.subscription = null;
        }
        try {
            this.client.close();
        }
        catch (IOException ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public RedisClient getNativeConnection() {
        return this.client;
    }

    @Override
    public boolean isQueueing() {
        return this.isMulti;
    }

    @Override
    public boolean isPipelined() {
        return this.pipelineRequested || this.txTracker != null;
    }

    @Override
    public void openPipeline() {
        this.pipelineRequested = true;
        this.initPipeline();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        Object[] sort = this.sortParams(params);
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpGenericResult((ListenableFuture<? extends Reply>)this.pipeline.sort((Object)key, sort), SrpConverters.repliesToBytesList()));
                return null;
            }
            return SrpConverters.toBytesList((Reply[])this.client.sort((Object)key, sort).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] sortKey) {
        Object[] sort = this.sortParams(params, sortKey);
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.sort((Object)key, sort)));
                return null;
            }
            return (Long)this.client.sort((Object)key, sort).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long dbSize() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.dbsize()));
                return null;
            }
            return this.client.dbsize().data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void flushDb() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.flushdb()));
                return;
            }
            this.client.flushdb();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void flushAll() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.flushall()));
                return;
            }
            this.client.flushall();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void bgSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.bgsave()));
                return;
            }
            this.client.bgsave();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void bgReWriteAof() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.bgrewriteaof()));
                return;
            }
            this.client.bgrewriteaof();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    @Deprecated
    public void bgWriteAof() {
        this.bgReWriteAof();
    }

    @Override
    public void save() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.save()));
                return;
            }
            this.client.save();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<String> getConfig(String param) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpGenericResult((ListenableFuture<? extends Reply>)this.pipeline.config_get((Object)param), SrpConverters.repliesToStringList()));
                return null;
            }
            return SrpConverters.toStringList(this.client.config_get((Object)param).data().toString());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Properties info() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.info(null), SrpConverters.bytesToProperties()));
                return null;
            }
            return SrpConverters.toProperties(this.client.info(null).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Properties info(String section) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.info((Object)section), SrpConverters.bytesToProperties()));
                return null;
            }
            return SrpConverters.toProperties(this.client.info((Object)section).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long lastSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.lastsave()));
                return null;
            }
            return this.client.lastsave().data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void setConfig(String param, String value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.config_set((Object)param, (Object)value)));
                return;
            }
            this.client.config_set((Object)param, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void resetConfigStats() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.config_resetstat()));
                return;
            }
            this.client.config_resetstat();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void shutdown() {
        byte[] save = "SAVE".getBytes(Charsets.UTF_8);
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.shutdown((Object)save, null)));
                return;
            }
            this.client.shutdown((Object)save, null);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void shutdown(RedisServerCommands.ShutdownOption option) {
        if (option == null) {
            this.shutdown();
            return;
        }
        byte[] save = option.name().getBytes(Charsets.UTF_8);
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.shutdown((Object)save, null)));
                return;
            }
            this.client.shutdown((Object)save, null);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.echo((Object)message)));
                return null;
            }
            return this.client.echo((Object)message).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public String ping() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.ping()));
                return null;
            }
            return this.client.ping().data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long del(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.del((Object[])keys)));
                return null;
            }
            return this.client.del((Object[])keys).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void discard() {
        this.isMulti = false;
        try {
            this.txTracker = null;
            this.client.discard();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<Object> exec() {
        this.isMulti = false;
        try {
            Future exec = this.client.exec();
            boolean resultsSet = (Boolean)exec.get();
            if (!resultsSet) {
                if (this.pipelineRequested) {
                    this.pipeline(new SrpTxResult(null));
                }
                List<Object> list = null;
                return list;
            }
            if (this.pipelineRequested) {
                this.pipeline(new SrpTxResult(this.txTracker));
                List<Object> list = null;
                return list;
            }
            List<Object> list = this.closeTransaction();
            return list;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
        finally {
            this.txTracker = null;
        }
    }

    @Override
    public Boolean exists(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.exists((Object)key), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.exists((Object)key).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.expire((Object)key, (Object)seconds), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.expire((Object)key, (Object)seconds).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.expireat((Object)key, (Object)unixTime), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.expireat((Object)key, (Object)unixTime).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.pexpire((Object)key, (Object)millis), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.pexpire((Object)key, (Object)millis).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.pexpireat((Object)key, (Object)unixTimeInMillis), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.pexpireat((Object)key, (Object)unixTimeInMillis).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.keys((Object)pattern), SrpConverters.repliesToBytesSet()));
                return null;
            }
            return SrpConverters.toBytesSet(this.client.keys((Object)pattern).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        this.isMulti = true;
        this.initTxTracker();
        try {
            this.client.multi();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.persist((Object)key), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.persist((Object)key).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.move((Object)key, (Object)dbIndex), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.move((Object)key, (Object)dbIndex).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] randomKey() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.randomkey()));
                return null;
            }
            return this.client.randomkey().data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.rename((Object)oldName, (Object)newName)));
                return;
            }
            this.client.rename((Object)oldName, (Object)newName);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.renamenx((Object)oldName, (Object)newName), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.renamenx((Object)oldName, (Object)newName).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.select((Object)dbIndex)));
                return;
            }
            this.client.select((Object)dbIndex);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.ttl((Object)key)));
                return null;
            }
            return this.client.ttl((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.pttl((Object)key)));
                return null;
            }
            return this.client.pttl((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] dump(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.dump((Object)key)));
                return null;
            }
            return this.client.dump((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.restore((Object)key, (Object)ttlInMillis, (Object)serializedValue)));
                return;
            }
            this.client.restore((Object)key, (Object)ttlInMillis, (Object)serializedValue);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public DataType type(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.type((Object)key), SrpConverters.stringToDataType()));
                return null;
            }
            return SrpConverters.toDataType(this.client.type((Object)key).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void unwatch() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.unwatch()));
                return;
            }
            this.client.unwatch();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void watch(byte[] ... keys) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.watch((Object[])keys)));
                return;
            }
            this.client.watch((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.get((Object)key)));
                return null;
            }
            return this.client.get((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.set((Object)key, (Object)value, new Object[0])));
                return;
            }
            this.client.set((Object)key, (Object)value, new Object[0]);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.getset((Object)key, (Object)value)));
                return null;
            }
            return this.client.getset((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.append((Object)key, (Object)value)));
                return null;
            }
            return this.client.append((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.mget((Object[])keys), SrpConverters.repliesToBytesList()));
                return null;
            }
            return SrpConverters.toBytesList(this.client.mget((Object[])keys).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.mset((Object[])SrpConverters.toByteArrays(tuples))));
                return;
            }
            this.client.mset((Object[])SrpConverters.toByteArrays(tuples));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.msetnx((Object[])SrpConverters.toByteArrays(tuples)), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.msetnx((Object[])SrpConverters.toByteArrays(tuples)).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long time, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.setex((Object)key, (Object)time, (Object)value)));
                return;
            }
            this.client.setex((Object)key, (Object)time, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void pSetEx(byte[] key, long milliseconds, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.doPipelined((ListenableFuture<Reply>)this.pipeline.psetex((Object)key, (Object)milliseconds, (Object)value));
                return;
            }
            this.client.psetex((Object)key, (Object)milliseconds, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.setnx((Object)key, (Object)value), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.setnx((Object)key, (Object)value).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.getrange((Object)key, (Object)start, (Object)end)));
                return null;
            }
            return this.client.getrange((Object)key, (Object)start, (Object)end).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.decr((Object)key)));
                return null;
            }
            return this.client.decr((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.decrby((Object)key, (Object)value)));
                return null;
            }
            return this.client.decrby((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.incr((Object)key)));
                return null;
            }
            return this.client.incr((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.incrby((Object)key, (Object)value)));
                return null;
            }
            return this.client.incrby((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.incrbyfloat((Object)key, (Object)value), SrpConverters.bytesToDouble()));
                return null;
            }
            return SrpConverters.toDouble(this.client.incrbyfloat((Object)key, (Object)value).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.getbit((Object)key, (Object)offset), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.getbit((Object)key, (Object)offset).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpGenericResult((ListenableFuture<? extends Reply>)this.pipeline.setbit((Object)key, (Object)offset, (Object)SrpConverters.toBit(value)), SrpConverters.longToBooleanConverter()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.setbit((Object)key, (Object)offset, (Object)SrpConverters.toBit(value)));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.setrange((Object)key, (Object)start, (Object)value)));
                return;
            }
            this.client.setrange((Object)key, (Object)start, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long strLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.strlen((Object)key)));
                return null;
            }
            return this.client.strlen((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.bitcount((Object)key, (Object)0, (Object)-1)));
                return null;
            }
            return this.client.bitcount((Object)key, (Object)0, (Object)-1).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key, long begin, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.bitcount((Object)key, (Object)begin, (Object)end)));
                return null;
            }
            return this.client.bitcount((Object)key, (Object)begin, (Object)end).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        if (op == RedisStringCommands.BitOperation.NOT && keys.length > 1) {
            throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.bitop((Object)SrpConverters.toBytes(op), (Object)destination, (Object[])keys)));
                return null;
            }
            return this.client.bitop((Object)SrpConverters.toBytes(op), (Object)destination, (Object[])keys).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.lpush((Object)key, (Object[])values)));
                return null;
            }
            return this.client.lpush((Object)key, (Object[])values).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.rpush((Object)key, (Object[])values)));
                return null;
            }
            return this.client.rpush((Object)key, (Object[])values).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        Object[] args = this.popArgs(timeout, keys);
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.blpop(args), SrpConverters.repliesToBytesList()));
                return null;
            }
            return SrpConverters.toBytesList(this.client.blpop(args).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        Object[] args = this.popArgs(timeout, keys);
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.brpop(args), SrpConverters.repliesToBytesList()));
                return null;
            }
            return SrpConverters.toBytesList(this.client.brpop(args).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.lindex((Object)key, (Object)index)));
                return null;
            }
            return this.client.lindex((Object)key, (Object)index).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.linsert((Object)key, (Object)SrpConverters.toBytes(where), (Object)pivot, (Object)value)));
                return null;
            }
            return this.client.linsert((Object)key, (Object)SrpConverters.toBytes(where), (Object)pivot, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.llen((Object)key)));
                return null;
            }
            return this.client.llen((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.lpop((Object)key)));
                return null;
            }
            return this.client.lpop((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.lrange((Object)key, (Object)start, (Object)end), SrpConverters.repliesToBytesList()));
                return null;
            }
            return SrpConverters.toBytesList(this.client.lrange((Object)key, (Object)start, (Object)end).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.lrem((Object)key, (Object)count, (Object)value)));
                return null;
            }
            return this.client.lrem((Object)key, (Object)count, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.lset((Object)key, (Object)index, (Object)value)));
                return;
            }
            this.client.lset((Object)key, (Object)index, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.ltrim((Object)key, (Object)start, (Object)end)));
                return;
            }
            this.client.ltrim((Object)key, (Object)start, (Object)end);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.rpop((Object)key)));
                return null;
            }
            return this.client.rpop((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.rpoplpush((Object)srcKey, (Object)dstKey)));
                return null;
            }
            return this.client.rpoplpush((Object)srcKey, (Object)dstKey).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.brpoplpush((Object)srcKey, (Object)dstKey, (Object)timeout)));
                return null;
            }
            return (byte[])this.client.brpoplpush((Object)srcKey, (Object)dstKey, (Object)timeout).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.lpushx((Object)key, (Object)value)));
                return null;
            }
            return this.client.lpushx((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.rpushx((Object)key, (Object)value)));
                return null;
            }
            return this.client.rpushx((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.sadd((Object)key, (Object[])values)));
                return null;
            }
            return this.client.sadd((Object)key, (Object[])values).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long sCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.scard((Object)key)));
                return null;
            }
            return this.client.scard((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.sdiff((Object[])keys), SrpConverters.repliesToBytesSet()));
                return null;
            }
            return SrpConverters.toBytesSet(this.client.sdiff((Object[])keys).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.sdiffstore((Object)destKey, (Object[])keys)));
                return null;
            }
            return this.client.sdiffstore((Object)destKey, (Object[])keys).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.sinter((Object[])keys), SrpConverters.repliesToBytesSet()));
                return null;
            }
            return SrpConverters.toBytesSet(this.client.sinter((Object[])keys).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.sinterstore((Object)destKey, (Object[])keys)));
                return null;
            }
            return this.client.sinterstore((Object)destKey, (Object[])keys).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.sismember((Object)key, (Object)value), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.sismember((Object)key, (Object)value).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.smembers((Object)key), SrpConverters.repliesToBytesSet()));
                return null;
            }
            return SrpConverters.toBytesSet(this.client.smembers((Object)key).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.smove((Object)srcKey, (Object)destKey, (Object)value), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.smove((Object)srcKey, (Object)destKey, (Object)value).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.spop((Object)key)));
                return null;
            }
            return this.client.spop((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.srandmember((Object)key, null)));
                return null;
            }
            return (byte[])this.client.srandmember((Object)key, null).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpGenericResult((ListenableFuture<? extends Reply>)this.pipeline.srandmember((Object)key, (Object)count), SrpConverters.repliesToBytesList()));
                return null;
            }
            return SrpConverters.toBytesList(((MultiBulkReply)this.client.srandmember((Object)key, (Object)count)).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.srem((Object)key, (Object[])values)));
                return null;
            }
            return this.client.srem((Object)key, (Object[])values).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.sunion((Object[])keys), SrpConverters.repliesToBytesSet()));
                return null;
            }
            return SrpConverters.toBytesSet(this.client.sunion((Object[])keys).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.sunionstore((Object)destKey, (Object[])keys)));
                return null;
            }
            return this.client.sunionstore((Object)destKey, (Object[])keys).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.zadd(new Object[]{key, score, value}), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.zadd(new Object[]{key, score, value}).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        try {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(key);
            args.addAll(SrpConverters.toObjects(tuples));
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.zadd(args.toArray())));
                return null;
            }
            return this.client.zadd(args.toArray()).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.zcard((Object)key)));
                return null;
            }
            return this.client.zcard((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        return this.zCount(key, new RedisZSetCommands.Range().gte(min).lte(max));
    }

    @Override
    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        byte[] min = SrpConverters.boundaryToBytesForZRange(range.getMin(), SrpConverters.toBytes("-inf"));
        byte[] max = SrpConverters.boundaryToBytesForZRange(range.getMax(), SrpConverters.toBytes("+inf"));
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.zcount((Object)key, (Object)min, (Object)max)));
                return null;
            }
            return this.client.zcount((Object)key, (Object)min, (Object)max).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.zincrby((Object)key, (Object)increment, (Object)value), SrpConverters.bytesToDouble()));
                return null;
            }
            return SrpConverters.toDouble(this.client.zincrby((Object)key, (Object)increment, (Object)value).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.zinterstore((Object)destKey, (Object)sets.length, (Object[])sets)));
                return null;
            }
            return this.client.zinterstore((Object)destKey, (Object)sets.length, (Object[])sets).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.zrange((Object)key, (Object)start, (Object)end, null), SrpConverters.repliesToBytesSet()));
                return null;
            }
            return SrpConverters.toBytesSet(this.client.zrange((Object)key, (Object)start, (Object)end, null).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.zrange((Object)key, (Object)start, (Object)end, (Object)WITHSCORES), SrpConverters.repliesToTupleSet()));
                return null;
            }
            return SrpConverters.toTupleSet(this.client.zrange((Object)key, (Object)start, (Object)end, (Object)WITHSCORES).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        return this.zRangeByScore(key, new RedisZSetCommands.Range().gte(min).lte(max));
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return this.zRangeByScore(key, range, null);
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYSCORE must not be null!");
        byte[] min = SrpConverters.boundaryToBytesForZRange(range.getMin(), SrpConverters.toBytes("-inf"));
        byte[] max = SrpConverters.boundaryToBytesForZRange(range.getMax(), SrpConverters.toBytes("+inf"));
        Object[] params = limit != null ? this.limitParams(limit.getOffset(), limit.getCount()) : EMPTY_PARAMS_ARRAY;
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.zrangebyscore((Object)key, (Object)min, (Object)max, null, params), SrpConverters.repliesToBytesSet()));
                return null;
            }
            return SrpConverters.toBytesSet(this.client.zrangebyscore((Object)key, (Object)min, (Object)max, null, params).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.zRangeByScoreWithScores(key, new RedisZSetCommands.Range().gte(min).lte(max));
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        return this.zRangeByScoreWithScores(key, range, null);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYSCOREWITHSCORES must not be null!");
        byte[] min = SrpConverters.boundaryToBytesForZRange(range.getMin(), SrpConverters.toBytes("-inf"));
        byte[] max = SrpConverters.boundaryToBytesForZRange(range.getMax(), SrpConverters.toBytes("+inf"));
        Object[] params = limit != null ? this.limitParams(limit.getOffset(), limit.getCount()) : EMPTY_PARAMS_ARRAY;
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.zrangebyscore((Object)key, (Object)min, (Object)max, (Object)WITHSCORES, params), SrpConverters.repliesToTupleSet()));
                return null;
            }
            return SrpConverters.toTupleSet(this.client.zrangebyscore((Object)key, (Object)min, (Object)max, (Object)WITHSCORES, params).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.zrevrange((Object)key, (Object)start, (Object)end, (Object)WITHSCORES), SrpConverters.repliesToTupleSet()));
                return null;
            }
            return SrpConverters.toTupleSet(this.client.zrevrange((Object)key, (Object)start, (Object)end, (Object)WITHSCORES).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.zRangeByScore(key, new RedisZSetCommands.Range().gte(min).lte(max), new RedisZSetCommands.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.zRangeByScoreWithScores(key, new RedisZSetCommands.Range().gte(min).lte(max), new RedisZSetCommands.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.zRevRangeByScore(key, new RedisZSetCommands.Range().gte(min).lte(max), new RedisZSetCommands.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        return this.zRevRangeByScore(key, new RedisZSetCommands.Range().gte(min).lte(max));
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.zRevRangeByScoreWithScores(key, new RedisZSetCommands.Range().gte(min).lte(max), new RedisZSetCommands.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.zRevRangeByScoreWithScores(key, new RedisZSetCommands.Range().gte(min).lte(max));
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return this.zRevRangeByScore(key, range, null);
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYSCOREWITHSCORES must not be null!");
        byte[] min = SrpConverters.boundaryToBytesForZRange(range.getMin(), SrpConverters.toBytes("-inf"));
        byte[] max = SrpConverters.boundaryToBytesForZRange(range.getMax(), SrpConverters.toBytes("+inf"));
        Object[] params = limit != null ? this.limitParams(limit.getOffset(), limit.getCount()) : EMPTY_PARAMS_ARRAY;
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.zrevrangebyscore((Object)key, (Object)max, (Object)min, null, params), SrpConverters.repliesToBytesSet()));
                return null;
            }
            return SrpConverters.toBytesSet(this.client.zrevrangebyscore((Object)key, (Object)max, (Object)min, null, params).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        return this.zRevRangeByScoreWithScores(key, range, null);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYSCOREWITHSCORES must not be null!");
        byte[] min = SrpConverters.boundaryToBytesForZRange(range.getMin(), SrpConverters.toBytes("-inf"));
        byte[] max = SrpConverters.boundaryToBytesForZRange(range.getMax(), SrpConverters.toBytes("+inf"));
        Object[] params = limit != null ? this.limitParams(limit.getOffset(), limit.getCount()) : EMPTY_PARAMS_ARRAY;
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.zrevrangebyscore((Object)key, (Object)max, (Object)min, (Object)WITHSCORES, params), SrpConverters.repliesToTupleSet()));
                return null;
            }
            return SrpConverters.toTupleSet(this.client.zrevrangebyscore((Object)key, (Object)max, (Object)min, (Object)WITHSCORES, params).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.zrank((Object)key, (Object)value)));
                return null;
            }
            return (Long)this.client.zrank((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.zrem((Object)key, (Object[])values)));
                return null;
            }
            return this.client.zrem((Object)key, (Object[])values).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.zremrangebyrank((Object)key, (Object)start, (Object)end)));
                return null;
            }
            return this.client.zremrangebyrank((Object)key, (Object)start, (Object)end).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        return this.zRemRangeByScore(key, new RedisZSetCommands.Range().gte(min).lte(max));
    }

    @Override
    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        byte[] min = SrpConverters.boundaryToBytesForZRange(range.getMin(), SrpConverters.toBytes("-inf"));
        byte[] max = SrpConverters.boundaryToBytesForZRange(range.getMax(), SrpConverters.toBytes("+inf"));
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.zremrangebyscore((Object)key, (Object)min, (Object)max)));
                return null;
            }
            return this.client.zremrangebyscore((Object)key, (Object)min, (Object)max).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.zrevrange((Object)key, (Object)start, (Object)end, null), SrpConverters.repliesToBytesSet()));
                return null;
            }
            return SrpConverters.toBytesSet(this.client.zrevrange((Object)key, (Object)start, (Object)end, null).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.zrevrank((Object)key, (Object)value)));
                return null;
            }
            return (Long)this.client.zrevrank((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.zscore((Object)key, (Object)value), SrpConverters.bytesToDouble()));
                return null;
            }
            return SrpConverters.toDouble(this.client.zscore((Object)key, (Object)value).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.zunionstore((Object)destKey, (Object)sets.length, (Object[])sets)));
                return null;
            }
            return this.client.zunionstore((Object)destKey, (Object)sets.length, (Object[])sets).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.hset((Object)key, (Object)field, (Object)value), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.hset((Object)key, (Object)field, (Object)value).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.hsetnx((Object)key, (Object)field, (Object)value), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.hsetnx((Object)key, (Object)field, (Object)value).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.hdel((Object)key, (Object[])fields)));
                return null;
            }
            return this.client.hdel((Object)key, (Object[])fields).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.hexists((Object)key, (Object)field), SrpConverters.longToBoolean()));
                return null;
            }
            return SrpConverters.toBoolean(this.client.hexists((Object)key, (Object)field).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.hget((Object)key, (Object)field)));
                return null;
            }
            return this.client.hget((Object)key, (Object)field).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.hgetall((Object)key), SrpConverters.repliesToBytesMap()));
                return null;
            }
            return SrpConverters.toBytesMap(this.client.hgetall((Object)key).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.hincrby((Object)key, (Object)field, (Object)delta)));
                return null;
            }
            return this.client.hincrby((Object)key, (Object)field, (Object)delta).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.hincrbyfloat((Object)key, (Object)field, (Object)delta), SrpConverters.bytesToDouble()));
                return null;
            }
            return SrpConverters.toDouble(this.client.hincrbyfloat((Object)key, (Object)field, (Object)delta).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.hkeys((Object)key), SrpConverters.repliesToBytesSet()));
                return null;
            }
            return SrpConverters.toBytesSet(this.client.hkeys((Object)key).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.hlen((Object)key)));
                return null;
            }
            return this.client.hlen((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.hmget((Object)key, (Object[])fields), SrpConverters.repliesToBytesList()));
                return null;
            }
            return SrpConverters.toBytesList(this.client.hmget((Object)key, (Object[])fields).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> tuple) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.hmset((Object)key, (Object[])SrpConverters.toByteArrays(tuple))));
                return;
            }
            this.client.hmset((Object)key, (Object[])SrpConverters.toByteArrays(tuple));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.hvals((Object)key), SrpConverters.repliesToBytesList()));
                return null;
            }
            return SrpConverters.toBytesList(this.client.hvals((Object)key).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void scriptFlush() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.script_flush()));
                return;
            }
            this.client.script_flush();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void scriptKill() {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException("Script kill not permitted in a transaction");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.script_kill()));
                return;
            }
            this.client.script_kill();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public String scriptLoad(byte[] script) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpGenericResult((ListenableFuture<? extends Reply>)this.pipeline.script_load((Object)script), SrpConverters.bytesToString()));
                return null;
            }
            return SrpConverters.toString((byte[])this.client.script_load((Object)script).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<Boolean> scriptExists(String ... scriptSha1) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpGenericResult((ListenableFuture<? extends Reply>)this.pipeline.script_exists((Object[])scriptSha1), SrpConverters.repliesToBooleanList()));
                return null;
            }
            return SrpConverters.toBooleanList(((MultiBulkReply)this.client.script_exists_((Object[])scriptSha1)).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpGenericResult((ListenableFuture<? extends Reply>)this.pipeline.eval((Object)script, (Object)numKeys, (Object[])keysAndArgs), new SrpScriptReturnConverter(returnType)));
                return null;
            }
            return (T)new SrpScriptReturnConverter(returnType).convert(this.client.eval((Object)script, (Object)numKeys, (Object[])keysAndArgs).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public <T> T evalSha(String scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpGenericResult((ListenableFuture<? extends Reply>)this.pipeline.evalsha((Object)scriptSha1, (Object)numKeys, (Object[])keysAndArgs), new SrpScriptReturnConverter(returnType)));
                return null;
            }
            return (T)new SrpScriptReturnConverter(returnType).convert(this.client.evalsha((Object)scriptSha1, (Object)numKeys, (Object[])keysAndArgs).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public <T> T evalSha(byte[] scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return this.evalSha(SrpConverters.toString(scriptSha1), returnType, numKeys, keysAndArgs);
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpResult((ListenableFuture<? extends Reply>)this.pipeline.publish((Object)channel, (Object)message)));
                return null;
            }
            return this.client.publish((Object)channel, (Object)message).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.checkSubscription();
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            this.subscription = new SrpSubscription(listener, this.client);
            this.subscription.pSubscribe(patterns);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.checkSubscription();
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            this.subscription = new SrpSubscription(listener, this.client);
            this.subscription.subscribe(channels);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    private void checkSubscription() {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
    }

    private void doPipelined(ListenableFuture<Reply> listenableFuture) {
        this.pipeline(new SrpStatusResult(listenableFuture));
    }

    private void pipeline(FutureResult<?> future) {
        if (this.isQueueing()) {
            this.txTracker.addCommand(future);
        } else {
            this.callback.addCommand(future);
        }
    }

    private void initPipeline() {
        if (this.pipeline == null) {
            this.callback = new PipelineTracker(this.convertPipelineAndTxResults);
            this.pipeline = this.client.pipeline();
        }
    }

    private void initTxTracker() {
        if (this.txTracker == null) {
            this.txTracker = new PipelineTracker(this.convertPipelineAndTxResults);
        }
        this.initPipeline();
    }

    @Override
    public List<Object> closePipeline() {
        this.pipelineRequested = false;
        List<Object> results = Collections.emptyList();
        if (this.pipeline != null) {
            this.pipeline = null;
            results = this.getPipelinedResults(this.callback, true);
            this.callback.close();
            this.callback = null;
        }
        return results;
    }

    @Override
    public Long time() {
        if (this.isPipelined()) {
            this.pipeline(new SrpGenericResult((ListenableFuture<? extends Reply>)this.pipeline.time(), SrpConverters.repliesToTimeAsLong()));
            return null;
        }
        MultiBulkReply reply = this.client.time();
        Assert.notNull((Object)reply, (String)"Received invalid result from server. MultiBulkReply must not be empty.");
        return SrpConverters.toTimeAsLong(reply.data());
    }

    @Override
    public void killClient(String host, int port) {
        Assert.hasText((String)host, (String)"Host for 'CLIENT KILL' must not be 'null' or 'empty'.");
        String client = String.format("%s:%s", host, port);
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.client_kill((Object)client)));
                return;
            }
            this.client.client_kill((Object)client);
        }
        catch (Exception e) {
            throw this.convertSrpAccessException(e);
        }
    }

    @Override
    public void setClientName(byte[] name) {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.client_setname((Object)name)));
                return;
            }
            this.client.client_setname((Object)name);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void slaveOf(String host, int port) {
        Assert.hasText((String)host, (String)"Host must not be null for 'SLAVEOF' command.");
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.slaveof((Object)host, (Object)port)));
                return;
            }
            this.client.slaveof((Object)host, (Object)port);
        }
        catch (Exception e) {
            throw this.convertSrpAccessException(e);
        }
    }

    @Override
    public String getClientName() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpGenericResult((ListenableFuture<? extends Reply>)this.pipeline.client_getname(), SrpConverters.replyToString()));
                return null;
            }
            return SrpConverters.toString(this.client.client_getname());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            this.pipeline(new SrpGenericResult((ListenableFuture<? extends Reply>)this.pipeline.client_list(), SrpConverters.replyToListOfRedisClientInfo()));
            return null;
        }
        return SrpConverters.toListOfRedisClientInformation(this.client.client_list());
    }

    @Override
    public void slaveOfNoOne() {
        try {
            if (this.isPipelined()) {
                this.pipeline(new SrpStatusResult((ListenableFuture<? extends Reply>)this.pipeline.slaveof((Object)"NO", (Object)"ONE")));
                return;
            }
            this.client.slaveof((Object)"NO", (Object)"ONE");
        }
        catch (Exception e) {
            throw this.convertSrpAccessException(e);
        }
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        throw new UnsupportedOperationException("'SCAN' command is not supported for Srp.");
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        throw new UnsupportedOperationException("'ZSCAN' command is not supported for Srp.");
    }

    @Override
    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        throw new UnsupportedOperationException("'SSCAN' command is not supported for Srp.");
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        throw new UnsupportedOperationException("'HSCAN' command is not supported for Srp.");
    }

    private List<Object> closeTransaction() {
        List<Object> results = Collections.emptyList();
        if (this.txTracker != null) {
            results = this.getPipelinedResults(this.txTracker, false);
            this.txTracker.close();
            this.txTracker = null;
        }
        return results;
    }

    private List<Object> getPipelinedResults(PipelineTracker tracker, boolean throwPipelineException) {
        ArrayList<Object> execute = new ArrayList<Object>(tracker.complete());
        if (execute != null && !execute.isEmpty()) {
            DataAccessException cause = null;
            for (int i = 0; i < execute.size(); ++i) {
                Object object = execute.get(i);
                if (!(object instanceof Exception)) continue;
                DataAccessException dataAccessException = this.convertSrpAccessException((Exception)object);
                if (cause == null) {
                    cause = dataAccessException;
                }
                execute.set(i, (Object)dataAccessException);
            }
            if (cause != null) {
                if (throwPipelineException) {
                    throw new RedisPipelineException((Exception)((Object)cause), (List<Object>)execute);
                }
                throw this.convertSrpAccessException((Exception)((Object)cause));
            }
            return execute;
        }
        return Collections.emptyList();
    }

    private Object[] popArgs(int timeout, byte[] ... keys) {
        int length = keys != null ? keys.length + 1 : 1;
        Object[] args = new Object[length];
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                args[i] = keys[i];
            }
        }
        args[length - 1] = String.valueOf(timeout).getBytes();
        return args;
    }

    private Object[] limitParams(long offset, long count) {
        return new Object[]{"LIMIT".getBytes(Charsets.UTF_8), String.valueOf(offset).getBytes(Charsets.UTF_8), String.valueOf(count).getBytes(Charsets.UTF_8)};
    }

    private byte[] limit(long offset, long count) {
        return ("LIMIT " + offset + " " + count).getBytes(Charsets.UTF_8);
    }

    private Object[] sortParams(SortParameters params) {
        return this.sortParams(params, null);
    }

    private Object[] sortParams(SortParameters params, byte[] sortKey) {
        ArrayList<byte[]> arrays = new ArrayList<byte[]>();
        if (params != null) {
            Boolean isAlpha;
            if (params.getByPattern() != null) {
                arrays.add(BY);
                arrays.add(params.getByPattern());
            }
            if (params.getLimit() != null) {
                arrays.add(this.limit(params.getLimit().getStart(), params.getLimit().getCount()));
            }
            if (params.getGetPattern() != null) {
                byte[][] pattern;
                for (byte[] bs : pattern = params.getGetPattern()) {
                    arrays.add(GET);
                    arrays.add(bs);
                }
            }
            if (params.getOrder() != null) {
                arrays.add(params.getOrder().name().getBytes(Charsets.UTF_8));
            }
            if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
                arrays.add(ALPHA);
            }
        }
        if (sortKey != null) {
            arrays.add(STORE);
            arrays.add(sortKey);
        }
        return arrays.toArray();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        try {
            String keyStr = new String(key, "UTF-8");
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.zrangebyscore((Object)keyStr, (Object)min, (Object)max, null, EMPTY_PARAMS_ARRAY), SrpConverters.repliesToBytesSet()));
                return null;
            }
            return SrpConverters.toBytesSet(this.client.zrangebyscore((Object)keyStr, (Object)min, (Object)max, null, EMPTY_PARAMS_ARRAY).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        try {
            String keyStr = new String(key, "UTF-8");
            Object[] limit = this.limitParams(offset, count);
            if (this.isPipelined()) {
                this.pipeline(new SrpResult(this.pipeline.zrangebyscore((Object)keyStr, (Object)min, (Object)max, null, limit), SrpConverters.repliesToBytesSet()));
                return null;
            }
            return SrpConverters.toBytesSet(this.client.zrangebyscore((Object)keyStr, (Object)min, (Object)max, null, limit).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long pfAdd(byte[] key, byte[] ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long pfCount(byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key) {
        throw new UnsupportedOperationException("ZRANGEBYLEX is no supported for srp.");
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range) {
        throw new UnsupportedOperationException("ZRANGEBYLEX is no supported for srp.");
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        throw new UnsupportedOperationException("ZRANGEBYLEX is no supported for srp.");
    }

    private class SrpTxResult
    extends FutureResult<PipelineTracker> {
        public SrpTxResult(PipelineTracker txTracker) {
            super(txTracker);
        }

        @Override
        public List<Object> get() {
            if (this.resultHolder == null) {
                return null;
            }
            return ((PipelineTracker)this.resultHolder).complete();
        }
    }

    private class SrpStatusResult
    extends SrpResult {
        public SrpStatusResult(ListenableFuture<? extends Reply> resultHolder) {
            super(resultHolder);
            this.setStatus(true);
        }
    }

    private class SrpResult
    extends SrpGenericResult {
        public <T> SrpResult(ListenableFuture<? extends Reply<T>> resultHolder, Converter<T, ?> converter) {
            super(resultHolder, converter);
        }

        public SrpResult(ListenableFuture<? extends Reply> resultHolder) {
            super(resultHolder);
        }
    }

    private class SrpGenericResult
    extends FutureResult<ListenableFuture<? extends Reply>> {
        public SrpGenericResult(ListenableFuture<? extends Reply> resultHolder, Converter converter) {
            super(resultHolder, converter);
        }

        public SrpGenericResult(ListenableFuture<? extends Reply> resultHolder) {
            super(resultHolder);
        }

        @Override
        public Object get() {
            throw new UnsupportedOperationException();
        }
    }

    private class PipelineTracker
    implements FutureCallback<Reply> {
        private final List<Object> results = Collections.synchronizedList(new ArrayList());
        private final Queue<FutureResult> futureResults = new LinkedList<FutureResult>();
        private boolean convertResults;

        public PipelineTracker(boolean convertResults) {
            this.convertResults = convertResults;
        }

        public void onSuccess(Reply result) {
            this.results.add(result.data());
        }

        public void onFailure(Throwable t) {
            this.results.add(t);
        }

        public List<Object> complete() {
            int txResults = 0;
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
            for (FutureResult future : this.futureResults) {
                if (future instanceof SrpTxResult) {
                    ++txResults;
                    continue;
                }
                ListenableFuture f = (ListenableFuture)future.getResultHolder();
                futures.add(f);
            }
            try {
                Futures.successfulAsList(futures).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.futureResults.size() != this.results.size() + txResults) {
                throw new RedisPipelineException("Received a different number of results than expected. Expected: " + this.futureResults.size(), this.results);
            }
            ArrayList<Object> convertedResults = new ArrayList<Object>();
            int i = 0;
            for (FutureResult future : this.futureResults) {
                if (future instanceof SrpTxResult) {
                    PipelineTracker txTracker = (PipelineTracker)((SrpTxResult)future).getResultHolder();
                    if (txTracker != null) {
                        convertedResults.add(SrpConnection.this.getPipelinedResults(txTracker, true));
                        continue;
                    }
                    convertedResults.add(null);
                    continue;
                }
                Object result = this.results.get(i);
                if (result instanceof Exception || !this.convertResults) {
                    convertedResults.add(result);
                } else if (!future.isStatus()) {
                    convertedResults.add(future.convert(result));
                }
                ++i;
            }
            return convertedResults;
        }

        public void addCommand(FutureResult result) {
            this.futureResults.add(result);
            if (!(result instanceof SrpTxResult) && result.getResultHolder() != null) {
                Futures.addCallback((ListenableFuture)((ListenableFuture)((SrpGenericResult)result).getResultHolder()), (FutureCallback)this);
            }
        }

        public void close() {
            this.results.clear();
            this.futureResults.clear();
        }
    }
}

