/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.redis.core.convert.IndexResolver;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.data.redis.core.convert.SimpleIndexedPropertyValue;
import org.springframework.data.redis.core.index.ConfigurableIndexDefinitionProvider;
import org.springframework.data.redis.core.index.IndexDefinition;
import org.springframework.data.redis.core.index.Indexed;
import org.springframework.data.redis.core.index.SimpleIndexDefinition;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class PathIndexResolver
implements IndexResolver {
    private ConfigurableIndexDefinitionProvider indexConfiguration;
    private RedisMappingContext mappingContext;

    public PathIndexResolver() {
        this(new RedisMappingContext());
    }

    public PathIndexResolver(RedisMappingContext mappingContext) {
        Assert.notNull((Object)((Object)mappingContext), (String)"MappingContext must not be null!");
        this.mappingContext = mappingContext;
        this.indexConfiguration = mappingContext.getMappingConfiguration().getIndexConfiguration();
    }

    @Override
    public Set<IndexedData> resolveIndexesFor(TypeInformation<?> typeInformation, Object value) {
        return this.doResolveIndexesFor(this.mappingContext.getPersistentEntity(typeInformation).getKeySpace(), "", typeInformation, null, value);
    }

    private Set<IndexedData> doResolveIndexesFor(final String keyspace, final String path, TypeInformation<?> typeInformation, PersistentProperty<?> fallback, Object value) {
        RedisPersistentEntity<?> entity = this.mappingContext.getPersistentEntity(typeInformation);
        if (entity == null) {
            return this.resolveIndex(keyspace, path, fallback, value);
        }
        final PersistentPropertyAccessor accessor = entity.getPropertyAccessor(value);
        final LinkedHashSet<IndexedData> indexes = new LinkedHashSet<IndexedData>();
        entity.doWithProperties((PropertyHandler)new PropertyHandler<KeyValuePersistentProperty>(){

            public void doWithPersistentProperty(KeyValuePersistentProperty persistentProperty) {
                String currentPath = !path.isEmpty() ? path + "." + persistentProperty.getName() : persistentProperty.getName();
                Object propertyValue = accessor.getProperty((PersistentProperty)persistentProperty);
                if (propertyValue != null) {
                    TypeInformation<?> typeHint;
                    Object object = typeHint = persistentProperty.isMap() ? persistentProperty.getTypeInformation().getMapValueType() : persistentProperty.getTypeInformation().getActualType();
                    if (persistentProperty.isMap()) {
                        for (Map.Entry entry : ((Map)propertyValue).entrySet()) {
                            TypeInformation<?> typeToUse = this.updateTypeHintForActualValue(typeHint, entry.getValue());
                            indexes.addAll(PathIndexResolver.this.doResolveIndexesFor(keyspace, currentPath + "." + entry.getKey(), typeToUse.getActualType(), (PersistentProperty)persistentProperty, entry.getValue()));
                        }
                    } else if (persistentProperty.isCollectionLike()) {
                        Iterable iterable;
                        if (Iterable.class.isAssignableFrom(propertyValue.getClass())) {
                            iterable = (Iterable)propertyValue;
                        } else if (propertyValue.getClass().isArray()) {
                            iterable = CollectionUtils.arrayToList((Object)propertyValue);
                        } else {
                            throw new RuntimeException("Don't know how to handle " + propertyValue.getClass() + " type of collection");
                        }
                        for (Object listValue : iterable) {
                            if (listValue == null) continue;
                            TypeInformation<?> typeToUse = this.updateTypeHintForActualValue(typeHint, listValue);
                            indexes.addAll(PathIndexResolver.this.doResolveIndexesFor(keyspace, currentPath, typeToUse.getActualType(), (PersistentProperty)persistentProperty, listValue));
                        }
                    } else if (persistentProperty.isEntity() || persistentProperty.getTypeInformation().getActualType().equals(ClassTypeInformation.OBJECT)) {
                        typeHint = this.updateTypeHintForActualValue(typeHint, propertyValue);
                        indexes.addAll(PathIndexResolver.this.doResolveIndexesFor(keyspace, currentPath, typeHint.getActualType(), (PersistentProperty)persistentProperty, propertyValue));
                    } else {
                        indexes.addAll(PathIndexResolver.this.resolveIndex(keyspace, currentPath, (PersistentProperty<?>)persistentProperty, propertyValue));
                    }
                }
            }

            private TypeInformation<?> updateTypeHintForActualValue(TypeInformation<?> typeHint, Object propertyValue) {
                if (typeHint.equals(ClassTypeInformation.OBJECT) || typeHint.getClass().isInterface()) {
                    try {
                        typeHint = PathIndexResolver.this.mappingContext.getPersistentEntity(propertyValue.getClass()).getTypeInformation();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return typeHint;
            }
        });
        return indexes;
    }

    protected Set<IndexedData> resolveIndex(String keyspace, String propertyPath, PersistentProperty<?> property, Object value) {
        if (value == null) {
            return Collections.emptySet();
        }
        String path = this.normalizeIndexPath(propertyPath, property);
        LinkedHashSet<IndexedData> data = new LinkedHashSet<IndexedData>();
        if (this.indexConfiguration.hasIndexFor((Serializable)((Object)keyspace), path)) {
            IndexDefinition.IndexingContext context = new IndexDefinition.IndexingContext(keyspace, path, (TypeInformation<?>)(property != null ? property.getTypeInformation() : ClassTypeInformation.OBJECT));
            for (IndexDefinition indexDefinition : this.indexConfiguration.getIndexDefinitionsFor((Serializable)((Object)keyspace), path)) {
                if (!this.verifyConditions(indexDefinition.getConditions(), value, context)) continue;
                data.add(new SimpleIndexedPropertyValue(keyspace, indexDefinition.getIndexName(), indexDefinition.valueTransformer().convert(value)));
            }
        } else if (property != null && property.isAnnotationPresent(Indexed.class)) {
            SimpleIndexDefinition indexDefinition = new SimpleIndexDefinition(keyspace, path);
            this.indexConfiguration.addIndexDefinition(indexDefinition);
            data.add(new SimpleIndexedPropertyValue(keyspace, path, indexDefinition.valueTransformer().convert(value)));
        }
        return data;
    }

    private boolean verifyConditions(Iterable<IndexDefinition.Condition<?>> conditions, Object value, IndexDefinition.IndexingContext context) {
        for (IndexDefinition.Condition<?> condition : conditions) {
            if (condition.matches(value, context)) continue;
            return false;
        }
        return true;
    }

    private String normalizeIndexPath(String path, PersistentProperty<?> property) {
        if (property == null) {
            return path;
        }
        if (property.isMap()) {
            return path.replaceAll("\\[", "").replaceAll("\\]", "");
        }
        if (property.isCollectionLike()) {
            return path.replaceAll("\\[(\\p{Digit})*\\]", "").replaceAll("\\.\\.", ".");
        }
        return path;
    }
}

