/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.Interpreter;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class AggregateChange<T> {
    private final Kind kind;
    private final Class<T> entityType;
    private final List<DbAction<?>> actions = new ArrayList();
    @Nullable
    private T entity;

    public AggregateChange(Kind kind, Class<T> entityType, @Nullable T entity) {
        this.kind = kind;
        this.entityType = entityType;
        this.entity = entity;
    }

    public static <T> AggregateChange<T> forSave(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        return new AggregateChange<T>(Kind.SAVE, ClassUtils.getUserClass(entity), entity);
    }

    public static <T> AggregateChange<T> forDelete(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        return AggregateChange.forDelete(ClassUtils.getUserClass(entity), entity);
    }

    public static <T> AggregateChange<T> forDelete(Class<T> entityClass, @Nullable T entity) {
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        return new AggregateChange<T>(Kind.DELETE, entityClass, entity);
    }

    public void setEntity(@Nullable T aggregateRoot) {
        this.entity = aggregateRoot;
    }

    public void executeWith(Interpreter interpreter, RelationalMappingContext context, RelationalConverter converter) {
        this.actions.forEach(action -> action.executeWith(interpreter));
        T newRoot = this.populateIdsIfNecessary(context, converter);
        if (newRoot != null) {
            this.entity = newRoot;
        }
    }

    @Nullable
    private T populateIdsIfNecessary(RelationalMappingContext context, RelationalConverter converter) {
        T newRoot = null;
        ArrayList reverseActions = new ArrayList(this.actions);
        Collections.reverse(reverseActions);
        StagedValues cascadingValues = new StagedValues();
        for (DbAction<?> action : reverseActions) {
            Object generatedId;
            DbAction.WithGeneratedId withGeneratedId;
            Object newEntity;
            if (!(action instanceof DbAction.WithGeneratedId) || (newEntity = this.setIdAndCascadingProperties(context, converter, withGeneratedId = (DbAction.WithGeneratedId)action, generatedId = withGeneratedId.getGeneratedId(), cascadingValues)) == ((DbAction.WithGeneratedId)action).getEntity()) continue;
            if (action instanceof DbAction.Insert) {
                DbAction.Insert insert = (DbAction.Insert)action;
                Pair<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifier = insert.getQualifier();
                cascadingValues.stage(insert.dependingOn, insert.propertyPath, qualifier == null ? null : qualifier.getSecond(), newEntity);
                continue;
            }
            if (!(action instanceof DbAction.InsertRoot)) continue;
            newRoot = this.entityType.cast(newEntity);
        }
        return newRoot;
    }

    private <S> Object setIdAndCascadingProperties(RelationalMappingContext context, RelationalConverter converter, DbAction.WithGeneratedId<S> action, @Nullable Object generatedId, StagedValues cascadingValues) {
        Object originalEntity = action.getEntity();
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)context.getRequiredPersistentEntity(action.getEntityType());
        PersistentPropertyAccessor propertyAccessor = converter.getPropertyAccessor(persistentEntity, originalEntity);
        if (generatedId != null) {
            propertyAccessor.setProperty(persistentEntity.getRequiredIdProperty(), generatedId);
        }
        cascadingValues.forEachPath(action, (persistentPropertyPath, o) -> propertyAccessor.setProperty(this.getRelativePath(action, (PersistentPropertyPath)persistentPropertyPath), o));
        return propertyAccessor.getBean();
    }

    private PersistentPropertyPath getRelativePath(DbAction action, PersistentPropertyPath pathToValue) {
        if (action instanceof DbAction.Insert) {
            return pathToValue.getExtensionForBaseOf(((DbAction.Insert)action).propertyPath);
        }
        if (action instanceof DbAction.InsertRoot) {
            return pathToValue;
        }
        throw new IllegalArgumentException(String.format("DbAction of type %s is not supported.", action.getClass()));
    }

    public void addAction(DbAction<?> action) {
        this.actions.add(action);
    }

    public Kind getKind() {
        return this.kind;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    public List<DbAction<?>> getActions() {
        return this.actions;
    }

    @Nullable
    public T getEntity() {
        return this.entity;
    }

    private static enum SingleElementAggregator implements MultiValueAggregator<Object>
    {
        INSTANCE;


        @Override
        @Nullable
        public Object createEmptyInstance() {
            return null;
        }

        @Override
        public Object add(@Nullable Object __null, @Nullable Object qualifier, Object value) {
            return value;
        }
    }

    private static enum MapAggregator implements MultiValueAggregator<Map>
    {
        INSTANCE;


        @Override
        public Class<Map> handledType() {
            return Map.class;
        }

        @Override
        public Map createEmptyInstance() {
            return new HashMap();
        }

        @Override
        public Map add(@Nullable Map map, @Nullable Object qualifier, Object value) {
            Assert.notNull((Object)map, (String)"Map must not be null.");
            map.put(qualifier, value);
            return map;
        }
    }

    private static enum ListAggregator implements MultiValueAggregator<List>
    {
        INSTANCE;


        @Override
        public boolean handles(PersistentProperty property) {
            return property.isCollectionLike();
        }

        @Override
        public List createEmptyInstance() {
            return new ArrayList();
        }

        @Override
        public List add(@Nullable List list, @Nullable Object qualifier, Object value) {
            Assert.notNull((Object)list, (String)"List must not be null.");
            int index = (Integer)qualifier;
            if (index >= list.size()) {
                list.add(value);
            } else {
                list.add(index, value);
            }
            return list;
        }
    }

    private static enum SetAggregator implements MultiValueAggregator<Set>
    {
        INSTANCE;


        @Override
        public Class<Set> handledType() {
            return Set.class;
        }

        @Override
        public Set createEmptyInstance() {
            return new HashSet();
        }

        @Override
        public Set add(@Nullable Set set, @Nullable Object qualifier, Object value) {
            Assert.notNull((Object)set, (String)"Set must not be null");
            set.add(value);
            return set;
        }
    }

    static interface MultiValueAggregator<T> {
        default public Class<? super T> handledType() {
            return Object.class;
        }

        default public boolean handles(PersistentProperty property) {
            return this.handledType().isAssignableFrom(property.getType());
        }

        @Nullable
        public T createEmptyInstance();

        public T add(@Nullable T var1, @Nullable Object var2, Object var3);
    }

    private static class StagedValues {
        static final List<MultiValueAggregator> aggregators = Arrays.asList(SetAggregator.INSTANCE, MapAggregator.INSTANCE, ListAggregator.INSTANCE, SingleElementAggregator.INSTANCE);
        Map<DbAction, Map<PersistentPropertyPath, Object>> values = new HashMap<DbAction, Map<PersistentPropertyPath, Object>>();

        private StagedValues() {
        }

        <T> void stage(DbAction<?> action, PersistentPropertyPath path, @Nullable Object qualifier, Object value) {
            MultiValueAggregator aggregator = this.getAggregatorFor(path);
            Map valuesForPath = this.values.computeIfAbsent(action, dbAction -> new HashMap());
            Object currentValue = valuesForPath.computeIfAbsent(path, persistentPropertyPath -> aggregator.createEmptyInstance());
            Object newValue = aggregator.add(currentValue, qualifier, value);
            valuesForPath.put(path, newValue);
        }

        private MultiValueAggregator getAggregatorFor(PersistentPropertyPath path) {
            PersistentProperty property = path.getRequiredLeafProperty();
            for (MultiValueAggregator aggregator : aggregators) {
                if (!aggregator.handles(property)) continue;
                return aggregator;
            }
            throw new IllegalStateException(String.format("Can't handle path %s", path));
        }

        void forEachPath(DbAction<?> dbAction, BiConsumer<PersistentPropertyPath, Object> action) {
            this.values.getOrDefault(dbAction, Collections.emptyMap()).forEach(action);
        }
    }

    public static enum Kind {
        SAVE,
        DELETE;

    }
}

