/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.rest.core.annotation.RestResource;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.data.rest.core.mapping.SupportedHttpMethods;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

public class CrudMethodsSupportedHttpMethods
implements SupportedHttpMethods {
    private final ExposureAwareCrudMethods exposedMethods;

    public CrudMethodsSupportedHttpMethods(CrudMethods crudMethods, boolean methodsExposedByDefault) {
        Assert.notNull((Object)crudMethods, (String)"CrudMethods must not be null!");
        this.exposedMethods = new DefaultExposureAwareCrudMethods(crudMethods, methodsExposedByDefault);
    }

    @Override
    public Set<HttpMethod> getMethodsFor(ResourceType resourceType) {
        Assert.notNull((Object)((Object)resourceType), (String)"Resource type must not be null!");
        HashSet<HttpMethod> methods = new HashSet<HttpMethod>();
        methods.add(HttpMethod.OPTIONS);
        switch (resourceType) {
            case COLLECTION: {
                if (this.exposedMethods.exposesFindAll()) {
                    methods.add(HttpMethod.GET);
                    methods.add(HttpMethod.HEAD);
                }
                if (!this.exposedMethods.exposesSave()) break;
                methods.add(HttpMethod.POST);
                break;
            }
            case ITEM: {
                if (this.exposedMethods.exposesDelete()) {
                    methods.add(HttpMethod.DELETE);
                }
                if (this.exposedMethods.exposesFindOne()) {
                    methods.add(HttpMethod.GET);
                    methods.add(HttpMethod.HEAD);
                }
                if (!this.exposedMethods.exposesSave()) break;
                methods.add(HttpMethod.PUT);
                methods.add(HttpMethod.PATCH);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported resource type %s!", new Object[]{resourceType}));
            }
        }
        return Collections.unmodifiableSet(methods);
    }

    @Override
    public Set<HttpMethod> getMethodsFor(PersistentProperty<?> property) {
        if (!property.isAssociation()) {
            return Collections.emptySet();
        }
        HashSet<HttpMethod> methods = new HashSet<HttpMethod>();
        methods.add(HttpMethod.GET);
        if (property.isWritable() && this.getMethodsFor(ResourceType.ITEM).contains(HttpMethod.PUT)) {
            methods.add(HttpMethod.PUT);
            methods.add(HttpMethod.PATCH);
            methods.add(HttpMethod.DELETE);
        }
        if (property.isCollectionLike() && property.isWritable()) {
            methods.add(HttpMethod.POST);
        }
        return methods;
    }

    static interface ExposureAwareCrudMethods {
        public boolean exposesSave();

        public boolean exposesDelete();

        public boolean exposesFindOne();

        public boolean exposesFindAll();
    }

    private static class DefaultExposureAwareCrudMethods
    implements ExposureAwareCrudMethods {
        @NonNull
        private final CrudMethods crudMethods;
        private final boolean exportedDefault;

        @Override
        public boolean exposesSave() {
            return this.exposes(this.crudMethods.getSaveMethod());
        }

        @Override
        public boolean exposesDelete() {
            return this.exposes(this.crudMethods.getDeleteMethod()) && this.crudMethods.hasFindOneMethod();
        }

        @Override
        public boolean exposesFindOne() {
            return this.exposes(this.crudMethods.getFindOneMethod());
        }

        @Override
        public boolean exposesFindAll() {
            return this.exposes(this.crudMethods.getFindAllMethod());
        }

        private boolean exposes(Method method) {
            if (method == null) {
                return false;
            }
            RestResource annotation = (RestResource)AnnotationUtils.findAnnotation((Method)method, RestResource.class);
            return annotation == null ? this.exportedDefault : annotation.exported();
        }

        public DefaultExposureAwareCrudMethods(@NonNull CrudMethods crudMethods, boolean exportedDefault) {
            if (crudMethods == null) {
                throw new IllegalArgumentException("crudMethods is null");
            }
            this.crudMethods = crudMethods;
            this.exportedDefault = exportedDefault;
        }
    }
}

