/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.plugin.core.OrderAwarePluginRegistry;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;

public class UnwrappingRepositoryInvokerFactory
implements RepositoryInvokerFactory {
    private static final List<Converter<Object, Object>> CONVERTERS;
    private final RepositoryInvokerFactory delegate;
    private final PluginRegistry<EntityLookup<?>, Class<?>> lookups;

    public UnwrappingRepositoryInvokerFactory(RepositoryInvokerFactory delegate, List<? extends EntityLookup<?>> lookups) {
        Assert.notNull((Object)delegate, (String)"Delegate RepositoryInvokerFactory must not be null!");
        Assert.notNull(lookups, (String)"EntityLookups must not be null!");
        this.delegate = delegate;
        this.lookups = OrderAwarePluginRegistry.create(lookups);
    }

    public RepositoryInvoker getInvokerFor(Class<?> domainType) {
        EntityLookup lookup = (EntityLookup)this.lookups.getPluginFor(domainType);
        return new UnwrappingRepositoryInvoker(this.delegate.getInvokerFor(domainType), CONVERTERS, lookup);
    }

    static {
        ArrayList<Object> converters = new ArrayList<Object>();
        ClassLoader classLoader = UnwrappingRepositoryInvokerFactory.class.getClassLoader();
        if (ClassUtils.isPresent((String)"java.util.Optional", (ClassLoader)classLoader)) {
            converters.add(new Converter<Object, Object>(){

                public Object convert(Object source) {
                    return source instanceof Optional ? ((Optional)source).orElse(null) : source;
                }
            });
        }
        if (ClassUtils.isPresent((String)"com.google.common.base.Optional", (ClassLoader)classLoader)) {
            converters.add(new Converter<Object, Object>(){

                public Object convert(Object source) {
                    return source instanceof com.google.common.base.Optional ? ((com.google.common.base.Optional)source).orNull() : source;
                }
            });
        }
        CONVERTERS = Collections.unmodifiableList(converters);
    }

    private static class UnwrappingRepositoryInvoker
    implements RepositoryInvoker {
        @NonNull
        private final RepositoryInvoker delegate;
        @NonNull
        private final Collection<Converter<Object, Object>> converters;
        private final EntityLookup<?> lookup;

        public <T> T invokeFindOne(Serializable id) {
            return this.postProcess(this.lookup != null ? this.lookup.lookupEntity(id) : this.delegate.invokeFindOne(id));
        }

        public Object invokeQueryMethod(Method method, Map<String, String[]> parameters, Pageable pageable, Sort sort) {
            return this.postProcess(this.delegate.invokeQueryMethod(method, parameters, pageable, sort));
        }

        public Object invokeQueryMethod(Method method, MultiValueMap<String, ? extends Object> parameters, Pageable pageable, Sort sort) {
            return this.postProcess(this.delegate.invokeQueryMethod(method, parameters, pageable, sort));
        }

        public boolean hasDeleteMethod() {
            return this.delegate.hasDeleteMethod();
        }

        public boolean hasFindAllMethod() {
            return this.delegate.hasFindAllMethod();
        }

        public boolean hasFindOneMethod() {
            return this.delegate.hasFindOneMethod();
        }

        public boolean hasSaveMethod() {
            return this.delegate.hasSaveMethod();
        }

        public void invokeDelete(Serializable id) {
            this.delegate.invokeDelete(id);
        }

        public Iterable<Object> invokeFindAll(Pageable pageable) {
            return this.delegate.invokeFindAll(pageable);
        }

        public Iterable<Object> invokeFindAll(Sort sort) {
            return this.delegate.invokeFindAll(sort);
        }

        public <T> T invokeSave(T object) {
            return (T)this.delegate.invokeSave(object);
        }

        private <T> T postProcess(Object result) {
            for (Converter<Object, Object> converter : this.converters) {
                result = converter.convert(result);
            }
            return (T)result;
        }

        public UnwrappingRepositoryInvoker(@NonNull RepositoryInvoker delegate, @NonNull Collection<Converter<Object, Object>> converters, EntityLookup<?> lookup) {
            if (delegate == null) {
                throw new IllegalArgumentException("delegate is null");
            }
            if (converters == null) {
                throw new IllegalArgumentException("converters is null");
            }
            this.delegate = delegate;
            this.converters = converters;
            this.lookup = lookup;
        }
    }
}

