/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.PersistentEntitiesResourceMappings;
import org.springframework.data.rest.core.mapping.RepositoryAwareResourceMetadata;
import org.springframework.data.rest.core.mapping.RepositoryCollectionResourceMapping;
import org.springframework.data.rest.core.mapping.RepositoryDetectionStrategy;
import org.springframework.data.rest.core.mapping.RepositoryMethodResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.hateoas.RelProvider;
import org.springframework.util.Assert;

public class RepositoryResourceMappings
extends PersistentEntitiesResourceMappings {
    private final Repositories repositories;
    private final RepositoryRestConfiguration configuration;
    private final Map<Class<?>, SearchResourceMappings> searchCache = new HashMap();

    public RepositoryResourceMappings(Repositories repositories, PersistentEntities entities, RepositoryRestConfiguration configuration) {
        super(entities);
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null!");
        this.repositories = repositories;
        this.configuration = configuration;
        this.populateCache(repositories, configuration);
    }

    private final void populateCache(Repositories repositories, RepositoryRestConfiguration configuration) {
        for (Class type : repositories) {
            RepositoryInformation repositoryInformation = repositories.getRequiredRepositoryInformation(type);
            Class repositoryInterface = repositoryInformation.getRepositoryInterface();
            PersistentEntity entity = repositories.getPersistentEntity(type);
            RepositoryDetectionStrategy strategy = configuration.getRepositoryDetectionStrategy();
            RelProvider provider = configuration.getRelProvider();
            RepositoryCollectionResourceMapping mapping = new RepositoryCollectionResourceMapping((RepositoryMetadata)repositoryInformation, strategy, provider);
            RepositoryAwareResourceMetadata information = new RepositoryAwareResourceMetadata(entity, mapping, this, (RepositoryMetadata)repositoryInformation);
            this.addToCache(repositoryInterface, information);
            if (this.hasMetadataFor(type) && !information.isPrimary()) continue;
            this.addToCache(type, information);
        }
    }

    @Override
    public SearchResourceMappings getSearchResourceMappings(Class<?> domainType) {
        Assert.notNull(domainType, (String)"Type must not be null!");
        if (this.searchCache.containsKey(domainType)) {
            return this.searchCache.get(domainType);
        }
        RepositoryInformation repositoryInformation = this.repositories.getRequiredRepositoryInformation(domainType);
        ArrayList<MethodResourceMapping> mappings = new ArrayList<MethodResourceMapping>();
        ResourceMetadata resourceMapping = this.getMetadataFor(domainType);
        if (resourceMapping.isExported()) {
            for (Method queryMethod : repositoryInformation.getQueryMethods()) {
                RepositoryMethodResourceMapping methodMapping = new RepositoryMethodResourceMapping(queryMethod, resourceMapping, (RepositoryMetadata)repositoryInformation, this.exposeMethodsByDefault());
                if (!methodMapping.isExported()) continue;
                mappings.add(methodMapping);
            }
        }
        SearchResourceMappings searchResourceMappings = new SearchResourceMappings(mappings);
        this.searchCache.put(domainType, searchResourceMappings);
        return searchResourceMappings;
    }

    @Override
    public boolean hasMappingFor(Class<?> type) {
        if (super.hasMappingFor(type)) {
            return true;
        }
        return this.repositories.hasRepositoryFor(type);
    }

    @Override
    public boolean isMapped(PersistentProperty<?> property) {
        return this.repositories.hasRepositoryFor(property.getActualType()) && super.isMapped(property);
    }

    public boolean exposeMethodsByDefault() {
        return this.configuration.exposeRepositoryMethodsByDefault();
    }
}

