/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.support;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.data.rest.core.util.Java8PluginRegistry;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public class UnwrappingRepositoryInvokerFactory
implements RepositoryInvokerFactory {
    private final RepositoryInvokerFactory delegate;
    private final Java8PluginRegistry<EntityLookup<?>, Class<?>> lookups;

    public UnwrappingRepositoryInvokerFactory(RepositoryInvokerFactory delegate, List<? extends EntityLookup<?>> lookups) {
        Assert.notNull((Object)delegate, (String)"Delegate RepositoryInvokerFactory must not be null!");
        Assert.notNull(lookups, (String)"EntityLookups must not be null!");
        this.delegate = delegate;
        this.lookups = Java8PluginRegistry.of(lookups);
    }

    public RepositoryInvoker getInvokerFor(Class<?> domainType) {
        Optional<EntityLookup<?>> lookup = this.lookups.getPluginFor(domainType);
        return new UnwrappingRepositoryInvoker(this.delegate.getInvokerFor(domainType), lookup);
    }

    private static class UnwrappingRepositoryInvoker
    implements RepositoryInvoker {
        @NonNull
        private final RepositoryInvoker delegate;
        @NonNull
        private final Optional<EntityLookup<?>> lookup;

        public <T> Optional<T> invokeFindById(Object id) {
            return this.lookup.isPresent() ? this.lookup.flatMap(it -> it.lookupEntity(id)) : this.delegate.invokeFindById(id);
        }

        public Optional<Object> invokeQueryMethod(Method method, MultiValueMap<String, ? extends Object> parameters, Pageable pageable, Sort sort) {
            return this.delegate.invokeQueryMethod(method, parameters, pageable, sort);
        }

        public boolean hasDeleteMethod() {
            return this.delegate.hasDeleteMethod();
        }

        public boolean hasFindAllMethod() {
            return this.delegate.hasFindAllMethod();
        }

        public boolean hasFindOneMethod() {
            return this.delegate.hasFindOneMethod();
        }

        public boolean hasSaveMethod() {
            return this.delegate.hasSaveMethod();
        }

        public void invokeDeleteById(Object id) {
            this.delegate.invokeDeleteById(id);
        }

        public Iterable<Object> invokeFindAll(Pageable pageable) {
            return this.delegate.invokeFindAll(pageable);
        }

        public Iterable<Object> invokeFindAll(Sort sort) {
            return this.delegate.invokeFindAll(sort);
        }

        public <T> T invokeSave(T object) {
            return (T)this.delegate.invokeSave(object);
        }

        public UnwrappingRepositoryInvoker(@NonNull RepositoryInvoker delegate, @NonNull Optional<EntityLookup<?>> lookup) {
            if (delegate == null) {
                throw new IllegalArgumentException("delegate is null");
            }
            if (lookup == null) {
                throw new IllegalArgumentException("lookup is null");
            }
            this.delegate = delegate;
            this.lookup = lookup;
        }
    }
}

