/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core;

import java.net.URI;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class UriToEntityConverter
implements GenericConverter {
    private static final Class<?> ASSOCIATION_TYPE = ReflectionUtils.loadIfPresent((String)"org.jmolecules.ddd.types.Association", (ClassLoader)UriToEntityConverter.class.getClassLoader());
    private final PersistentEntities entities;
    private final RepositoryInvokerFactory invokerFactory;
    private final Supplier<ConversionService> conversionService;
    private final Set<GenericConverter.ConvertiblePair> convertiblePairs;
    private final Set<Class<?>> identifierTypes;

    public UriToEntityConverter(PersistentEntities entities, RepositoryInvokerFactory invokerFactory, Supplier<ConversionService> conversionService) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null");
        Assert.notNull((Object)invokerFactory, (String)"RepositoryInvokerFactory must not be null");
        Assert.notNull(conversionService, (String)"ConversionService must not be null!");
        this.convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
        this.identifierTypes = new HashSet();
        for (TypeInformation domainType : entities.getManagedTypes()) {
            Class rawType = domainType.getType();
            Optional entity = entities.getPersistentEntity(rawType);
            entity.filter(it -> it.hasIdProperty()).ifPresent(it -> {
                this.convertiblePairs.add(new GenericConverter.ConvertiblePair(URI.class, domainType.getType()));
                this.registerIdentifierType(it.getRequiredIdProperty().getType());
            });
        }
        this.entities = entities;
        this.invokerFactory = invokerFactory;
        this.conversionService = conversionService;
        if (ASSOCIATION_TYPE != null) {
            this.registerIdentifierType(ASSOCIATION_TYPE);
        }
    }

    private void registerIdentifierType(Class<?> type) {
        this.convertiblePairs.add(new GenericConverter.ConvertiblePair(URI.class, type));
        this.identifierTypes.add(type);
    }

    @NonNull
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.convertiblePairs;
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        if (this.identifierTypes.contains(targetType.getType())) {
            String segment = UriToEntityConverter.getIdentifierSegment(source, sourceType, targetType);
            return this.conversionService.get().convert((Object)segment, TypeDescriptor.valueOf(String.class), targetType);
        }
        Optional entity = this.entities.getPersistentEntity(targetType.getType());
        if (entity.isEmpty()) {
            throw new ConversionFailedException(sourceType, targetType, source, (Throwable)new IllegalArgumentException("No PersistentEntity information available for " + targetType.getType()));
        }
        String segment = UriToEntityConverter.getIdentifierSegment(source, sourceType, targetType);
        return this.invokerFactory.getInvokerFor(targetType.getType()).invokeFindById((Object)segment).orElse(null);
    }

    private static String getIdentifierSegment(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        URI uri = (URI)source;
        String[] parts = uri.getPath().split("/");
        if (parts.length < 2) {
            throw new ConversionFailedException(sourceType, targetType, source, (Throwable)new IllegalArgumentException("Cannot resolve URI " + uri + "; Is it local or remote; Only local URIs are resolvable"));
        }
        return parts[parts.length - 1];
    }
}

