/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.EntityLookupRegistrar;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.data.util.MethodInvocationRecorder;
import org.springframework.data.util.StreamUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class EntityLookupConfiguration
implements EntityLookupRegistrar {
    private final List<LookupInformation<Object, Object, Repository<? extends Object, ?>>> lookupInformation = new ArrayList();
    private final List<Class<?>> lookupTypes = new ArrayList();

    EntityLookupConfiguration() {
    }

    @Override
    public <T, ID, R extends Repository<T, ?>> EntityLookupRegistrar forRepository(Class<R> repositoryType, Converter<T, ID> converter, EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> lookup) {
        new MappingBuilder(repositoryType).withIdMapping(converter).withLookup(lookup);
        return this;
    }

    @Override
    public <T, ID, R extends Repository<T, ?>> EntityLookupRegistrar.IdMappingRegistrar<T, R> forLookupRepository(Class<R> type) {
        this.lookupTypes.add(AbstractRepositoryMetadata.getMetadata(type).getDomainType());
        return this.forRepository(type);
    }

    @Override
    public <T, ID, R extends Repository<T, ?>> EntityLookupRegistrar.IdMappingRegistrar<T, R> forRepository(Class<R> type) {
        return new MappingBuilder(type);
    }

    @Override
    public <T, ID, R extends Repository<T, ?>> EntityLookupRegistrar forValueRepository(Class<R> type, Converter<T, ID> identifierMapping, EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> lookup) {
        this.lookupTypes.add(AbstractRepositoryMetadata.getMetadata(type).getDomainType());
        return this.forRepository(type, identifierMapping, lookup);
    }

    public List<EntityLookup<?>> getEntityLookups(Repositories repositories) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null");
        return (List)this.lookupInformation.stream().map(it -> new RepositoriesEntityLookup(repositories, it)).collect(StreamUtils.toUnmodifiableList());
    }

    public boolean isLookupType(Class<?> type) {
        return this.lookupTypes.contains(type);
    }

    private class MappingBuilder<T, ID, R extends Repository<T, ?>>
    implements EntityLookupRegistrar.LookupRegistrar<T, ID, R>,
    EntityLookupRegistrar.IdMappingRegistrar<T, R> {
        private final Class<R> repositoryType;
        private Converter<T, ID> idMapping;

        public MappingBuilder(Class<R> type) {
            Assert.notNull(type, (String)"Repository type must not be null");
            this.repositoryType = type;
        }

        private MappingBuilder(Class<R> repositoryType, Converter<T, ID> mapping) {
            this(repositoryType);
            Assert.notNull(mapping, (String)"Converter must not be null");
            this.idMapping = mapping;
        }

        @Override
        public EntityLookupRegistrar withLookup(EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> lookup) {
            EntityLookupConfiguration.this.lookupInformation.add(new LookupInformation<T, ID, R>(this.repositoryType, this.idMapping, lookup));
            return EntityLookupConfiguration.this;
        }

        @Override
        public <ID2> EntityLookupRegistrar.LookupRegistrar<T, ID2, R> withIdMapping(Converter<T, ID2> idMapping) {
            return new MappingBuilder<T, ID2, R>(this.repositoryType, idMapping);
        }
    }

    private static class RepositoriesEntityLookup<T>
    implements EntityLookup<T> {
        private final LookupInformation<Object, Object, Repository<? extends T, ?>> lookupInfo;
        private final Repository<? extends T, ?> repository;
        private final Class<?> domainType;
        private final Optional<String> lookupProperty;

        public RepositoriesEntityLookup(Repositories repositories, LookupInformation<Object, Object, Repository<? extends T, ?>> lookupInformation) {
            Assert.notNull((Object)repositories, (String)"Repositories must not be null");
            Assert.notNull(lookupInformation, (String)"LookupInformation must not be null");
            RepositoryInformation information = (RepositoryInformation)repositories.getRepositoryInformation(lookupInformation.repositoryType).orElseThrow(() -> new IllegalStateException("No repository found for type " + lookupInformation.repositoryType.getName()));
            this.domainType = information.getDomainType();
            this.lookupInfo = lookupInformation;
            this.repository = (Repository)repositories.getRepositoryFor(information.getDomainType()).orElseThrow(() -> new IllegalStateException("No repository found for type " + information.getDomainType().getName()));
            this.lookupProperty = Optional.of(this.domainType).flatMap(it -> MethodInvocationRecorder.forProxyOf((Class)it).record(arg_0 -> this.lookupInfo.identifierMapping.convert(arg_0)).getPropertyPath());
        }

        @Override
        public Object getResourceIdentifier(T entity) {
            return this.lookupInfo.getIdentifierMapping().convert(entity);
        }

        @Override
        public Optional<T> lookupEntity(Object id) {
            Object result = this.lookupInfo.getLookup().lookup(this.repository, id);
            return Optional.class.isInstance(result) ? (Optional<Object>)result : Optional.ofNullable(result);
        }

        public boolean supports(Class<?> delimiter) {
            return this.domainType.isAssignableFrom(delimiter);
        }

        @Override
        public Optional<String> getLookupProperty() {
            return this.lookupProperty;
        }
    }

    private static final class LookupInformation<T, ID, R extends Repository<? extends T, ?>> {
        private final Class<R> repositoryType;
        private final Converter<T, ID> identifierMapping;
        private final EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> lookup;

        public LookupInformation(Class<R> repositoryType, Converter<T, ID> identifierMapping, EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> lookup) {
            Assert.notNull(repositoryType, (String)"Repository type must not be null");
            Assert.notNull(identifierMapping, (String)"Identifier mapping must not be null");
            Assert.notNull(lookup, (String)"Lookup must not be null");
            this.repositoryType = repositoryType;
            this.identifierMapping = identifierMapping;
            this.lookup = lookup;
        }

        public Class<R> getRepositoryType() {
            return this.repositoryType;
        }

        public Converter<T, ID> getIdentifierMapping() {
            return this.identifierMapping;
        }

        public EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> getLookup() {
            return this.lookup;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LookupInformation)) {
                return false;
            }
            LookupInformation that = (LookupInformation)o;
            return Objects.equals(this.getRepositoryType(), that.getRepositoryType()) && Objects.equals(this.getIdentifierMapping(), that.getIdentifierMapping()) && Objects.equals(this.getLookup(), that.getLookup());
        }

        public int hashCode() {
            return Objects.hash(this.getRepositoryType(), this.getIdentifierMapping(), this.getLookup());
        }

        public String toString() {
            return "EntityLookupConfiguration.LookupInformation(repositoryType=" + this.getRepositoryType() + ", identifierMapping=" + this.getIdentifierMapping() + ", lookup=" + this.getLookup() + ")";
        }
    }
}

