/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.annotation.HandleAfterCreate;
import org.springframework.data.rest.core.annotation.HandleAfterDelete;
import org.springframework.data.rest.core.annotation.HandleAfterLinkDelete;
import org.springframework.data.rest.core.annotation.HandleAfterLinkSave;
import org.springframework.data.rest.core.annotation.HandleAfterSave;
import org.springframework.data.rest.core.annotation.HandleBeforeCreate;
import org.springframework.data.rest.core.annotation.HandleBeforeDelete;
import org.springframework.data.rest.core.annotation.HandleBeforeLinkDelete;
import org.springframework.data.rest.core.annotation.HandleBeforeLinkSave;
import org.springframework.data.rest.core.annotation.HandleBeforeSave;
import org.springframework.data.rest.core.annotation.RepositoryEventHandler;
import org.springframework.data.rest.core.event.AfterCreateEvent;
import org.springframework.data.rest.core.event.AfterDeleteEvent;
import org.springframework.data.rest.core.event.AfterLinkDeleteEvent;
import org.springframework.data.rest.core.event.AfterLinkSaveEvent;
import org.springframework.data.rest.core.event.AfterSaveEvent;
import org.springframework.data.rest.core.event.BeforeCreateEvent;
import org.springframework.data.rest.core.event.BeforeDeleteEvent;
import org.springframework.data.rest.core.event.BeforeLinkDeleteEvent;
import org.springframework.data.rest.core.event.BeforeLinkSaveEvent;
import org.springframework.data.rest.core.event.BeforeSaveEvent;
import org.springframework.data.rest.core.event.LinkedEntityEvent;
import org.springframework.data.rest.core.event.RepositoryEvent;
import org.springframework.data.util.ProxyUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public class AnnotatedEventHandlerInvoker
implements ApplicationListener<RepositoryEvent>,
BeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotatedEventHandlerInvoker.class);
    private static final String PARAMETER_MISSING = "Invalid event handler method %s; At least a single argument is required to determine the domain type for which you are interested in events";
    private final MultiValueMap<Class<? extends RepositoryEvent>, EventHandlerMethod> handlerMethods = new LinkedMultiValueMap();

    public void onApplicationEvent(RepositoryEvent event) {
        Class<?> eventType = ((Object)((Object)event)).getClass();
        if (!this.handlerMethods.containsKey(eventType)) {
            return;
        }
        for (EventHandlerMethod handlerMethod : (List)this.handlerMethods.get(eventType)) {
            Object src = event.getSource();
            if (!ClassUtils.isAssignable(handlerMethod.targetType, src.getClass())) continue;
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add(src);
            if (event instanceof LinkedEntityEvent) {
                parameters.add(((LinkedEntityEvent)event).getLinked());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invoking {} handler for {}", (Object)((Object)((Object)event)).getClass().getSimpleName(), event.getSource());
            }
            ReflectionUtils.invokeMethod((Method)handlerMethod.method, (Object)handlerMethod.handler, (Object[])parameters.toArray());
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class beanType = ProxyUtils.getUserClass((Object)bean);
        RepositoryEventHandler typeAnno = (RepositoryEventHandler)AnnotationUtils.findAnnotation((Class)beanType, RepositoryEventHandler.class);
        if (typeAnno == null) {
            return bean;
        }
        for (Method method : ReflectionUtils.getUniqueDeclaredMethods((Class)beanType)) {
            this.inspect(bean, method, HandleBeforeCreate.class, BeforeCreateEvent.class);
            this.inspect(bean, method, HandleAfterCreate.class, AfterCreateEvent.class);
            this.inspect(bean, method, HandleBeforeSave.class, BeforeSaveEvent.class);
            this.inspect(bean, method, HandleAfterSave.class, AfterSaveEvent.class);
            this.inspect(bean, method, HandleBeforeLinkSave.class, BeforeLinkSaveEvent.class);
            this.inspect(bean, method, HandleAfterLinkSave.class, AfterLinkSaveEvent.class);
            this.inspect(bean, method, HandleBeforeDelete.class, BeforeDeleteEvent.class);
            this.inspect(bean, method, HandleAfterDelete.class, AfterDeleteEvent.class);
            this.inspect(bean, method, HandleBeforeLinkDelete.class, BeforeLinkDeleteEvent.class);
            this.inspect(bean, method, HandleAfterLinkDelete.class, AfterLinkDeleteEvent.class);
        }
        return bean;
    }

    private <T extends Annotation> void inspect(Object handler, Method method, Class<T> annotationType, Class<? extends RepositoryEvent> eventType) {
        ArrayList<EventHandlerMethod> events;
        Annotation annotation = AnnotationUtils.findAnnotation((Method)method, annotationType);
        if (annotation == null) {
            return;
        }
        if (method.getParameterCount() == 0) {
            throw new IllegalStateException(String.format(PARAMETER_MISSING, method));
        }
        ResolvableType parameter = ResolvableType.forMethodParameter((Method)method, (int)0, handler.getClass());
        EventHandlerMethod handlerMethod = EventHandlerMethod.of(parameter.resolve(), handler, method);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Annotated handler method found: {}", (Object)handlerMethod);
        }
        if ((events = (ArrayList<EventHandlerMethod>)this.handlerMethods.get(eventType)) == null) {
            events = new ArrayList<EventHandlerMethod>();
        }
        if (events.isEmpty()) {
            this.handlerMethods.add(eventType, (Object)handlerMethod);
            return;
        }
        events.add(handlerMethod);
        Collections.sort(events);
        this.handlerMethods.put(eventType, events);
    }

    static class EventHandlerMethod
    implements Comparable<EventHandlerMethod> {
        final Class<?> targetType;
        final Method method;
        final Object handler;

        public EventHandlerMethod(Class<?> targetType, Method method, Object handler) {
            Assert.notNull(targetType, (String)"Target type must not be null");
            Assert.notNull((Object)method, (String)"Method must not be null");
            Assert.notNull((Object)handler, (String)"Handler must not be null");
            this.targetType = targetType;
            this.method = method;
            this.handler = handler;
        }

        public static EventHandlerMethod of(Class<?> targetType, Object handler, Method method) {
            ReflectionUtils.makeAccessible((Method)method);
            return new EventHandlerMethod(targetType, method, handler);
        }

        @Override
        public int compareTo(EventHandlerMethod o) {
            return AnnotationAwareOrderComparator.INSTANCE.compare((Object)this.method, (Object)o.method);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventHandlerMethod)) {
                return false;
            }
            EventHandlerMethod other = (EventHandlerMethod)o;
            return Objects.equals(this.targetType, other.targetType) && Objects.equals(this.method, other.method) && Objects.equals(this.handler, other.handler);
        }

        public int hashCode() {
            return Objects.hash(this.targetType, this.method, this.handler);
        }

        public String toString() {
            return "AnnotatedEventHandlerInvoker.EventHandlerMethod(targetType=" + this.targetType + ", method=" + this.method + ", handler=" + this.handler + ")";
        }
    }
}

