/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import org.springframework.core.MethodParameter;
import org.springframework.data.rest.core.annotation.Description;
import org.springframework.data.rest.core.mapping.AnnotationBasedResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.TypedResourceDescription;
import org.springframework.hateoas.LinkRelation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class ParameterMetadata {
    private final String name;
    private final ResourceDescription description;

    public ParameterMetadata(MethodParameter parameter, String baseRel) {
        Assert.notNull((Object)parameter, (String)"MethodParameter must not be null");
        this.name = parameter.getParameterName();
        Assert.hasText((String)this.name, (String)"Parameter name must not be null or empty");
        Assert.hasText((String)baseRel, (String)"Method rel must not be null");
        ResourceDescription fallback = TypedResourceDescription.defaultFor(LinkRelation.of((String)baseRel.concat(".").concat(this.name)), parameter.getParameterType());
        Description annotation = (Description)parameter.getParameterAnnotation(Description.class);
        this.description = annotation == null ? fallback : new AnnotationBasedResourceDescription(annotation, fallback);
    }

    public String getName() {
        return this.name;
    }

    public ResourceDescription getDescription() {
        return this.description;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParameterMetadata)) {
            return false;
        }
        ParameterMetadata that = (ParameterMetadata)obj;
        return this.name.equals(that.name) && this.description.equals(that.description);
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.name.hashCode();
        return result += 31 * this.description.hashCode();
    }
}

