/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.support.SmartLifecycleRoleController;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractEndpoint
extends IntegrationObjectSupport
implements SmartLifecycle,
DisposableBean {
    protected final ReentrantLock lifecycleLock = new ReentrantLock();
    protected final Condition lifecycleCondition = this.lifecycleLock.newCondition();
    private String role;
    private SmartLifecycleRoleController roleController;
    private boolean autoStartup = true;
    private boolean autoStartupSetExplicitly;
    private int phase = 0;
    private volatile boolean running;
    private volatile boolean active;

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
        this.autoStartupSetExplicitly = true;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (!this.autoStartupSetExplicitly) {
            String[] endpointNamePatterns;
            for (String pattern : endpointNamePatterns = this.getIntegrationProperty("spring.integration.endpoints.noAutoStartup", String[].class)) {
                if (!PatternMatchUtils.simpleMatch((String)pattern, (String)this.getComponentName())) continue;
                this.autoStartup = false;
                break;
            }
        }
        if (StringUtils.hasText((String)this.role)) {
            try {
                this.roleController = (SmartLifecycleRoleController)this.getBeanFactory().getBean("integrationLifecycleRoleController", SmartLifecycleRoleController.class);
                this.roleController.addLifecycleToRole(this.role, this);
            }
            catch (NoSuchBeanDefinitionException e) {
                this.logger.trace((Object)"No LifecycleRoleController in the context");
            }
        }
    }

    public void destroy() {
        this.stop();
        if (this.roleController != null) {
            this.roleController.removeLifecycle(this);
        }
    }

    public final boolean isAutoStartup() {
        return this.autoStartup;
    }

    public final int getPhase() {
        return this.phase;
    }

    public final boolean isRunning() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                this.active = true;
                this.doStart();
                this.running = true;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("started " + this));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.running) {
                this.active = false;
                this.doStop();
                this.running = false;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("stopped " + this));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void stop(Runnable callback) {
        this.lifecycleLock.lock();
        try {
            if (this.running) {
                this.active = false;
                this.doStop(callback);
                this.running = false;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("stopped " + this));
                }
            } else {
                callback.run();
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected void doStop(Runnable callback) {
        this.doStop();
        callback.run();
    }

    public boolean isActive() {
        return this.active;
    }

    protected abstract void doStart();

    protected abstract void doStop();
}

