/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.util;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.integration.support.locks.ExpirableLockRegistry;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.concurrent.SettableListenableFuture;

public final class RedisLockRegistry
implements ExpirableLockRegistry,
DisposableBean {
    private static final Log LOGGER = LogFactory.getLog(RedisLockRegistry.class);
    private static final long DEFAULT_EXPIRE_AFTER = 60000L;
    private static final int DEFAULT_CAPACITY = 100000;
    private static final String OBTAIN_LOCK_SCRIPT = "local lockClientId = redis.call('GET', KEYS[1])\nif lockClientId == ARGV[1] then\n  redis.call('PEXPIRE', KEYS[1], ARGV[2])\n  return true\nelseif not lockClientId then\n  redis.call('SET', KEYS[1], ARGV[1], 'PX', ARGV[2])\n  return true\nend\nreturn false";
    private static final String UNLINK_UNLOCK_SCRIPT = "if (redis.call('unlink', KEYS[1]) == 1) then redis.call('publish', ARGV[1], KEYS[1]) return true end return false";
    private static final String DELETE_UNLOCK_SCRIPT = "if (redis.call('del', KEYS[1]) == 1) then redis.call('publish', ARGV[1], KEYS[1]) return true end return false";
    private final Map<String, RedisLock> locks = new LinkedHashMap<String, RedisLock>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, RedisLock> eldest) {
            return this.size() > RedisLockRegistry.this.cacheCapacity;
        }
    };
    private final String clientId = UUID.randomUUID().toString();
    private final String registryKey;
    private final String unLockChannelKey;
    private final StringRedisTemplate redisTemplate;
    private final RedisScript<Boolean> obtainLockScript;
    private final RedisScript<Boolean> unLinkUnLockScript;
    private final RedisScript<Boolean> deleteUnLockScript;
    private final RedisUnLockNotifyMessageListener unlockNotifyMessageListener;
    private final RedisMessageListenerContainer redisMessageListenerContainer;
    private final long expireAfter;
    private int cacheCapacity = 100000;
    private Executor executor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("redis-lock-registry-"));
    private boolean executorExplicitlySet;
    private volatile boolean unlinkAvailable = true;
    private volatile boolean isRunningRedisMessageListenerContainer = false;

    public RedisLockRegistry(RedisConnectionFactory connectionFactory, String registryKey) {
        this(connectionFactory, registryKey, 60000L);
    }

    public RedisLockRegistry(RedisConnectionFactory connectionFactory, String registryKey, long expireAfter) {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' cannot be null");
        Assert.notNull((Object)registryKey, (String)"'registryKey' cannot be null");
        this.redisTemplate = new StringRedisTemplate(connectionFactory);
        this.obtainLockScript = new DefaultRedisScript(OBTAIN_LOCK_SCRIPT, Boolean.class);
        this.unLinkUnLockScript = new DefaultRedisScript(UNLINK_UNLOCK_SCRIPT, Boolean.class);
        this.deleteUnLockScript = new DefaultRedisScript(DELETE_UNLOCK_SCRIPT, Boolean.class);
        this.registryKey = registryKey;
        this.expireAfter = expireAfter;
        this.unLockChannelKey = registryKey + "-channel";
        this.unlockNotifyMessageListener = new RedisUnLockNotifyMessageListener();
        this.redisMessageListenerContainer = new RedisMessageListenerContainer();
        this.setupUnlockMessageListener(connectionFactory);
    }

    private void setupUnlockMessageListener(RedisConnectionFactory connectionFactory) {
        ChannelTopic topic = new ChannelTopic(this.unLockChannelKey);
        this.redisMessageListenerContainer.setConnectionFactory(connectionFactory);
        this.redisMessageListenerContainer.setTaskExecutor(this.executor);
        this.redisMessageListenerContainer.setSubscriptionExecutor(this.executor);
        this.redisMessageListenerContainer.addMessageListener((MessageListener)this.unlockNotifyMessageListener, (Topic)topic);
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.executorExplicitlySet = true;
        this.redisMessageListenerContainer.setTaskExecutor(this.executor);
        this.redisMessageListenerContainer.setSubscriptionExecutor(this.executor);
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock obtain(Object lockKey) {
        Assert.isInstanceOf(String.class, (Object)lockKey);
        String path = (String)lockKey;
        Map<String, RedisLock> map = this.locks;
        synchronized (map) {
            return this.locks.computeIfAbsent(path, x$0 -> new RedisLock((String)x$0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireUnusedOlderThan(long age) {
        long now = System.currentTimeMillis();
        Map<String, RedisLock> map = this.locks;
        synchronized (map) {
            this.locks.entrySet().removeIf(entry -> {
                RedisLock lock = (RedisLock)entry.getValue();
                return now - lock.getLockedAt() > age && !lock.isAcquiredInThisProcess();
            });
        }
    }

    public void destroy() {
        if (!this.executorExplicitlySet) {
            ((ExecutorService)this.executor).shutdown();
        }
        try {
            this.redisMessageListenerContainer.destroy();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static final class RedisUnLockNotifyMessageListener
    implements MessageListener {
        private final Map<String, SettableListenableFuture<String>> notifyMap = new ConcurrentHashMap<String, SettableListenableFuture<String>>();

        private RedisUnLockNotifyMessageListener() {
        }

        public void onMessage(Message message, byte[] pattern) {
            String lockKey = new String(message.getBody());
            this.unlockNotify(lockKey);
        }

        public Future<String> subscribeLock(String lockKey) {
            return (Future)this.notifyMap.computeIfAbsent(lockKey, key -> new SettableListenableFuture());
        }

        public void unSubscribeLock(String localLock) {
            this.notifyMap.remove(localLock);
        }

        private void unlockNotify(String lockKey) {
            this.notifyMap.computeIfPresent(lockKey, (key, lockFuture) -> {
                lockFuture.set(key);
                return lockFuture;
            });
        }
    }

    private final class RedisLock
    implements Lock {
        private final String lockKey;
        private final ReentrantLock localLock = new ReentrantLock();
        private volatile long lockedAt;

        private RedisLock(String path) {
            this.lockKey = this.constructLockKey(path);
        }

        private String constructLockKey(String path) {
            return RedisLockRegistry.this.registryKey + ':' + path;
        }

        public long getLockedAt() {
            return this.lockedAt;
        }

        @Override
        public void lock() {
            this.localLock.lock();
            while (true) {
                try {
                    while (!this.subscribeLock(-1L)) {
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception e) {
                    this.localLock.unlock();
                    this.rethrowAsLockException(e);
                    continue;
                }
                break;
            }
        }

        private void rethrowAsLockException(Exception e) {
            throw new CannotAcquireLockException("Failed to lock mutex at " + this.lockKey, (Throwable)e);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.localLock.lockInterruptibly();
            while (true) {
                try {
                    while (!this.subscribeLock(-1L)) {
                    }
                    return;
                }
                catch (InterruptedException ie) {
                    this.localLock.unlock();
                    Thread.currentThread().interrupt();
                    throw ie;
                }
                catch (Exception e) {
                    this.localLock.unlock();
                    this.rethrowAsLockException(e);
                    continue;
                }
                break;
            }
        }

        @Override
        public boolean tryLock() {
            try {
                return this.tryLock(0L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            if (!this.localLock.tryLock(time, unit)) {
                return false;
            }
            try {
                long waitTime = TimeUnit.MILLISECONDS.convert(time, unit);
                boolean acquired = this.subscribeLock(waitTime);
                if (!acquired) {
                    this.localLock.unlock();
                }
                return acquired;
            }
            catch (Exception e) {
                this.localLock.unlock();
                this.rethrowAsLockException(e);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean subscribeLock(long time) throws ExecutionException, InterruptedException {
            long expiredTime = System.currentTimeMillis() + time;
            if (this.obtainLock()) {
                return true;
            }
            if (!RedisLockRegistry.this.isRunningRedisMessageListenerContainer || !RedisLockRegistry.this.redisMessageListenerContainer.isRunning()) {
                this.runRedisMessageListenerContainer();
            }
            while (time == -1L || expiredTime >= System.currentTimeMillis()) {
                try {
                    Future<String> future = RedisLockRegistry.this.unlockNotifyMessageListener.subscribeLock(this.lockKey);
                    if (this.obtainLock()) {
                        boolean bl = true;
                        return bl;
                    }
                    try {
                        long waitTime = time >= 0L ? time : RedisLockRegistry.this.expireAfter;
                        future.get(waitTime, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                    if (!this.obtainLock()) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    RedisLockRegistry.this.unlockNotifyMessageListener.unSubscribeLock(this.lockKey);
                }
            }
            return false;
        }

        private boolean obtainLock() {
            Boolean success = (Boolean)RedisLockRegistry.this.redisTemplate.execute(RedisLockRegistry.this.obtainLockScript, Collections.singletonList(this.lockKey), new Object[]{RedisLockRegistry.this.clientId, String.valueOf(RedisLockRegistry.this.expireAfter)});
            boolean result = Boolean.TRUE.equals(success);
            if (result) {
                this.lockedAt = System.currentTimeMillis();
            }
            return result;
        }

        @Override
        public void unlock() {
            if (!this.localLock.isHeldByCurrentThread()) {
                throw new IllegalStateException("You do not own lock at " + this.lockKey);
            }
            if (this.localLock.getHoldCount() > 1) {
                this.localLock.unlock();
                return;
            }
            try {
                if (!this.isAcquiredInThisProcess()) {
                    throw new IllegalStateException("Lock was released in the store due to expiration. The integrity of data protected by this lock may have been compromised.");
                }
                if (Thread.currentThread().isInterrupted()) {
                    RedisLockRegistry.this.executor.execute(this::removeLockKey);
                } else {
                    this.removeLockKey();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Released lock; " + this));
                }
            }
            catch (Exception e) {
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            finally {
                this.localLock.unlock();
            }
        }

        private void removeLockKey() {
            if (RedisLockRegistry.this.unlinkAvailable) {
                try {
                    RedisLockRegistry.this.redisTemplate.execute(RedisLockRegistry.this.unLinkUnLockScript, Collections.singletonList(this.lockKey), new Object[]{RedisLockRegistry.this.unLockChannelKey});
                    return;
                }
                catch (Exception ex) {
                    RedisLockRegistry.this.unlinkAvailable = false;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"The UNLINK command has failed (not supported on the Redis server?); falling back to the regular DELETE command", (Throwable)ex);
                    }
                    LOGGER.warn((Object)("The UNLINK command has failed (not supported on the Redis server?); falling back to the regular DELETE command: " + ex.getMessage()));
                }
            }
            RedisLockRegistry.this.redisTemplate.execute(RedisLockRegistry.this.deleteUnLockScript, Collections.singletonList(this.lockKey), new Object[]{RedisLockRegistry.this.unLockChannelKey});
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("Conditions are not supported");
        }

        public boolean isAcquiredInThisProcess() {
            return RedisLockRegistry.this.clientId.equals(RedisLockRegistry.this.redisTemplate.boundValueOps((Object)this.lockKey).get());
        }

        public String toString() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd@HH:mm:ss.SSS");
            return "RedisLock [lockKey=" + this.lockKey + ",lockedAt=" + dateFormat.format(new Date(this.lockedAt)) + ", clientId=" + RedisLockRegistry.this.clientId + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.lockKey == null ? 0 : this.lockKey.hashCode());
            result = 31 * result + (int)(this.lockedAt ^ this.lockedAt >>> 32);
            result = 31 * result + RedisLockRegistry.this.clientId.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RedisLock other = (RedisLock)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (!this.lockKey.equals(other.lockKey)) {
                return false;
            }
            return this.lockedAt == other.lockedAt;
        }

        private RedisLockRegistry getOuterType() {
            return RedisLockRegistry.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runRedisMessageListenerContainer() {
            RedisMessageListenerContainer redisMessageListenerContainer = RedisLockRegistry.this.redisMessageListenerContainer;
            synchronized (redisMessageListenerContainer) {
                if (!RedisLockRegistry.this.isRunningRedisMessageListenerContainer || !RedisLockRegistry.this.redisMessageListenerContainer.isRunning()) {
                    RedisLockRegistry.this.redisMessageListenerContainer.afterPropertiesSet();
                    RedisLockRegistry.this.redisMessageListenerContainer.start();
                    RedisLockRegistry.this.isRunningRedisMessageListenerContainer = true;
                }
            }
        }
    }
}

