/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;

public final class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static boolean evaluateAsBoolean(Expression expr, EvaluationContext ctx) {
        try {
            Boolean result = (Boolean)expr.getValue(ctx, Boolean.class);
            if (result == null) {
                throw new IllegalArgumentException("Expression was null but expected boolean result '" + expr.getExpressionString() + "'");
            }
            return result;
        }
        catch (EvaluationException ex) {
            throw new IllegalArgumentException("Failed to evaluate expression '" + expr.getExpressionString() + "'", ex);
        }
    }
}

