/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.jaas.memory;

import java.util.Collections;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public class InMemoryConfiguration
extends Configuration {
    private final AppConfigurationEntry @Nullable [] defaultConfiguration;
    private final Map<String, AppConfigurationEntry[]> mappedConfigurations;

    public InMemoryConfiguration(AppConfigurationEntry[] defaultConfiguration) {
        this(Collections.emptyMap(), defaultConfiguration);
    }

    public InMemoryConfiguration(Map<String, AppConfigurationEntry[]> mappedConfigurations) {
        this(mappedConfigurations, null);
    }

    public InMemoryConfiguration(Map<String, AppConfigurationEntry[]> mappedConfigurations, AppConfigurationEntry @Nullable [] defaultConfiguration) {
        Assert.notNull(mappedConfigurations, (String)"mappedConfigurations cannot be null.");
        this.mappedConfigurations = mappedConfigurations;
        this.defaultConfiguration = defaultConfiguration;
    }

    @Override
    public AppConfigurationEntry @Nullable [] getAppConfigurationEntry(String name) {
        AppConfigurationEntry[] mappedResult = this.mappedConfigurations.get(name);
        return mappedResult != null ? mappedResult : this.defaultConfiguration;
    }

    @Override
    public void refresh() {
    }
}

