/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.FactorAuthorizationDecision;
import org.springframework.security.authorization.RequiredFactor;
import org.springframework.security.authorization.RequiredFactorError;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.FactorGrantedAuthority;
import org.springframework.util.Assert;

public final class AllRequiredFactorsAuthorizationManager<T>
implements AuthorizationManager<T> {
    private Clock clock = Clock.systemUTC();
    private final List<RequiredFactor> requiredFactors;

    private AllRequiredFactorsAuthorizationManager(List<RequiredFactor> requiredFactors) {
        Assert.notEmpty(requiredFactors, (String)"requiredFactors cannot be empty");
        Assert.noNullElements(requiredFactors, (String)"requiredFactors must not contain null elements");
        this.requiredFactors = Collections.unmodifiableList(requiredFactors);
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }

    @Override
    public FactorAuthorizationDecision authorize(Supplier<? extends @Nullable Authentication> authentication, T object) {
        List<GrantedAuthority> currentFactorAuthorities = this.getFactorGrantedAuthorities(authentication.get());
        List<RequiredFactorError> factorErrors = this.requiredFactors.stream().map(factor -> this.requiredFactorError((RequiredFactor)factor, currentFactorAuthorities)).filter(Objects::nonNull).toList();
        return new FactorAuthorizationDecision(factorErrors);
    }

    private @Nullable RequiredFactorError requiredFactorError(RequiredFactor requiredFactor, List<GrantedAuthority> currentFactors) {
        Optional<GrantedAuthority> matchingAuthority = currentFactors.stream().filter(authority -> Objects.equals(authority.getAuthority(), requiredFactor.getAuthority())).findFirst();
        if (!matchingAuthority.isPresent()) {
            return RequiredFactorError.createMissing(requiredFactor);
        }
        return matchingAuthority.map(authority -> {
            if (requiredFactor.getValidDuration() == null) {
                return null;
            }
            if (authority instanceof FactorGrantedAuthority) {
                Instant expiresAt;
                FactorGrantedAuthority factorAuthority = (FactorGrantedAuthority)authority;
                Instant now = this.clock.instant();
                if (now.isBefore(expiresAt = factorAuthority.getIssuedAt().plus(requiredFactor.getValidDuration()))) {
                    return null;
                }
            }
            return RequiredFactorError.createExpired(requiredFactor);
        }).orElse(null);
    }

    private List<GrantedAuthority> getFactorGrantedAuthorities(@Nullable Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            return Collections.emptyList();
        }
        return authentication.getAuthorities().stream().collect(Collectors.toList());
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<T> {
        private List<RequiredFactor> requiredFactors = new ArrayList<RequiredFactor>();

        public Builder<T> requireFactor(Consumer<RequiredFactor.Builder> requiredFactor) {
            Assert.notNull(requiredFactor, (String)"requiredFactor cannot be null");
            RequiredFactor.Builder builder = RequiredFactor.builder();
            requiredFactor.accept(builder);
            return this.requireFactor(builder.build());
        }

        public Builder<T> requireFactor(RequiredFactor requiredFactor) {
            Assert.notNull((Object)requiredFactor, (String)"requiredFactor cannot be null");
            this.requiredFactors.add(requiredFactor);
            return this;
        }

        public AllRequiredFactorsAuthorizationManager<T> build() {
            Assert.state((!this.requiredFactors.isEmpty() ? 1 : 0) != 0, (String)"requiredFactors cannot be empty");
            return new AllRequiredFactorsAuthorizationManager(this.requiredFactors);
        }
    }
}

