/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.Pointcut;
import org.springframework.expression.EvaluationContext;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.prepost.PreFilter;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authorization.method.AuthorizationAdvisor;
import org.springframework.security.authorization.method.AuthorizationInterceptorsOrder;
import org.springframework.security.authorization.method.AuthorizationMethodPointcuts;
import org.springframework.security.authorization.method.PreFilterExpressionAttributeRegistry;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class PreFilterAuthorizationMethodInterceptor
implements AuthorizationAdvisor {
    private Supplier<SecurityContextHolderStrategy> securityContextHolderStrategy = SecurityContextHolder::getContextHolderStrategy;
    private PreFilterExpressionAttributeRegistry registry = new PreFilterExpressionAttributeRegistry();
    private int order = AuthorizationInterceptorsOrder.PRE_FILTER.getOrder();
    private final Pointcut pointcut = AuthorizationMethodPointcuts.forAnnotations(PreFilter.class);

    public void setExpressionHandler(MethodSecurityExpressionHandler expressionHandler) {
        this.registry.setExpressionHandler(expressionHandler);
    }

    public void setTemplateDefaults(AnnotationTemplateExpressionDefaults defaults) {
        this.registry.setTemplateDefaults(defaults);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this;
    }

    public boolean isPerInstance() {
        return true;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy strategy) {
        this.securityContextHolderStrategy = () -> strategy;
    }

    public @Nullable Object invoke(MethodInvocation mi) throws Throwable {
        PreFilterExpressionAttributeRegistry.PreFilterExpressionAttribute attribute = (PreFilterExpressionAttributeRegistry.PreFilterExpressionAttribute)this.registry.getAttribute(mi);
        if (attribute == null) {
            return mi.proceed();
        }
        MethodSecurityExpressionHandler expressionHandler = this.registry.getExpressionHandler();
        EvaluationContext ctx = expressionHandler.createEvaluationContext(this::getAuthentication, mi);
        Object filterTarget = this.findFilterTarget(attribute.getFilterTarget(), ctx, mi);
        expressionHandler.filter(filterTarget, attribute.getExpression(), ctx);
        return mi.proceed();
    }

    private Object findFilterTarget(String filterTargetName, EvaluationContext ctx, MethodInvocation methodInvocation) {
        Object filterTarget;
        if (StringUtils.hasText((String)filterTargetName)) {
            filterTarget = ctx.lookupVariable(filterTargetName);
            Assert.notNull((Object)filterTarget, () -> "Filter target was null, or no argument with name '" + filterTargetName + "' found in method.");
        } else {
            Object[] arguments = methodInvocation.getArguments();
            Assert.state((arguments.length == 1 ? 1 : 0) != 0, (String)"Unable to determine the method argument for filtering. Specify the filter target.");
            filterTarget = arguments[0];
            Assert.notNull((Object)filterTarget, (String)"Filter target was null. Make sure you passing the correct value in the method argument.");
        }
        Assert.state((!filterTarget.getClass().isArray() ? 1 : 0) != 0, (String)"Pre-filtering on array types is not supported. Using a Collection will solve this problem.");
        return filterTarget;
    }

    private Authentication getAuthentication() {
        Authentication authentication = this.securityContextHolderStrategy.get().getContext().getAuthentication();
        if (authentication == null) {
            throw new AuthenticationCredentialsNotFoundException("An Authentication object was not found in the SecurityContext");
        }
        return authentication;
    }
}

