/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import org.jspecify.annotations.Nullable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.ExpressionAuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

final class ReactiveExpressionUtils {
    static Mono<AuthorizationResult> evaluate(Expression expr, EvaluationContext ctx) {
        return ReactiveExpressionUtils.evaluate(expr, ctx, (Mono<Authentication>)Mono.empty(), null);
    }

    static <T> Mono<AuthorizationResult> evaluate(Expression expr, EvaluationContext ctx, Mono<Authentication> authentication, @Nullable T context) {
        return Mono.defer(() -> {
            Object value;
            try {
                value = expr.getValue(ctx);
            }
            catch (EvaluationException ex) {
                return Mono.error(() -> new IllegalArgumentException("Failed to evaluate expression '" + expr.getExpressionString() + "'", ex));
            }
            if (value instanceof ReactiveAuthorizationManager) {
                ReactiveAuthorizationManager manager = (ReactiveAuthorizationManager)value;
                Assert.notNull((Object)context, (String)"context cannot be null");
                return manager.authorize(authentication, context);
            }
            if (value instanceof Mono) {
                Mono mono = (Mono)value;
                return mono.flatMap(data -> ReactiveExpressionUtils.adapt(expr, data));
            }
            return ReactiveExpressionUtils.adapt(expr, value);
        });
    }

    private static Mono<AuthorizationResult> adapt(Expression expr, @Nullable Object value) {
        if (value instanceof Boolean) {
            Boolean granted = (Boolean)value;
            return Mono.just((Object)new ExpressionAuthorizationDecision(granted, expr));
        }
        if (value instanceof AuthorizationResult) {
            AuthorizationResult decision = (AuthorizationResult)value;
            return Mono.just((Object)decision);
        }
        return ReactiveExpressionUtils.createInvalidReturnTypeMono(expr);
    }

    static Mono<Boolean> evaluateAsBoolean(Expression expr, EvaluationContext ctx) {
        return Mono.defer(() -> {
            Object value;
            try {
                value = expr.getValue(ctx);
            }
            catch (EvaluationException ex) {
                return Mono.error(() -> new IllegalArgumentException("Failed to evaluate expression '" + expr.getExpressionString() + "'", ex));
            }
            if (value instanceof Boolean) {
                return Mono.just((Object)((Boolean)value));
            }
            if (value instanceof Mono) {
                Mono monoValue = (Mono)value;
                return monoValue.filter(Boolean.class::isInstance).map(Boolean.class::cast).switchIfEmpty(ReactiveExpressionUtils.createInvalidReturnTypeMono(expr));
            }
            return ReactiveExpressionUtils.createInvalidReturnTypeMono(expr);
        });
    }

    private static <T> Mono<T> createInvalidReturnTypeMono(Expression expr) {
        return Mono.error(() -> new IllegalStateException("Expression: '" + expr.getExpressionString() + "' must return boolean, Mono<Boolean>, AuthorizationResult, or Mono<AuthorizationResult>"));
    }

    private ReactiveExpressionUtils() {
    }
}

