/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.scheduling;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import org.jspecify.annotations.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.util.Assert;

public class DelegatingSecurityContextTaskScheduler
implements TaskScheduler {
    private final TaskScheduler delegate;
    private final @Nullable SecurityContext securityContext;

    public DelegatingSecurityContextTaskScheduler(TaskScheduler delegateTaskScheduler, @Nullable SecurityContext securityContext) {
        Assert.notNull((Object)delegateTaskScheduler, (String)"delegateTaskScheduler cannot be null");
        this.delegate = delegateTaskScheduler;
        this.securityContext = securityContext;
    }

    public DelegatingSecurityContextTaskScheduler(TaskScheduler delegate) {
        this(delegate, null);
    }

    public @Nullable ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        return this.delegate.schedule(this.wrap(task), trigger);
    }

    public ScheduledFuture<?> schedule(Runnable task, Date startTime) {
        return this.delegate.schedule(this.wrap(task), startTime);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Date startTime, long period) {
        return this.delegate.scheduleAtFixedRate(this.wrap(task), startTime, period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long period) {
        return this.delegate.scheduleAtFixedRate(this.wrap(task), period);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Date startTime, long delay) {
        return this.delegate.scheduleWithFixedDelay(this.wrap(task), startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long delay) {
        return this.delegate.scheduleWithFixedDelay(this.wrap(task), delay);
    }

    public ScheduledFuture<?> schedule(Runnable task, Instant startTime) {
        return this.delegate.schedule(this.wrap(task), startTime);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Instant startTime, Duration period) {
        return this.delegate.scheduleAtFixedRate(this.wrap(task), startTime, period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Duration period) {
        return this.delegate.scheduleAtFixedRate(this.wrap(task), period);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Instant startTime, Duration delay) {
        return this.delegate.scheduleWithFixedDelay(this.wrap(task), startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Duration delay) {
        return this.delegate.scheduleWithFixedDelay(this.wrap(task), delay);
    }

    public Clock getClock() {
        return this.delegate.getClock();
    }

    private Runnable wrap(Runnable delegate) {
        return DelegatingSecurityContextRunnable.create(delegate, this.securityContext);
    }
}

