/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class OverridingClassLoader
extends ClassLoader {
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle."};
    private static final String CLASS_FILE_SUFFIX = ".class";
    private final Set excludedPackages = Collections.synchronizedSet(new HashSet());
    private final Set excludedClasses = Collections.synchronizedSet(new HashSet());

    public OverridingClassLoader(ClassLoader parent) {
        super(parent);
        for (int i = 0; i < DEFAULT_EXCLUDED_PACKAGES.length; ++i) {
            this.excludedPackages.add(DEFAULT_EXCLUDED_PACKAGES[i]);
        }
    }

    public void excludePackage(String packageName) {
        Assert.notNull(packageName, "Package name must not be null");
        this.excludedPackages.add(packageName);
    }

    public void excludeClass(String className) {
        Assert.notNull(className, "Class name must not be null");
        this.excludedClasses.add(className);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class result = null;
        if (this.isEligibleForOverriding(name)) {
            result = this.loadClassForOverriding(name);
        }
        if (result != null) {
            if (resolve) {
                this.resolveClass(result);
            }
            return result;
        }
        return super.loadClass(name, resolve);
    }

    protected boolean isEligibleForOverriding(String className) {
        if (this.excludedClasses.contains(className)) {
            return false;
        }
        Iterator it = this.excludedPackages.iterator();
        while (it.hasNext()) {
            String packageName = (String)it.next();
            if (!className.startsWith(packageName)) continue;
            return false;
        }
        return true;
    }

    protected Class loadClassForOverriding(String name) throws ClassNotFoundException {
        byte[] bytes;
        Class<?> result = this.findLoadedClass(name);
        if (result == null && (bytes = this.loadBytesForClass(name)) != null) {
            result = this.defineClass(name, bytes, 0, bytes.length);
        }
        return result;
    }

    protected byte[] loadBytesForClass(String name) throws ClassNotFoundException {
        InputStream is = this.openStreamForClass(name);
        if (is == null) {
            return null;
        }
        try {
            byte[] bytes = FileCopyUtils.copyToByteArray(is);
            return this.transformIfNecessary(name, bytes);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Cannot load resource for class [" + name + "]", ex);
        }
    }

    protected InputStream openStreamForClass(String name) {
        String internalName = name.replace('.', '/') + CLASS_FILE_SUFFIX;
        return this.getParent().getResourceAsStream(internalName);
    }

    protected byte[] transformIfNecessary(String name, byte[] bytes) {
        return bytes;
    }
}

