/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import jakarta.persistence.Convert;
import jakarta.persistence.Converter;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.IdClass;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostRemove;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragmentsDecorator;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class PersistenceManagedTypesBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private static final List<Class<? extends Annotation>> CALLBACK_TYPES = List.of(PreUpdate.class, PostUpdate.class, PrePersist.class, PostPersist.class, PreRemove.class, PostRemove.class, PostLoad.class);
    @Nullable
    private static Class<? extends Annotation> embeddableInstantiatorClass;

    PersistenceManagedTypesBeanRegistrationAotProcessor() {
    }

    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        if (PersistenceManagedTypes.class.isAssignableFrom(registeredBean.getBeanClass())) {
            return BeanRegistrationAotContribution.withCustomCodeFragments(codeFragments -> new JpaManagedTypesBeanRegistrationCodeFragments((BeanRegistrationCodeFragments)codeFragments, registeredBean));
        }
        return null;
    }

    static {
        try {
            embeddableInstantiatorClass = ClassUtils.forName((String)"org.hibernate.annotations.EmbeddableInstantiator", (ClassLoader)PersistenceManagedTypesBeanRegistrationAotProcessor.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            embeddableInstantiatorClass = null;
        }
    }

    private static class JpaManagedTypesBeanRegistrationCodeFragments
    extends BeanRegistrationCodeFragmentsDecorator {
        private static final ParameterizedTypeName LIST_OF_STRINGS_TYPE = ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class});
        private final RegisteredBean registeredBean;
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        public JpaManagedTypesBeanRegistrationCodeFragments(BeanRegistrationCodeFragments codeFragments, RegisteredBean registeredBean) {
            super(codeFragments);
            this.registeredBean = registeredBean;
        }

        public CodeBlock generateInstanceSupplierCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, boolean allowDirectSupplierShortcut) {
            PersistenceManagedTypes persistenceManagedTypes = (PersistenceManagedTypes)this.registeredBean.getBeanFactory().getBean(this.registeredBean.getBeanName(), PersistenceManagedTypes.class);
            this.contributeHints(generationContext.getRuntimeHints(), persistenceManagedTypes.getManagedClassNames());
            GeneratedMethod generatedMethod = beanRegistrationCode.getMethods().add("getInstance", method -> {
                Class<PersistenceManagedTypes> beanType = PersistenceManagedTypes.class;
                method.addJavadoc("Get the bean instance for '$L'.", new Object[]{this.registeredBean.getBeanName()});
                method.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
                method.returns(beanType);
                method.addStatement("$T managedClassNames = $T.of($L)", new Object[]{LIST_OF_STRINGS_TYPE, List.class, this.toCodeBlock(persistenceManagedTypes.getManagedClassNames())});
                method.addStatement("$T managedPackages = $T.of($L)", new Object[]{LIST_OF_STRINGS_TYPE, List.class, this.toCodeBlock(persistenceManagedTypes.getManagedPackages())});
                method.addStatement("return $T.of($L, $L)", new Object[]{beanType, "managedClassNames", "managedPackages"});
            });
            return generatedMethod.toMethodReference().toCodeBlock();
        }

        private CodeBlock toCodeBlock(List<String> values) {
            return CodeBlock.join(values.stream().map(value -> CodeBlock.of((String)"$S", (Object[])new Object[]{value})).toList(), (String)", ");
        }

        private void contributeHints(RuntimeHints hints, List<String> managedClassNames) {
            for (String managedClassName : managedClassNames) {
                try {
                    Class managedClass = ClassUtils.forName((String)managedClassName, null);
                    this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{managedClass});
                    this.contributeEntityListenersHints(hints, managedClass);
                    this.contributeIdClassHints(hints, managedClass);
                    this.contributeConverterHints(hints, managedClass);
                    this.contributeCallbackHints(hints, managedClass);
                    this.contributeHibernateHints(hints, managedClass);
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalArgumentException("Failed to instantiate the managed class: " + managedClassName, ex);
                }
            }
        }

        private void contributeEntityListenersHints(RuntimeHints hints, Class<?> managedClass) {
            EntityListeners entityListeners = (EntityListeners)AnnotationUtils.findAnnotation(managedClass, EntityListeners.class);
            if (entityListeners != null) {
                for (Class entityListener : entityListeners.value()) {
                    hints.reflection().registerType(entityListener, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
                }
            }
        }

        private void contributeIdClassHints(RuntimeHints hints, Class<?> managedClass) {
            IdClass idClass = (IdClass)AnnotationUtils.findAnnotation(managedClass, IdClass.class);
            if (idClass != null) {
                this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{idClass.value()});
            }
        }

        private void contributeConverterHints(RuntimeHints hints, Class<?> managedClass) {
            Convert convertClassAnnotation;
            Converter converter = (Converter)AnnotationUtils.findAnnotation(managedClass, Converter.class);
            ReflectionHints reflectionHints = hints.reflection();
            if (converter != null) {
                reflectionHints.registerType(managedClass, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
            }
            if ((convertClassAnnotation = (Convert)AnnotationUtils.findAnnotation(managedClass, Convert.class)) != null) {
                reflectionHints.registerType(convertClassAnnotation.converter(), new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
            }
            ReflectionUtils.doWithFields(managedClass, field -> {
                Convert convertFieldAnnotation = (Convert)AnnotationUtils.findAnnotation((AnnotatedElement)field, Convert.class);
                if (convertFieldAnnotation != null && convertFieldAnnotation.converter() != Void.TYPE) {
                    reflectionHints.registerType(convertFieldAnnotation.converter(), new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
                }
            });
        }

        private void contributeCallbackHints(RuntimeHints hints, Class<?> managedClass) {
            ReflectionHints reflection = hints.reflection();
            ReflectionUtils.doWithMethods(managedClass, method -> reflection.registerMethod(method, ExecutableMode.INVOKE), method -> CALLBACK_TYPES.stream().anyMatch(method::isAnnotationPresent));
        }

        private void contributeHibernateHints(RuntimeHints hints, Class<?> managedClass) {
            if (embeddableInstantiatorClass == null) {
                return;
            }
            ReflectionHints reflection = hints.reflection();
            this.registerInstantiatorForReflection(reflection, AnnotationUtils.findAnnotation(managedClass, embeddableInstantiatorClass));
            ReflectionUtils.doWithFields(managedClass, field -> {
                this.registerInstantiatorForReflection(reflection, AnnotationUtils.findAnnotation((AnnotatedElement)field, embeddableInstantiatorClass));
                this.registerInstantiatorForReflection(reflection, AnnotationUtils.findAnnotation(field.getType(), embeddableInstantiatorClass));
            });
        }

        private void registerInstantiatorForReflection(ReflectionHints reflection, @Nullable Annotation annotation) {
            if (annotation == null) {
                return;
            }
            Class embeddableInstantiatorClass = (Class)AnnotationUtils.getAnnotationAttributes((Annotation)annotation).get("value");
            reflection.registerType(embeddableInstantiatorClass, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
        }
    }
}

