/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.client;

import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;
import org.springframework.http.HttpHeaders;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.sockjs.client.DefaultTransportRequest;
import org.springframework.web.socket.sockjs.client.InfoReceiver;
import org.springframework.web.socket.sockjs.client.RestTemplateXhrTransport;
import org.springframework.web.socket.sockjs.client.SockJsUrlInfo;
import org.springframework.web.socket.sockjs.client.Transport;
import org.springframework.web.socket.sockjs.frame.Jackson2SockJsMessageCodec;
import org.springframework.web.socket.sockjs.frame.SockJsMessageCodec;
import org.springframework.web.socket.sockjs.transport.TransportType;
import org.springframework.web.util.UriComponentsBuilder;

public class SockJsClient
implements WebSocketClient,
Lifecycle {
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)SockJsClient.class.getClassLoader());
    private static final Log logger = LogFactory.getLog(SockJsClient.class);
    private InfoReceiver infoReceiver;
    private final List<Transport> transports;
    private SockJsMessageCodec messageCodec;
    private TaskScheduler connectTimeoutScheduler;
    private final Map<URI, ServerInfo> serverInfoCache = new ConcurrentHashMap<URI, ServerInfo>();
    private volatile boolean running = false;

    public SockJsClient(List<Transport> transports) {
        Assert.notEmpty(transports, (String)"No transports provided");
        this.infoReceiver = SockJsClient.initInfoReceiver(transports);
        this.transports = new ArrayList<Transport>(transports);
        if (jackson2Present) {
            this.messageCodec = new Jackson2SockJsMessageCodec();
        }
    }

    private static InfoReceiver initInfoReceiver(List<Transport> transports) {
        for (Transport transport : transports) {
            if (!(transport instanceof InfoReceiver)) continue;
            return (InfoReceiver)((Object)transport);
        }
        return new RestTemplateXhrTransport();
    }

    public void setInfoReceiver(InfoReceiver infoReceiver) {
        Assert.notNull((Object)infoReceiver, (String)"'infoReceiver' is required");
        this.infoReceiver = infoReceiver;
    }

    public InfoReceiver getInfoReceiver() {
        return this.infoReceiver;
    }

    public void setMessageCodec(SockJsMessageCodec messageCodec) {
        Assert.notNull((Object)messageCodec, (String)"'messageCodec' is required");
        this.messageCodec = messageCodec;
    }

    public SockJsMessageCodec getMessageCodec() {
        return this.messageCodec;
    }

    public void setConnectTimeoutScheduler(TaskScheduler connectTimeoutScheduler) {
        this.connectTimeoutScheduler = connectTimeoutScheduler;
    }

    public void start() {
        if (!this.isRunning()) {
            this.running = true;
            for (Transport transport : this.transports) {
                if (!(transport instanceof Lifecycle) || ((Lifecycle)transport).isRunning()) continue;
                ((Lifecycle)transport).start();
            }
        }
    }

    public void stop() {
        if (!this.isRunning()) {
            this.running = false;
            for (Transport transport : this.transports) {
                if (!(transport instanceof Lifecycle) || !((Lifecycle)transport).isRunning()) continue;
                ((Lifecycle)transport).stop();
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void clearServerInfoCache() {
        this.serverInfoCache.clear();
    }

    @Override
    public ListenableFuture<WebSocketSession> doHandshake(WebSocketHandler handler, String uriTemplate, Object ... uriVars) {
        Assert.notNull((Object)uriTemplate, (String)"uriTemplate must not be null");
        URI uri = UriComponentsBuilder.fromUriString((String)uriTemplate).buildAndExpand(uriVars).encode().toUri();
        return this.doHandshake(handler, null, uri);
    }

    @Override
    public final ListenableFuture<WebSocketSession> doHandshake(WebSocketHandler handler, WebSocketHttpHeaders headers, URI url) {
        Assert.notNull((Object)handler, (String)"'webSocketHandler' is required");
        Assert.notNull((Object)url, (String)"'url' is required");
        String scheme = url.getScheme();
        Assert.isTrue((scheme != null && ("ws".equals(scheme) || "wss".equals(scheme) || "http".equals(scheme) || "https".equals(scheme)) ? 1 : 0) != 0, (String)("Invalid scheme: " + scheme));
        SettableListenableFuture connectFuture = new SettableListenableFuture();
        try {
            SockJsUrlInfo sockJsUrlInfo = new SockJsUrlInfo(url);
            ServerInfo serverInfo = this.getServerInfo(sockJsUrlInfo);
            this.createRequest(sockJsUrlInfo, headers, serverInfo).connect(handler, (SettableListenableFuture<WebSocketSession>)connectFuture);
        }
        catch (Throwable exception) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Initial SockJS \"Info\" request to server failed, url=" + url), exception);
            }
            connectFuture.setException(exception);
        }
        return connectFuture;
    }

    private ServerInfo getServerInfo(SockJsUrlInfo sockJsUrlInfo) {
        URI infoUrl = sockJsUrlInfo.getInfoUrl();
        ServerInfo info = this.serverInfoCache.get(infoUrl);
        if (info == null) {
            long start = System.currentTimeMillis();
            String response = this.infoReceiver.executeInfoRequest(infoUrl);
            long infoRequestTime = System.currentTimeMillis() - start;
            info = new ServerInfo(response, infoRequestTime);
            this.serverInfoCache.put(infoUrl, info);
        }
        return info;
    }

    private DefaultTransportRequest createRequest(SockJsUrlInfo urlInfo, HttpHeaders headers, ServerInfo serverInfo) {
        ArrayList<DefaultTransportRequest> requests = new ArrayList<DefaultTransportRequest>(this.transports.size());
        for (Transport transport : this.transports) {
            for (TransportType type : transport.getTransportTypes()) {
                if (!serverInfo.isWebSocketEnabled() && TransportType.WEBSOCKET.equals((Object)type)) continue;
                requests.add(new DefaultTransportRequest(urlInfo, headers, transport, type, this.getMessageCodec()));
            }
        }
        Assert.notEmpty(requests, (String)("No transports, " + urlInfo + ", wsEnabled=" + serverInfo.isWebSocketEnabled()));
        for (int i = 0; i < requests.size() - 1; ++i) {
            DefaultTransportRequest request = (DefaultTransportRequest)requests.get(i);
            request.setUser(this.getUser());
            if (this.connectTimeoutScheduler != null) {
                request.setTimeoutValue(serverInfo.getRetransmissionTimeout());
                request.setTimeoutScheduler(this.connectTimeoutScheduler);
            }
            request.setFallbackRequest((DefaultTransportRequest)requests.get(i + 1));
        }
        return (DefaultTransportRequest)requests.get(0);
    }

    protected Principal getUser() {
        return null;
    }

    private static class ServerInfo {
        private final boolean webSocketEnabled;
        private final long responseTime;

        private ServerInfo(String response, long responseTime) {
            this.responseTime = responseTime;
            this.webSocketEnabled = !response.matches(".*[\"']websocket[\"']\\s*:\\s*false.*");
        }

        public boolean isWebSocketEnabled() {
            return this.webSocketEnabled;
        }

        public long getRetransmissionTimeout() {
            return this.responseTime > 100L ? 4L * this.responseTime : this.responseTime + 300L;
        }
    }
}

