/*
 * =============================================================================
 * 
 *   Copyright (c) 2011-2014, The THYMELEAF team (http://www.thymeleaf.org)
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 * 
 * =============================================================================
 */
package org.thymeleaf.standard.processor.attr;

/**
 * Used together with the <b>th:switch</b> attribute processor, identifies an
 * element to be rendered if its expression matches the result of the
 * <tt>th:switch</tt> expression.
 * 
 * @author Daniel Fern&aacute;ndez
 * @since 2.0.0
 */
public final class StandardCaseAttrProcessor 
        extends AbstractStandardCaseAttrProcessor {

    public static final int ATTR_PRECEDENCE = 275;
    public static final String ATTR_NAME = "case";
    
    
    
    public StandardCaseAttrProcessor() {
        super(ATTR_NAME);
    }

    
    
    @Override
    public int getPrecedence() {
        return ATTR_PRECEDENCE;
    }

    
    

    
}
