/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.benchmark;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.benchmark.BenchmarkConfig;
import org.ujmp.core.benchmark.CholBenchmarkTask;
import org.ujmp.core.benchmark.EigBenchmarkTask;
import org.ujmp.core.benchmark.InvBenchmarkTask;
import org.ujmp.core.benchmark.InvSPDBenchmarkTask;
import org.ujmp.core.benchmark.LUBenchmarkTask;
import org.ujmp.core.benchmark.MatrixBenchmark;
import org.ujmp.core.benchmark.MtimesBenchmarkTask;
import org.ujmp.core.benchmark.PlusMatrixBenchmarkTask;
import org.ujmp.core.benchmark.QRBenchmarkTask;
import org.ujmp.core.benchmark.SVDBenchmarkTask;
import org.ujmp.core.benchmark.SolveSquareBenchmarkTask;
import org.ujmp.core.benchmark.SolveTallBenchmarkTask;
import org.ujmp.core.benchmark.TimesScalarBenchmarkTask;
import org.ujmp.core.benchmark.TransposeBenchmarkTask;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.util.StringUtil;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMatrix2DBenchmark
implements MatrixBenchmark {
    private static final BenchmarkConfig config = new BenchmarkConfig();
    private static long benchmarkSeed = 3345454363676L;

    public abstract DoubleMatrix2D createMatrix(long ... var1);

    public abstract DoubleMatrix2D createMatrix(Matrix var1);

    public AbstractMatrix2DBenchmark() {
        benchmarkSeed = System.currentTimeMillis();
    }

    @Override
    public final String getMatrixLabel() {
        return this.createMatrix(1L, 1L).getClass().getSimpleName();
    }

    @Override
    public final Class<? extends DoubleMatrix2D> getMatrixClass() {
        return this.createMatrix(1L, 1L).getClass();
    }

    @Override
    public final BenchmarkConfig getConfig() {
        return config;
    }

    public void setName(String name) {
        config.setName(name);
    }

    @Override
    public final void run() {
        if (Runtime.getRuntime().maxMemory() < 943718400L) {
            throw new RuntimeException("You must start Java with more memory: -Xmx1024M");
        }
        int newMaxSize = (int)Math.sqrt(Runtime.getRuntime().maxMemory() / 24L);
        if (config.getMaxSize() > newMaxSize) {
            config.setMaxSize(newMaxSize);
        }
        System.out.println("===============================================================");
        System.out.println(" UJMP matrix benchmark");
        System.out.println("===============================================================");
        System.out.println(" Settings:");
        System.out.println("   numberOfThreads: " + config.getNumberOfThreads());
        System.out.println("   gcMemory: " + config.isGCMemory());
        System.out.println("   purgeMemory: " + config.isPurgeMemory());
        System.out.println("   burnInRuns: " + config.getBurnInRuns());
        System.out.println("   runs: " + config.getRuns());
        System.out.println("   maxTime: " + config.getMaxTime());
        System.out.println("   maxStd: " + config.getMaxStd());
        System.out.println("   minSize: " + Coordinates.toString("x", config.getSquareSizes().get(0)));
        System.out.println("   maxSize: " + Coordinates.toString("x", config.getSquareSizes().get(config.getSquareSizes().size() - 1)));
        System.out.println();
        try {
            System.out.println("===============================================================");
            System.out.println(this.createMatrix(1L, 1L).getClass().getSimpleName());
            System.out.println("===============================================================");
            long t0 = System.currentTimeMillis();
            UJMPSettings.getInstance().setUseCommonsMath(config.isUseCommonsMath());
            UJMPSettings.getInstance().setUseMTJ(config.isUseMTJ());
            UJMPSettings.getInstance().setUseEJML(config.isUseEJML());
            UJMPSettings.getInstance().setUseJBlas(config.isUseJBlas());
            UJMPSettings.getInstance().setUseOjalgo(config.isUseOjalgo());
            UJMPSettings.getInstance().setUseParallelColt(config.isUseParallelColt());
            UJMPSettings.getInstance().setUseBlockMatrixMultiply(config.isUseBlockMatrixMultiply());
            UJMPSettings.getInstance().setDefaultBlockSize(config.getDefaultBlockSize());
            if (config.isRunTimesScalar()) {
                new TimesScalarBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunPlusMatrix()) {
                new PlusMatrixBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunTranspose()) {
                new TransposeBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunMtimes()) {
                new MtimesBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunInv()) {
                new InvBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunInvSPD()) {
                new InvSPDBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunSolveSquare()) {
                new SolveSquareBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunSolveTall()) {
                new SolveTallBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunSVD()) {
                new SVDBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunEig()) {
                new EigBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunChol()) {
                new CholBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunLU()) {
                new LUBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            if (config.isRunQR()) {
                new QRBenchmarkTask(benchmarkSeed, this.getMatrixClass(), this.getConfig()).run();
            }
            long t1 = System.currentTimeMillis();
            System.out.println();
            System.out.println("Benchmark runtime: " + StringUtil.duration(t1 - t0));
            System.out.println();
        }
        catch (UnsupportedClassVersionError e) {
            System.out.println("this library is not compatible with the current Java version");
            System.out.println("it cannot be included in the benchmark");
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("there was some error with this library");
            System.out.println("it cannot be included in the benchmark");
            e.printStackTrace();
        }
    }
}

