/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bigintegermatrix.impl;

import java.math.BigInteger;
import java.util.Arrays;
import org.ujmp.core.bigintegermatrix.stub.AbstractDenseBigIntegerMatrix2D;

public class DefaultDenseBigIntegerMatrix2D
extends AbstractDenseBigIntegerMatrix2D {
    private static final long serialVersionUID = 443424906231157395L;
    private final BigInteger[] values;
    private final int rows;
    private final int cols;

    public DefaultDenseBigIntegerMatrix2D(int rows, int cols) {
        super((long)rows, (long)cols);
        this.rows = rows;
        this.cols = cols;
        this.values = new BigInteger[rows * cols];
        Arrays.fill(this.values, BigInteger.ZERO);
    }

    public DefaultDenseBigIntegerMatrix2D(BigInteger[] v, int rows, int cols) {
        super((long)rows, (long)cols);
        this.rows = rows;
        this.cols = cols;
        this.values = v;
    }

    public BigInteger getBigInteger(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    public void setBigInteger(BigInteger value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    public BigInteger getBigInteger(int row, int column) {
        return this.values[column * this.rows + row];
    }

    public void setBigInteger(BigInteger value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }
}

