/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.DenseMatrix2D;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.DivideScalar;
import org.ujmp.core.calculation.DivideScalarCalculation;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DivideScalarDenseMatrix
implements DivideScalarCalculation<DenseMatrix, DenseMatrix> {
    DivideScalarDenseMatrix() {
    }

    @Override
    public final void calc(DenseMatrix source, BigDecimal divisor, DenseMatrix target) {
        if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            DivideScalar.DENSEMATRIX2D.calc((DenseMatrix2D)source, divisor, (DenseMatrix2D)target);
        } else {
            MapMatrix<String, Object> a;
            VerifyUtil.verifySameSize((Matrix)source, (Matrix)target);
            for (long[] c : source.allCoordinates()) {
                BigDecimal value = source.getAsBigDecimal(c);
                BigDecimal result = MathUtil.divide(value, divisor);
                target.setAsBigDecimal(result, c);
            }
            if (source != target && (a = source.getMetaData()) != null) {
                target.setMetaData(a.clone());
            }
        }
    }

    @Override
    public final void calc(DenseMatrix source, double divisor, DenseMatrix target) {
        if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            DivideScalar.DENSEMATRIX2D.calc((DenseMatrix2D)source, divisor, (DenseMatrix2D)target);
        } else {
            this.calc(source, new BigDecimal(divisor, UJMPSettings.getInstance().getMathContext()), target);
        }
    }
}

