/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.DenseMatrix;
import org.ujmp.core.DenseMatrix2D;
import org.ujmp.core.Matrix;
import org.ujmp.core.SparseMatrix;
import org.ujmp.core.calculation.Mtimes;
import org.ujmp.core.calculation.MtimesCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.util.VerifyUtil;
import org.ujmp.core.util.concurrent.PFor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MtimesMatrix
implements MtimesCalculation<Matrix, Matrix, Matrix> {
    MtimesMatrix() {
    }

    @Override
    public final void calc(Matrix source1, Matrix source2, Matrix target) {
        if (source1.isSparse() && source1 instanceof SparseMatrix && source2.isSparse() && source2 instanceof SparseMatrix) {
            Mtimes.SPARSEMATRIXBOTH.calc((SparseMatrix)source1, (SparseMatrix)source2, target);
        } else if (source1.isSparse() && source1 instanceof SparseMatrix) {
            Mtimes.SPARSEMATRIX1.calc((SparseMatrix)source1, source2, target);
        } else if (source2.isSparse() && source2 instanceof SparseMatrix) {
            Mtimes.SPARSEMATRIX2.calc(source1, (SparseMatrix)source2, target);
        } else if (source1 instanceof DenseDoubleMatrix2D && source2 instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
            Mtimes.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source1, (DenseDoubleMatrix2D)source2, (DenseDoubleMatrix2D)target);
        } else if (source1 instanceof DenseMatrix2D && source2 instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            Mtimes.DENSEMATRIX2D.calc((DenseMatrix2D)source1, (DenseMatrix2D)source2, (DenseMatrix2D)target);
        } else if (source1 instanceof DenseMatrix && source2 instanceof DenseMatrix && target instanceof DenseMatrix) {
            Mtimes.DENSEMATRIX.calc((DenseMatrix)source1, (DenseMatrix)source2, (DenseMatrix)target);
        } else {
            this.gemm(source1, source2, target);
        }
    }

    private final void gemm(final Matrix A, final Matrix B, final Matrix C) {
        VerifyUtil.verify2D(A);
        VerifyUtil.verify2D(B);
        VerifyUtil.verify2D(C);
        final int m1RowCount = (int)A.getRowCount();
        final int m1ColumnCount = (int)A.getColumnCount();
        int m2RowCount = (int)B.getRowCount();
        int m2ColumnCount = (int)B.getColumnCount();
        VerifyUtil.verifyEquals(m1ColumnCount, m2RowCount, "matrices have wrong sizes");
        VerifyUtil.verifyEquals((long)m1RowCount, C.getRowCount(), "matrices have wrong sizes");
        VerifyUtil.verifyEquals((long)m2ColumnCount, C.getColumnCount(), "matrices have wrong sizes");
        if (m1RowCount >= Mtimes.THRESHOLD && m1ColumnCount >= Mtimes.THRESHOLD && m2ColumnCount >= Mtimes.THRESHOLD) {
            new PFor(0, m2ColumnCount - 1){

                public void step(int i) {
                    for (int irow = 0; irow < m1RowCount; ++irow) {
                        C.setAsDouble(0.0, irow, i);
                    }
                    for (int lcol = 0; lcol < m1ColumnCount; ++lcol) {
                        double temp = B.getAsDouble(lcol, i);
                        if (temp == 0.0) continue;
                        for (int irow = 0; irow < m1RowCount; ++irow) {
                            C.setAsDouble(C.getAsDouble(irow, i) + A.getAsDouble(irow, lcol) * temp, irow, i);
                        }
                    }
                }
            };
        } else {
            for (int i = 0; i < m2ColumnCount; ++i) {
                for (int irow = 0; irow < m1RowCount; ++irow) {
                    C.setAsDouble(0.0, irow, i);
                }
                for (int lcol = 0; lcol < m1ColumnCount; ++lcol) {
                    double temp = B.getAsDouble(lcol, i);
                    if (temp == 0.0) continue;
                    for (int irow = 0; irow < m1RowCount; ++irow) {
                        C.setAsDouble(C.getAsDouble(irow, i) + A.getAsDouble(irow, lcol) * temp, irow, i);
                    }
                }
            }
        }
    }
}

