/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.util.MathUtil;

public class Diff
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 7565251430714359410L;
    private boolean ignoreNaN = true;

    public Diff(int dimension, boolean ignoreNaN, Matrix source) {
        super(dimension, source);
        this.ignoreNaN = ignoreNaN;
    }

    public double getDouble(long ... coordinates) {
        double v1 = 0.0;
        double v2 = 0.0;
        switch (this.getDimension()) {
            case 0: {
                v1 = this.getSource().getAsDouble(coordinates[0], coordinates[1]);
                v2 = this.getSource().getAsDouble(coordinates[0] + 1L, coordinates[1]);
                break;
            }
            case 1: {
                v1 = this.getSource().getAsDouble(coordinates[0], coordinates[1]);
                v2 = this.getSource().getAsDouble(coordinates[0], coordinates[1] + 1L);
                break;
            }
            default: {
                throw new RuntimeException("not possible for this dimension");
            }
        }
        if (this.ignoreNaN && (MathUtil.isNaNOrInfinite(v1) || MathUtil.isNaNOrInfinite(v2))) {
            return 0.0;
        }
        return v2 - v1;
    }

    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{this.getSource().getRowCount() - 1L, this.getSource().getColumnCount()};
            }
            case 1: {
                return new long[]{this.getSource().getRowCount(), this.getSource().getColumnCount() - 1L};
            }
        }
        throw new RuntimeException("not possible for this dimension");
    }
}

