/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.longmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.longmatrix.LongMatrix;
import org.ujmp.core.longmatrix.calculation.LongCalculation;
import org.ujmp.core.longmatrix.impl.LongCalculationMatrix;

public abstract class AbstractLongCalculation
extends AbstractCalculation
implements LongCalculation {
    private static final long serialVersionUID = -2401843008270253704L;

    public AbstractLongCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractLongCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final LongMatrix calcLink() {
        return new LongCalculationMatrix(this);
    }

    public final LongMatrix calcNew() {
        LongMatrix result = (LongMatrix)Matrix.Factory.zeros(ValueType.LONG, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsLong(this.getLong(c), c);
        }
        if (this.getMetaData() != null) {
            result.setMetaData(this.getMetaData().clone());
        }
        return result;
    }

    public final Matrix calcOrig() {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new RuntimeException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsLong(this.getLong(c), c);
        }
        this.getSource().fireValueChanged();
        return this.getSource();
    }

    public void setLong(long value, long ... coordinates) {
    }

    public final ValueType getValueType() {
        return ValueType.LONG;
    }
}

