/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.TreeMap;
import org.ujmp.core.Coordinates;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;

public class IncludeAnnotation
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -2165678807795583946L;
    private long[] size = null;

    public IncludeAnnotation(Matrix m, int dim) {
        super(dim, m);
        this.size = Coordinates.copyOf(m.getSize());
        int n = dim;
        this.size[n] = this.size[n] + 1L;
        this.setMetaData(new DefaultMapMatrix<String, Object>(new TreeMap()));
        this.getMetaData().put("Label", m.getLabelObject());
    }

    public Object getObject(long ... coordinates) {
        if ((coordinates = Coordinates.copyOf(coordinates))[this.getDimension()] == 0L) {
            if (this.getDimension() == 0) {
                return this.getSource().getDimensionMetaData(0, coordinates);
            }
            if (this.getDimension() == 1) {
                return this.getSource().getDimensionMetaData(1, coordinates);
            }
            throw new RuntimeException("only possible for Matrix.ROW and Matrix.COLUMN");
        }
        int n = this.getDimension();
        coordinates[n] = coordinates[n] - 1L;
        return this.getSource().getAsObject(coordinates);
    }

    public long[] getSize() {
        return this.size;
    }

    public static void main(String[] args) throws Exception {
        DenseMatrix m = Matrix.Factory.zeros(ValueType.OBJECT, 5L, 5L);
        m.randn(Calculation.Ret.ORIG);
        m.setLabel("test");
        m.setColumnLabel(0L, "col0");
        m.setColumnLabel(1L, "col1");
        m.setColumnLabel(2L, "col2");
        m.setColumnLabel(3L, "col3");
        m.setColumnLabel(4L, "col4");
        m.setRowLabel(0L, "row0");
        m.setRowLabel(1L, "row1");
        m.setRowLabel(2L, "row2");
        m.setRowLabel(3L, "row3");
        m.setRowLabel(4L, "row4");
        m.setAsDouble(Double.NaN, 2L, 2L);
        m.setAsDouble(Double.NEGATIVE_INFINITY, 3L, 2L);
        System.out.println(m);
        System.out.println(m.includeAnnotation(Calculation.Ret.NEW, 1));
    }
}

