/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.ujmp.core.Matrix;

public class GnuPlot {
    public static String[] SEARCH = new String[0];
    private static String pathToGnuPlot;
    private BufferedReader input = null;
    private BufferedWriter output = null;
    private BufferedReader error = null;
    private Process gnuPlotProcess = null;
    private boolean running = false;
    private static GnuPlot gnuPlot;
    private static File matrixFile;

    public static GnuPlot getInstance() throws Exception {
        if (gnuPlot == null) {
            gnuPlot = GnuPlot.getInstance(GnuPlot.findGnuPlot());
        }
        return gnuPlot;
    }

    private static String findGnuPlot() {
        if (pathToGnuPlot == null) {
            File file = null;
            for (String s : SEARCH) {
                if (s == null || !(file = new File(s)).exists()) continue;
                pathToGnuPlot = file.getAbsolutePath();
                return pathToGnuPlot;
            }
        }
        return pathToGnuPlot;
    }

    public static synchronized GnuPlot getInstance(String pathToGnuPlot) throws Exception {
        if (gnuPlot == null) {
            gnuPlot = new GnuPlot(pathToGnuPlot);
        }
        return gnuPlot;
    }

    private GnuPlot(String pathToGnuPlot) throws Exception {
        matrixFile = new File(System.getProperty("java.io.tmpdir") + File.separator + "gnuplot.csv");
        matrixFile.deleteOnExit();
        this.gnuPlotProcess = Runtime.getRuntime().exec(pathToGnuPlot);
        this.output = new BufferedWriter(new OutputStreamWriter(this.gnuPlotProcess.getOutputStream()));
        this.input = new BufferedReader(new InputStreamReader(this.gnuPlotProcess.getInputStream()));
        this.error = new BufferedReader(new InputStreamReader(this.gnuPlotProcess.getErrorStream()));
        this.running = true;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized String getFromGnuPlot() throws Exception {
        endSeen = false;
        sb = new StringBuilder();
        block0: while (true) {
            if (!this.input.ready()) {
                Thread.yield();
                continue;
            }
            while (true) {
                if (this.input.ready()) ** break;
                continue block0;
                c = (char)this.input.read();
                sb.append(c);
                if (c == '>') {
                    if (endSeen) {
                        return sb.substring(0, sb.length() - 2);
                    }
                    endSeen = true;
                    continue;
                }
                endSeen = false;
            }
            break;
        }
    }

    public void execute(String command) throws Exception {
        this.sendToGnuPlot(command);
    }

    public synchronized void shutdown() throws Exception {
        this.sendToGnuPlot("exit");
        this.gnuPlotProcess.waitFor();
        this.output.close();
        this.input.close();
    }

    private synchronized void sendToGnuPlot(String command) throws Exception {
        if (!command.endsWith("\n")) {
            command = command + "\n";
        }
        this.output.write(command, 0, command.length());
        this.output.flush();
    }

    public void setMatrix(String label, Matrix matrix) throws Exception {
        String script = matrix.exportTo().string().asMatlabScript(label);
        this.execute(script);
    }

    public static boolean isAvailable() {
        return GnuPlot.findGnuPlot() != null;
    }

    public void plot(Matrix matrix, String ... format) throws Exception {
        matrix.exportTo().file(matrixFile).asDenseCSV();
        this.execute(GnuPlot.getPlotCommand(matrix, true, true));
    }

    public static String getPlotCommand(Matrix matrix, boolean withlines, boolean withpoints) {
        String command = "";
        command = command + "set autoscale; ";
        command = command + "unset log; ";
        command = command + "unset label; ";
        command = command + "set xtic auto; ";
        command = command + "set ytic auto; ";
        command = command + "set xlabel 'Column 0'; ";
        command = command + "plot";
        int c = 1;
        while ((long)c < matrix.getColumnCount()) {
            command = command + " \"" + matrixFile + "\" using 1:" + (c + 1) + " title 'Column " + c + "' ";
            if (withlines && !withpoints) {
                command = command + " with lines ";
            } else if (withlines && withpoints) {
                command = command + " with linespoints ";
            }
            if ((long)c < matrix.getColumnCount() - 1L) {
                command = command + ",";
            }
            ++c;
        }
        return command;
    }

    public void scatterPlot(Matrix matrix, String ... format) throws Exception {
        matrix.exportTo().file(matrixFile).asDenseCSV();
        this.execute(GnuPlot.getPlotCommand(matrix, false, false));
    }

    public static String toString(String[] strings) {
        if (strings.length != 0) {
            return ",'" + strings[0] + "'";
        }
        return "";
    }

    public void exportToPS(File file, Object ... parameters) throws Exception {
        String command = "";
        command = command + "set terminal postscript landscape;";
        command = command + "set output \"" + file + "\";";
        command = command + "replot;";
        command = "Linux".equals(System.getProperty("os.name")) ? command + "set terminal x11;" : command + "set terminal windows;";
        this.execute(command);
    }

    public void exportToPNG(File file, Object ... parameters) throws Exception {
        String command = "";
        command = command + "set terminal png;";
        command = command + "set output \"" + file + "\";";
        command = command + "replot;";
        command = "Linux".equals(System.getProperty("os.name")) ? command + "set terminal x11;" : command + "set terminal windows;";
        this.execute(command);
    }

    public void exportToFIG(File file, Object ... parameters) throws Exception {
        String command = "";
        command = command + "set terminal fig;";
        command = command + "set output \"" + file + "\";";
        command = command + "replot;";
        command = "Linux".equals(System.getProperty("os.name")) ? command + "set terminal x11;" : command + "set terminal windows;";
        this.execute(command);
    }

    public void exportToSVG(File file, Object ... parameters) throws Exception {
        String command = "";
        command = command + "set terminal svg;";
        command = command + "set output \"" + file + "\";";
        command = command + "replot;";
        command = "Linux".equals(System.getProperty("os.name")) ? command + "set terminal x11;" : command + "set terminal windows;";
        this.execute(command);
    }

    static {
        try {
            SEARCH = new String[]{System.getProperty("GnuPlot"), System.getProperty("user.home") + "/gnuplot/bin/gnuplot", "/usr/bin/gnuplot"};
        }
        catch (Exception exception) {
            // empty catch block
        }
        pathToGnuPlot = null;
        gnuPlot = null;
        matrixFile = null;
    }
}

