/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.io.temp.impl;

import java.io.File;
import java.io.IOException;
import org.unitils.core.UnitilsException;
import org.unitils.io.temp.TempService;
import org.unitils.thirdparty.org.apache.commons.io.FileUtils;

public class DefaultTempService
implements TempService {
    protected File rootTempDir;

    public DefaultTempService(File rootTempDir) {
        this.rootTempDir = rootTempDir;
    }

    public File createTempDir(String dirName) {
        File dir = new File(this.rootTempDir, dirName);
        this.deleteTempFileOrDir(dir);
        boolean success = dir.mkdirs();
        if (!success) {
            throw new UnitilsException("Unable to create temp dir " + dirName + " in folder " + this.rootTempDir.getAbsolutePath());
        }
        return dir;
    }

    public File createTempFile(String fileName) {
        try {
            File file = new File(this.rootTempDir, fileName);
            this.deleteTempFileOrDir(file);
            this.rootTempDir.mkdirs();
            file.createNewFile();
            return file;
        }
        catch (IOException e) {
            throw new UnitilsException("Unable to create temp file " + fileName + " in folder " + this.rootTempDir.getAbsolutePath(), (Throwable)e);
        }
    }

    public void deleteTempFileOrDir(File fileOrDir) {
        if (fileOrDir == null || !fileOrDir.exists()) {
            return;
        }
        try {
            FileUtils.forceDelete((File)fileOrDir);
        }
        catch (IOException e) {
            throw new UnitilsException("Unable to delete temp file/dir " + fileOrDir.getAbsolutePath());
        }
    }
}

