/*
 * Decompiled with CFR 0.152.
 */
package org.weixin4j.spring;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.weixin4j.spi.DefaultMessageHandler;
import org.weixin4j.spi.HandlerFactory;
import org.weixin4j.spi.IEventMessageHandler;
import org.weixin4j.spi.IMessageHandler;
import org.weixin4j.spi.INormalMessageHandler;

public class MessageFactoryBean
implements FactoryBean<IMessageHandler>,
InitializingBean {
    private IMessageHandler messageHandler;
    private INormalMessageHandler normalMessageHandler;
    private IEventMessageHandler eventMessageHandler;

    public void setNormalMessageHandler(INormalMessageHandler normalMessageHandler) {
        this.normalMessageHandler = normalMessageHandler;
    }

    public void setEventMessageHandler(IEventMessageHandler eventMessageHandler) {
        this.eventMessageHandler = eventMessageHandler;
    }

    public IMessageHandler getObject() throws Exception {
        if (this.messageHandler == null) {
            this.afterPropertiesSet();
        }
        return this.messageHandler;
    }

    public Class<?> getObjectType() {
        return this.messageHandler == null ? IMessageHandler.class : this.messageHandler.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.normalMessageHandler == null) {
            this.normalMessageHandler = HandlerFactory.getNormalMessageHandler();
        }
        if (this.eventMessageHandler == null) {
            this.eventMessageHandler = HandlerFactory.getEventMessageHandler();
        }
        System.out.println("MessageFactoryBean.afterPropertiesSet." + this.normalMessageHandler.getClass().getName());
        System.out.println("MessageFactoryBean.afterPropertiesSet." + this.eventMessageHandler.getClass().getName());
        this.messageHandler = new DefaultMessageHandler(this.normalMessageHandler, this.eventMessageHandler);
    }
}

